# Como Usar o Modal Genérico

O `modal_generico.php` é um sistema completo de CRUD (Create, Read, Update, Delete) que pode ser usado com qualquer tabela do sistema.

## Funcionalidades

- ✅ **Edição inline**: Clique em qualquer célula para editar
- ✅ **Inserção de novos registros**: Botão "Novo Registro"
- ✅ **Exclusão de registros**: Botão de lixeira com confirmação
- ✅ **Formatação automática**: Valores monetários e datas
- ✅ **Máscaras de entrada**: Para valores e datas
- ✅ **Validação**: Campos obrigatórios
- ✅ **Responsivo**: Funciona em dispositivos móveis
- ✅ **DataTables**: Paginação, busca e ordenação

## Como Usar

### 1. Configuração Básica

Para usar o modal genérico, você precisa apenas incluir o arquivo e definir algumas variáveis:

```php
<?php
// Incluir o modal genérico
include 'modal_generico.php';

// Configurar parâmetros
$tabela = 'nome_da_tabela';           // Nome da tabela no banco
$id_pai = 0;                          // ID do registro pai (se houver)
$campo_pai = '';                      // Nome do campo que referencia o pai
?>
```

### 2. Exemplos de Uso

#### Vendas (com registro pai)
```php
$tabela = 'vendas';
$id_pai = $_GET['id_pedido'] ?? 0;    // ID do pedido
$campo_pai = 'id_pedido';             // Campo que referencia o pedido
```

#### Pedidos (sem registro pai)
```php
$tabela = 'pedidos';
$id_pai = 0;                          // Sem pai
$campo_pai = '';                      // Sem campo pai
```

#### Financeiro de Clientes
```php
$tabela = 'financeiro_clientes';
$id_pai = $_GET['id_cliente'] ?? 0;   // ID do cliente
$campo_pai = 'id_cliente';            // Campo que referencia o cliente
```

### 3. Configuração de Campos

O modal genérico detecta automaticamente os campos da tabela e aplica as configurações apropriadas:

#### Tipos de Campo Suportados:
- **text**: Campos de texto simples
- **money**: Valores monetários (com máscara R$ 0.000,00)
- **date**: Datas (com seletor de data)

#### Configurações Automáticas por Tabela:

**Vendas:**
- `produto`: Texto obrigatório
- `valor`: Valor monetário obrigatório
- `data_venda`: Data obrigatória

**Pedidos:**
- `cliente`: Texto obrigatório
- `produto`: Texto obrigatório
- `quantidade`: Texto obrigatório
- `valor_total`: Valor monetário obrigatório
- `data_pedido`: Data obrigatória

**Financeiro Clientes:**
- `descricao`: Texto obrigatório
- `valor`: Valor monetário obrigatório
- `data_vencimento`: Data obrigatória
- `status`: Texto obrigatório

### 4. Estrutura HTML Necessária

O arquivo que usa o modal genérico deve ter a estrutura HTML básica:

```html
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Título da Página</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>
    <div class="container-fluid mt-4">
        <!-- O conteúdo do modal genérico será exibido automaticamente -->
    </div>
</body>
</html>
```

### 5. Adicionando Novas Tabelas

Para adicionar suporte a uma nova tabela:

1. **Adicione a tabela na lista de tabelas permitidas** (linha ~15 do modal_generico.php):
```php
$tabelasPermitidas = ['vendas', 'financeiro_clientes', 'pedidos', 'usuarios', 'produtos', 'nova_tabela'];
```

2. **Configure os campos** na função `obterConfigCampos()` (linha ~180):
```php
case 'nova_tabela':
    return [
        'titulo' => 'Gerenciar Nova Tabela',
        'campos' => [
            'campo1' => ['label' => 'Campo 1', 'tipo' => 'text', 'obrigatorio' => true],
            'campo2' => ['label' => 'Campo 2', 'tipo' => 'money', 'obrigatorio' => true],
            'campo3' => ['label' => 'Campo 3', 'tipo' => 'date', 'obrigatorio' => false]
        ]
    ];
```

### 6. Segurança

- ✅ **Proteção contra SQL Injection**: Uso de prepared statements
- ✅ **Validação de tabelas**: Apenas tabelas permitidas
- ✅ **Sanitização de dados**: htmlspecialchars nos outputs
- ✅ **Validação de campos**: Campos obrigatórios

### 7. Dependências

- **jQuery 3.6.0+**
- **Bootstrap 5.1.3+**
- **Font Awesome 6.0.0+**
- **DataTables 1.13.7+**
- **SweetAlert2 11+**

### 8. Arquivos de Exemplo

- `exemplo_modal_vendas.php`: Exemplo para vendas
- `exemplo_modal_pedidos.php`: Exemplo para pedidos
- `exemplo_modal_financeiro.php`: Exemplo para financeiro de clientes

### 9. Funcionalidades Avançadas

#### Edição Inline
- Clique em qualquer célula para editar
- Máscaras automáticas para valores monetários
- Validação em tempo real
- Cancelamento com ESC

#### Formatação Automática
- Valores monetários: R$ 1.234,56
- Datas: DD/MM/AAAA
- Campos obrigatórios destacados

#### DataTables
- Busca global
- Ordenação por colunas
- Paginação automática
- Responsivo

### 10. Troubleshooting

**Problema**: Tabela não aparece
**Solução**: Verifique se a tabela está na lista de tabelas permitidas

**Problema**: Campos não formatam corretamente
**Solução**: Verifique a configuração dos campos na função `obterConfigCampos()`

**Problema**: Erro de banco de dados
**Solução**: Verifique se a conexão com o banco está funcionando e se as tabelas existem

---

## Conclusão

O modal genérico simplifica drasticamente a criação de interfaces CRUD, eliminando a necessidade de código repetitivo e fornecendo uma experiência de usuário consistente em todo o sistema.