$(function() {

  var $grid = $('.grid');
  $grid.isotope({
    itemSelector: '.demanda-item'
  });

  var filters = []; // A convenient bucket for all the filter options, 

  // Search event handlers   || AUTO-SEARCH ||
  

  $('.quicksearch').on('keyup',function() {
      // debounce removed for brevity, but you'd put it here
      filters[0] = this.value;
      runFilter();
    });
      /*
  || ON-CLICK-SEARCH ||
  $('#fname').on('click',function() {
      // debounce removed for brevity, but you'd put it here
      filters[0] = this.value;
      runFilter();
    });
  || ENTER-KEY-SEARCH ||
  $('#search').on('keyup',function(e) {
      // debounce removed for brevity, but you'd put it here
      if (e.keyCode === 13) {
      filters[0] = this.value;
      runFilter();
      }
    });

  // BUTTON-SEARCH 
  $('#btn').on('click', function() {
      filters[0] = $('#search')[0].value;
      runFilter();
  });
  */
  $('#filter-select1').on('change', function() {
    filters[1] = this.value;
    runFilter();
  });

  $('#filter-select2').on('change', function() {
    filters[2] = this.value;
    runFilter();
  });

  $('#filter-select3').on('change', function() {
    filters[3] = this.value;
    runFilter();
  });

  $('#filter-select4').on('change', function() {
    filters[4] = this.value;
    runFilter();
  });

  // and so on if more filters needed

  // The filter itself
  var runFilter = function() {
    $grid.isotope({
      filter: function() {
        if (filters[0]) {
          // at least some search text was entered:
          var qsRegex = new RegExp(filters[0], 'gi');

          // if the title doesn't match, eliminate it:
          if (!$(this).find('.content-title').text().match(qsRegex)) {
            return false;
          }
        }

        if (filters[1]) {
          // a category 1 was selected; filter out others:
          if (!($(this).hasClass(filters[1]))) {
            return false;
          }
        }

        if (filters[2]) {
          // a category 2 was selected; filter out others:
          if (!($(this).hasClass(filters[2]))) {
            return false;
          }
        }

        if (filters[3]) {
          // a category 3 was selected; filter out others:
          if (!($(this).hasClass(filters[3]))) {
            return false;
          }
        }

        if (filters[4]) {
          // a category 4 was selected; filter out others:
          if (!($(this).hasClass(filters[4]))) {
            return false;
          }
        }
        // etcetera, for any other filters 

        // successfully passed all conditions, so:
        return true;
      }
    });
  }
});