<?php
// Incluir configuração do banco de dados
require_once 'dbconfig.php';

header('Content-Type: application/json; charset=utf-8');

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Método não permitido'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Verificar se os parâmetros necessários foram enviados
if (!isset($_POST['id_cliente']) || !isset($_POST['id_empresa'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Parâmetros obrigatórios não informados'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$id_cliente = (int) $_POST['id_cliente'];
$id_empresa = (int) $_POST['id_empresa'];

// Validar IDs
if ($id_cliente <= 0 || $id_empresa <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'IDs inválidos'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    // Verificar se o cliente existe
    $stmt = $conn->prepare("SELECT nome FROM usuarios WHERE id = ?");
    $stmt->bind_param("i", $id_cliente);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode([
            'success' => false,
            'message' => 'Cliente não encontrado'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    $cliente = $result->fetch_assoc();
    
    // Verificar se a empresa existe
    $stmt = $conn->prepare("SELECT empresa FROM empresas WHERE id = ?");
    $stmt->bind_param("i", $id_empresa);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode([
            'success' => false,
            'message' => 'Empresa não encontrada'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    $empresa = $result->fetch_assoc();
    
    // Atualizar a empresa do cliente
    $stmt = $conn->prepare("UPDATE usuarios SET id_empresa = ? WHERE id = ?");
    $stmt->bind_param("ii", $id_empresa, $id_cliente);
    
    if ($stmt->execute()) {
        // Log da alteração (opcional)
        error_log("Empresa do cliente {$cliente['nome']} (ID: {$id_cliente}) alterada para {$empresa['empresa']} (ID: {$id_empresa})");
        
        echo json_encode([
            'success' => true,
            'message' => 'Empresa atualizada com sucesso',
            'cliente' => $cliente['nome'],
            'empresa' => $empresa['empresa']
        ], JSON_UNESCAPED_UNICODE);
    } else {
        throw new Exception('Erro ao executar update: ' . $stmt->error);
    }
    
} catch (Exception $e) {
    error_log('Erro ao atualizar empresa do cliente: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro interno do servidor'
    ], JSON_UNESCAPED_UNICODE);
}
?>
