<?php
require_once 'dbconfig.php';

// Verificar se a requisição é via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método não permitido']);
    exit;
}

// Verificar se os dados necessários foram enviados
if (!isset($_POST['id_pedido']) || !isset($_POST['id_empresa'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Dados incompletos']);
    exit;
}

$id_pedido = intval($_POST['id_pedido']);
$id_empresa = intval($_POST['id_empresa']);

try {
    // Primeiro, buscar o id_cliente do pedido
    $stmt_cliente = $conn->prepare("SELECT id_cliente FROM pedidos WHERE id = ?");
    $stmt_cliente->bind_param("i", $id_pedido);
    $stmt_cliente->execute();
    $result_cliente = $stmt_cliente->get_result();
    
    if ($row_cliente = $result_cliente->fetch_assoc()) {
        $id_cliente = $row_cliente['id_cliente'];
        
        // Atualizar a empresa do usuário (cliente)
        $stmt = $conn->prepare("UPDATE usuarios SET id_empresa = ? WHERE id = ?");
        $stmt->bind_param("ii", $id_empresa, $id_cliente);
        
        if ($stmt->execute()) {
            // Buscar o nome da nova empresa
            $stmt_empresa = $conn->prepare("SELECT empresa FROM empresas WHERE id = ?");
            $stmt_empresa->bind_param("i", $id_empresa);
            $stmt_empresa->execute();
            $result = $stmt_empresa->get_result();
            
            if ($row = $result->fetch_assoc()) {
                echo json_encode([
                    'success' => true,
                    'empresa_nome' => $row['empresa']
                ]);
            } else {
                echo json_encode(['error' => 'Empresa não encontrada']);
            }
            
            $stmt_empresa->close();
        } else {
            echo json_encode(['error' => 'Erro ao atualizar empresa do cliente']);
        }
        
        $stmt->close();
    } else {
        echo json_encode(['error' => 'Pedido não encontrado']);
    }
    
    $stmt_cliente->close();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor']);
}

$conn->close();
?>
