<?php
/*
BACKUP DO CÓDIGO ORIGINAL - MANTIDO PARA REFERÊNCIA

Este arquivo contém o código original antes da otimização.
O problema principal era o N+1 query problem onde cada linha da tabela
executava múltiplas consultas SQL separadas.

PROBLEMAS IDENTIFICADOS:
1. N+1 Query Problem - Para cada pedido, executava 3-5 consultas adicionais
2. Consultas desnecessárias repetitivas para o mesmo dado
3. Uso de fetch_array() limitando resultados ao primeiro registro
4. Código complexo e repetitivo para cálculos

SOLUÇÕES IMPLEMENTADAS:
1. Single Query com JOINs otimizados
2. Cálculos feitos em PHP ao invés de múltiplas queries
3. Uso de LEFT JOINs para evitar dados perdidos
4. Simplificação da lógica de cálculo
5. DataTables otimizado com paginação e busca por coluna
6. Opção de server-side processing para datasets muito grandes

PERFORMANCE ESPERADA:
- Redução de ~90% no número de queries executadas
- Carregamento 5-10x mais rápido dependendo do volume de dados
- Menor uso de CPU e memória do servidor
- Melhor experiência do usuário

*/

// CÓDIGO ORIGINAL (COMENTADO):
/*
$sqlpedidos = mysqli_query($conn,"SELECT * FROM pedidos order by id ASC");
while ($pedidos = mysqli_fetch_array($sqlpedidos)) {
    $id_cliente = $pedidos[id_cliente];
    $id_cliente_nome = mysqli_query($conn,"SELECT nome FROM usuarios WHERE id=$id_cliente")->fetch_assoc();
    $id_cliente_empresa = mysqli_query($conn,"SELECT id_empresa FROM usuarios WHERE id=$id_cliente")->fetch_assoc();
    $id_empresa_nome = mysqli_query($conn,"SELECT empresa FROM empresas WHERE id=$id_cliente_empresa[id_empresa]")->fetch_assoc();
    
    $id_pedido = $pedidos[id];
    $sqlvendas = mysqli_query($conn,"SELECT vendas.*, SUM(vendas.valor) AS total FROM vendas WHERE vendas.id_pedido=$id_pedido order by vendas.id ASC");
    $sqlfinanceiro_clientes = mysqli_query($conn,"SELECT financeiro_clientes.*, SUM(financeiro_clientes.valor) AS total FROM financeiro_clientes WHERE financeiro_clientes.id_pedido=$id_pedido order by financeiro_clientes.id ASC");
    
    // Múltiplas consultas adicionais para cálculos...
}
*/
?>
