<?php
// Debug inicial
error_log("buscar_empresas.php chamado - método: " . $_SERVER['REQUEST_METHOD']);

require_once 'dbconfig.php';

// Adicionar headers para debug
header('Content-Type: application/json');

// Verificar se a requisição é via GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    error_log("Método não permitido: " . $_SERVER['REQUEST_METHOD']);
    http_response_code(405);
    echo json_encode(['error' => 'Método não permitido - recebido: ' . $_SERVER['REQUEST_METHOD']]);
    exit;
}

try {
    // Verificar se a conexão com o banco está funcionando
    if (!$conn) {
        error_log("Conexão com banco falhou");
        throw new Exception('Conexão com banco de dados falhou');
    }
    
    error_log("Executando query para buscar empresas");
    
    // Buscar todas as empresas
    $query = "SELECT id, empresa FROM empresas ORDER BY empresa ASC";
    $result = $conn->query($query);
    
    if (!$result) {
        error_log("Erro na query: " . $conn->error);
        throw new Exception('Erro na query: ' . $conn->error);
    }
    
    $empresas = [];
    while ($row = $result->fetch_assoc()) {
        $empresas[] = [
            'id' => $row['id'],
            'nome' => $row['empresa']
        ];
    }
    
    error_log("Encontradas " . count($empresas) . " empresas");
    
    echo json_encode([
        'success' => true,
        'empresas' => $empresas,
        'total' => count($empresas)
    ]);
    
} catch (Exception $e) {
    error_log("Erro em buscar_empresas.php: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => 'Erro interno do servidor: ' . $e->getMessage(),
        'debug' => true
    ]);
}

if ($conn) {
    $conn->close();
}
?>
