﻿<? include 'includes/tema/topo.php'; ?>
<? include 'includes/validacoesadmin.php'; ?>

<?

// Inclui a biblioteca do Google Authenticator corretamente
require_once '2fa/GoogleAuthenticator.php';
$ga = new PHPGangsta_GoogleAuthenticator();


$stmt = $pdo->prepare("SELECT secret, 2fa_enabled FROM usuarios WHERE id = :id");
$stmt->execute([':id' => $_SESSION['id']]);
$userInfo = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code']) && isset($_SESSION['temp_secret'])) {
    $code = $_POST['code'];
    $temp_secret = $_SESSION['temp_secret'];

    if ($ga->verifyCode($temp_secret, $code, 2)) {
        // Atualiza o banco de dados com o novo segredo após a verificação bem-sucedida
        $stmt = $pdo->prepare("UPDATE usuarios SET secret = :secret, 2fa_enabled = 1 WHERE id = :id");
        $stmt->execute([':secret' => $temp_secret, ':id' => $_SESSION['id']]);
        unset($_SESSION['temp_secret']); // Limpa o segredo temporário da sessão
        header('Location: index.php?cadastro2fa=sim');
        exit;
    } else {
        header('Location: configuracao_2fa.php?erro_verificacao_2fa=sim');
    }
} else {
    // Gera e armazena um novo código secreto temporariamente
    $temp_secret = $ga->createSecret();
    $_SESSION['temp_secret'] = $temp_secret;
    $qrCodeUrl = $ga->getQRCodeGoogleUrl($_SERVER['HTTP_HOST'], $temp_secret);

}


$warning = $userInfo['2fa_enabled'] ? "Atenção: Configurar o 2FA novamente desativará o dispositivo anteriormente sincronizado." : "";

?>


<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->


        <div class="smart-wrap">
            <div class="smart-forms smart-container wrap-0">
                <div class="form-header header-blue bg-primary ">
                    <h4><i class="fa fa-calendar-o"></i>Ativar - 2FA </h4>
                </div><!-- end .form-header section -->


                <form action="" method="post">
                    <div class="form-body">


                    <?php if (!empty($warning)): ?>
                    <div class="spacer-b30">
                            <div class="tagline"><span style="color: red;"> <?php echo htmlspecialchars($warning); ?> </span></div><!-- .tagline -->
                        </div>
                        <?php endif; ?>

                    <div class="spacer-b30">
                            <div class="tagline"><span style="color: black"> QR CODE </span></div><!-- .tagline -->
                        </div>




                        <div class="frm-row">
                            <div class="section colm colm3">
                                
                            </div>
                            <div class="section colm colm6">
                            <div align="center">
                                <img src="<?php echo htmlspecialchars($qrCodeUrl); ?>" alt="QR Code" />
                                </div>
                            </div><!-- end  section -->
                        </div><!-- end  section -->

                        <div class="spacer-b30">
                            <div class="tagline"><span style="color: black"> Código 2FA </span>
                            </div><!-- .tagline -->
                        </div>
                        
                        <div class="frm-row">
                            <div class="section colm colm3"></div>
                            <div class="section colm colm6">
                                <label for="firstname" class="field prepend-icon">
                                    <input type="text" name="code" id="code" class="gui-input"
                                        placeholder="Digite Código 2FA"  required>
                                    <b class="tooltip tip-right-top"><b>Digite o <span style="color:#6CF;">Código</span>
                                            Exemplo: <span style="color:#6CF;"> 000 000 </span></b></b>
                                    <span class="field-icon"><i class="fa fa-user"></i></span>


                                </label>
                            </div><!-- end section -->



                        </div><!-- end .frm-row section -->
                       












                    </div>




                    <div class="form-footer" align="center">
                        <input type="submit" class="button btn-blue" value="Verificar e Ativar 2FA">

                    </div>

                </form>
            </div>
        </div>






        <!-- Search API (Regular Expressions) table end -->
    </div>
</section>



<?php include 'includes/tema/base.php'; ?>