<?php
// Script para verificar e corrigir o campo valor se necessário
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

echo "<h2>Verificação e Correção do Campo Valor</h2>";

// 1. Verificar a estrutura atual do campo valor
echo "<h3>1. Estrutura atual do campo 'valor':</h3>";
$sql = "SELECT COLUMN_TYPE, DATA_TYPE, NUMERIC_PRECISION, NUMERIC_SCALE 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND TABLE_NAME = 'financeiro_clientes' 
        AND COLUMN_NAME = 'valor'";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $campo_info = $result->fetch_assoc();
    echo "<table border='1'>";
    echo "<tr><th>Propriedade</th><th>Valor</th></tr>";
    echo "<tr><td>Tipo da Coluna</td><td>" . $campo_info['COLUMN_TYPE'] . "</td></tr>";
    echo "<tr><td>Tipo de Dados</td><td>" . $campo_info['DATA_TYPE'] . "</td></tr>";
    echo "<tr><td>Precisão Numérica</td><td>" . ($campo_info['NUMERIC_PRECISION'] ?? 'N/A') . "</td></tr>";
    echo "<tr><td>Escala Numérica</td><td>" . ($campo_info['NUMERIC_SCALE'] ?? 'N/A') . "</td></tr>";
    echo "</table>";
    
    // Analisar se o campo está correto
    $tipo_coluna = $campo_info['COLUMN_TYPE'];
    echo "<h4>Análise:</h4>";
    
    if (strpos($tipo_coluna, 'decimal') !== false) {
        if (strpos($tipo_coluna, 'decimal(10,2)') !== false) {
            echo "<p style='color: green;'>✓ Campo está correto: DECIMAL(10,2) - suporta centavos</p>";
        } elseif (strpos($tipo_coluna, 'decimal(10,0)') !== false) {
            echo "<p style='color: red;'>❌ PROBLEMA ENCONTRADO: Campo é DECIMAL(10,0) - NÃO suporta centavos!</p>";
            echo "<p>Isso explica o arredondamento de 7,50 para 8!</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Campo DECIMAL com configuração diferente: $tipo_coluna</p>";
        }
    } elseif (strpos($tipo_coluna, 'float') !== false || strpos($tipo_coluna, 'double') !== false) {
        echo "<p style='color: orange;'>⚠️ Campo é FLOAT/DOUBLE - pode ter problemas de precisão</p>";
    } else {
        echo "<p style='color: red;'>❌ Tipo de campo inesperado: $tipo_coluna</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Não foi possível obter informações do campo</p>";
}

// 2. Teste prático com inserção
echo "<h3>2. Teste prático de inserção:</h3>";

// Limpar registros de teste
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 55555");

$valores_teste = ['7.50', '7.51', '7.49', '8.00'];

foreach ($valores_teste as $valor) {
    $sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (55555, 1, ?, '2024-01-01')";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("s", $valor);
        
        if ($stmt->execute()) {
            $id = $conn->insert_id;
            
            // Verificar o que foi salvo
            $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id");
            $row = $check->fetch_assoc();
            
            echo "<p><strong>Teste:</strong> Inserindo '$valor' → Salvo: '" . $row['valor'] . "'";
            
            if ($row['valor'] != $valor) {
                echo " <span style='color: red; font-weight: bold;'>❌ ARREDONDADO!</span>";
            } else {
                echo " <span style='color: green;'>✓ OK</span>";
            }
            echo "</p>";
        }
    }
}

// 3. Propor correção se necessário
echo "<h3>3. Correção do campo (se necessário):</h3>";

if (isset($campo_info) && strpos($campo_info['COLUMN_TYPE'], 'decimal(10,0)') !== false) {
    echo "<div style='background: #ffe6e6; padding: 10px; border: 1px solid #ff0000; margin: 10px 0;'>";
    echo "<h4 style='color: red;'>PROBLEMA IDENTIFICADO!</h4>";
    echo "<p>O campo 'valor' está definido como DECIMAL(10,0), que não suporta casas decimais.</p>";
    echo "<p>Para corrigir, execute o seguinte comando SQL:</p>";
    echo "<code style='background: #f0f0f0; padding: 5px; display: block; margin: 10px 0;'>";
    echo "ALTER TABLE financeiro_clientes MODIFY COLUMN valor DECIMAL(10,2) NOT NULL;";
    echo "</code>";
    echo "</div>";
    
    // Oferecer correção automática
    if (isset($_GET['corrigir']) && $_GET['corrigir'] === 'sim') {
        echo "<h4>Executando correção...</h4>";
        
        $sql_correcao = "ALTER TABLE financeiro_clientes MODIFY COLUMN valor DECIMAL(10,2) NOT NULL";
        
        if ($conn->query($sql_correcao)) {
            echo "<p style='color: green; font-weight: bold;'>✓ Campo corrigido com sucesso!</p>";
            echo "<p>O campo 'valor' agora suporta 2 casas decimais.</p>";
            
            // Testar novamente após correção
            echo "<h5>Teste após correção:</h5>";
            $conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 55555");
            
            $valor_teste = '7.50';
            $sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (55555, 1, ?, '2024-01-01')";
            $stmt = $conn->prepare($sql);
            
            if ($stmt) {
                $stmt->bind_param("s", $valor_teste);
                
                if ($stmt->execute()) {
                    $id = $conn->insert_id;
                    $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id");
                    $row = $check->fetch_assoc();
                    
                    echo "<p><strong>Teste pós-correção:</strong> Inserindo '$valor_teste' → Salvo: '" . $row['valor'] . "'";
                    
                    if ($row['valor'] == $valor_teste) {
                        echo " <span style='color: green; font-weight: bold;'>✓ CORRIGIDO!</span>";
                    } else {
                        echo " <span style='color: red;'>❌ Ainda há problema</span>";
                    }
                    echo "</p>";
                }
            }
        } else {
            echo "<p style='color: red;'>❌ Erro ao corrigir campo: " . $conn->error . "</p>";
        }
    } else {
        echo "<p><a href='?corrigir=sim' style='background: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>CORRIGIR CAMPO AUTOMATICAMENTE</a></p>";
        echo "<p><em>Clique no botão acima para corrigir automaticamente o campo.</em></p>";
    }
}

// Limpeza
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 55555");
echo "<p><em>Registros de teste removidos.</em></p>";

?>