<?php
// Debug específico para problema de arredondamento 7,50 -> 8,00
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

echo "<h2>Debug Arredondamento - Teste com 7,50</h2>";

// Teste 1: Verificar estrutura da tabela
echo "<h3>1. Estrutura da tabela financeiro_clientes:</h3>";
$sql = "DESCRIBE financeiro_clientes";
$result = $conn->query($sql);
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Teste 2: Inserir valor 7,50 e verificar o que foi salvo
echo "<h3>2. Teste de inserção com valor 7,50:</h3>";

// Limpar teste anterior
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 99999 AND id_cliente = 99999");

$valor_teste = "7.50"; // Valor já no formato do banco
$sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (99999, 99999, ?, '2024-01-01')";
$stmt = $conn->prepare($sql);

if ($stmt) {
    echo "<p><strong>Valor sendo inserido:</strong> $valor_teste</p>";
    
    $stmt->bind_param("s", $valor_teste);
    
    if ($stmt->execute()) {
        $id_inserido = $conn->insert_id;
        echo "<p style='color: green;'>✓ Inserção realizada com sucesso! ID: $id_inserido</p>";
        
        // Verificar o que foi realmente salvo
        $sql_check = "SELECT valor FROM financeiro_clientes WHERE id = ?";
        $stmt_check = $conn->prepare($sql_check);
        if ($stmt_check) {
            $stmt_check->bind_param("i", $id_inserido);
            $stmt_check->execute();
            $result_check = $stmt_check->get_result();
            $row_check = $result_check->fetch_assoc();
            
            echo "<p><strong>Valor salvo no banco:</strong> " . $row_check['valor'] . "</p>";
            echo "<p><strong>Tipo do valor:</strong> " . gettype($row_check['valor']) . "</p>";
            
            // Verificar se há diferença
            if ($row_check['valor'] != $valor_teste) {
                echo "<p style='color: red;'>❌ PROBLEMA: Valor inserido ($valor_teste) diferente do valor salvo (" . $row_check['valor'] . ")</p>";
            } else {
                echo "<p style='color: green;'>✓ Valor salvo corretamente</p>";
            }
        }
    } else {
        echo "<p style='color: red;'>❌ Erro na inserção: " . $stmt->error . "</p>";
    }
}

// Teste 3: Testar diferentes formatos de entrada
echo "<h3>3. Teste com diferentes formatos de entrada:</h3>";

$valores_teste = [
    '7,50' => str_replace(',', '.', '7,50'),
    '7.50' => '7.50',
    '7.5' => '7.5',
    '07.50' => '07.50'
];

foreach ($valores_teste as $entrada => $processado) {
    echo "<p><strong>Entrada:</strong> $entrada → <strong>Processado:</strong> $processado</p>";
    
    // Testar conversões
    echo "<ul>";
    echo "<li>floatval(): " . floatval($processado) . "</li>";
    echo "<li>(float): " . (float)$processado . "</li>";
    echo "<li>number_format(floatval(), 2): " . number_format(floatval($processado), 2, ',', '.') . "</li>";
    echo "<li>Como string: $processado</li>";
    echo "</ul>";
}

// Teste 4: Verificar configurações do MySQL
echo "<h3>4. Configurações do MySQL:</h3>";
$sql = "SHOW VARIABLES LIKE '%sql_mode%'";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        echo "<p><strong>" . $row['Variable_name'] . ":</strong> " . $row['Value'] . "</p>";
    }
}

// Limpeza
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 99999 AND id_cliente = 99999");
echo "<p><em>Registros de teste removidos.</em></p>";

?>

<script>
// Teste JavaScript para verificar formatação
console.log('=== Teste JavaScript ===');
const valor = '7,50';
const valorProcessado = valor.replace(/\./g, '').replace(',', '.');
console.log('Valor original:', valor);
console.log('Valor processado:', valorProcessado);
console.log('parseFloat:', parseFloat(valorProcessado));
console.log('Number:', Number(valorProcessado));
</script>