<?php
// Debug para verificar o formato das datas na tabela vendas
include 'dbconfig.php';

echo "<h2>Debug - Formato de Datas na Tabela Vendas</h2>";

// Verificar estrutura da tabela vendas
echo "<h3>Estrutura da Tabela Vendas:</h3>";
$sql_structure = "DESCRIBE vendas";
$result_structure = mysqli_query($conn, $sql_structure);

if ($result_structure) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Chave</th><th>Padrão</th><th>Extra</th></tr>";
    while ($row = mysqli_fetch_assoc($result_structure)) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>Erro ao obter estrutura: " . mysqli_error($conn) . "</p>";
}

echo "<hr>";

// Verificar dados reais da tabela vendas
echo "<h3>Dados Reais da Tabela Vendas (últimos 10 registros):</h3>";
$sql_data = "SELECT id, id_pedido, produto, valor, data2, 
             UNIX_TIMESTAMP(data2) as timestamp_data2,
             DATE_FORMAT(data2, '%Y-%m-%d') as data2_formatted,
             DATE_FORMAT(data2, '%d/%m/%Y') as data2_br
             FROM vendas 
             ORDER BY id DESC 
             LIMIT 10";
             
$result_data = mysqli_query($conn, $sql_data);

if ($result_data) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr>";
    echo "<th>ID</th>";
    echo "<th>ID Pedido</th>";
    echo "<th>Produto</th>";
    echo "<th>Valor</th>";
    echo "<th>data2 (raw)</th>";
    echo "<th>Timestamp</th>";
    echo "<th>Formatado ISO</th>";
    echo "<th>Formatado BR</th>";
    echo "<th>strtotime()</th>";
    echo "<th>date() Result</th>";
    echo "</tr>";
    
    while ($row = mysqli_fetch_assoc($result_data)) {
        $strtotime_result = strtotime($row['data2']);
        $date_result = $strtotime_result ? date('d/m/Y', $strtotime_result) : 'ERRO';
        
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['id_pedido'] . "</td>";
        echo "<td>" . htmlspecialchars($row['produto']) . "</td>";
        echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $row['data2'] . "</td>";
        echo "<td>" . $row['timestamp_data2'] . "</td>";
        echo "<td>" . $row['data2_formatted'] . "</td>";
        echo "<td>" . $row['data2_br'] . "</td>";
        echo "<td>" . $strtotime_result . "</td>";
        echo "<td>" . $date_result . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>Erro ao obter dados: " . mysqli_error($conn) . "</p>";
}

echo "<hr>";

// Testar diferentes formatos de data
echo "<h3>Teste de Conversão de Datas:</h3>";
$test_dates = [
    '0000-00-00',
    '1970-01-01',
    '2024-01-15',
    '',
    null
];

echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>Data Teste</th><th>strtotime()</th><th>date() Result</th><th>Observação</th></tr>";

foreach ($test_dates as $test_date) {
    $strtotime_result = strtotime($test_date);
    $date_result = $strtotime_result ? date('d/m/Y', $strtotime_result) : 'ERRO';
    
    $observacao = '';
    if ($test_date === '0000-00-00') {
        $observacao = 'Data MySQL inválida';
    } elseif ($test_date === '1970-01-01') {
        $observacao = 'Epoch Unix (pode causar 31/12/1969)';
    } elseif (empty($test_date)) {
        $observacao = 'Data vazia';
    }
    
    echo "<tr>";
    echo "<td>" . ($test_date ?: 'NULL/VAZIO') . "</td>";
    echo "<td>" . $strtotime_result . "</td>";
    echo "<td>" . $date_result . "</td>";
    echo "<td>" . $observacao . "</td>";
    echo "</tr>";
}
echo "</table>";

echo "<hr>";
echo "<h3>Recomendações:</h3>";
echo "<ul>";
echo "<li>Se data2 contém '0000-00-00' ou valores inválidos, isso causa o problema 31/12/1969</li>";
echo "<li>Verificar se o campo data2 está sendo preenchido corretamente nas inserções</li>";
echo "<li>Considerar usar DATE_FORMAT() do MySQL em vez de strtotime() do PHP</li>";
echo "</ul>";
?>