<?php
require_once 'dbconfig.php';

// Simular os parâmetros que vêm da função editarVenda
$id_pedido = isset($_GET['id_pedido']) ? (int)$_GET['id_pedido'] : 1;
$id_cliente = isset($_GET['id_cliente']) ? (int)$_GET['id_cliente'] : 1;
$id_vendas = isset($_GET['id_vendas']) ? (int)$_GET['id_vendas'] : 0;
$acao = isset($_GET['acao']) ? $_GET['acao'] : '';

echo "<h2>Debug da Edição de Vendas</h2>";
echo "<strong>Parâmetros recebidos:</strong><br>";
echo "id_pedido: " . $id_pedido . "<br>";
echo "id_cliente: " . $id_cliente . "<br>";
echo "id_vendas: " . $id_vendas . "<br>";
echo "acao: " . $acao . "<br><br>";

try {
    // Buscar dados para edição (mesma lógica do vendas_modal.php)
    $venda_edicao = null;
    if ($acao === 'editar' && $id_vendas > 0) {
        echo "<strong>Executando busca para edição...</strong><br>";
        $sql = "SELECT * FROM vendas WHERE id = ?";
        $stmt = $conn->prepare($sql);
        
        if ($stmt) {
            $stmt->bind_param("i", $id_vendas);
            if ($stmt->execute()) {
                $result = $stmt->get_result();
                $venda_edicao = $result->fetch_assoc();
                
                echo "<strong>Resultado da busca:</strong><br>";
                if ($venda_edicao) {
                    echo "<pre>";
                    print_r($venda_edicao);
                    echo "</pre>";
                } else {
                    echo "Nenhum registro encontrado para id_vendas = " . $id_vendas . "<br>";
                }
            } else {
                echo "Erro ao executar consulta: " . $stmt->error . "<br>";
            }
        } else {
            echo "Erro ao preparar consulta: " . $conn->error . "<br>";
        }
    } else {
        echo "<strong>Condições não atendidas para busca:</strong><br>";
        echo "acao === 'editar': " . ($acao === 'editar' ? 'true' : 'false') . "<br>";
        echo "id_vendas > 0: " . ($id_vendas > 0 ? 'true' : 'false') . "<br>";
    }
    
    echo "<hr>";
    
    // Listar algumas vendas disponíveis para teste
    echo "<h3>Vendas disponíveis para teste:</h3>";
    $stmt = $pdo->prepare("SELECT id, produto, valor, data2 FROM vendas ORDER BY id DESC LIMIT 5");
    $stmt->execute();
    $vendas_teste = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Produto</th><th>Valor</th><th>Data2</th><th>Ação</th></tr>";
    
    foreach ($vendas_teste as $venda) {
        echo "<tr>";
        echo "<td>" . $venda['id'] . "</td>";
        echo "<td>" . htmlspecialchars($venda['produto']) . "</td>";
        echo "<td>R$ " . number_format($venda['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $venda['data2'] . "</td>";
        echo "<td><a href='?id_pedido=1&id_cliente=1&id_vendas=" . $venda['id'] . "&acao=editar'>Testar Edição</a></td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Simular o preenchimento dos campos
    if ($venda_edicao) {
        echo "<hr>";
        echo "<h3>Simulação do Preenchimento dos Campos:</h3>";
        echo "<strong>Campo Produto:</strong> " . ($venda_edicao ? htmlspecialchars($venda_edicao['produto']) : '') . "<br>";
        echo "<strong>Campo Valor:</strong> " . ($venda_edicao ? number_format($venda_edicao['valor'], 2, ',', '.') : '') . "<br>";
        echo "<strong>Campo Data (raw):</strong> " . ($venda_edicao['data2'] ?? 'null') . "<br>";
        
        $data_campo = '';
        if ($venda_edicao && !empty($venda_edicao['data2']) && $venda_edicao['data2'] !== '0000-00-00' && $venda_edicao['data2'] !== '1970-01-01') {
            $data_campo = $venda_edicao['data2'];
        } else {
            $data_campo = date('Y-m-d');
        }
        
        echo "<strong>Campo Data (processado):</strong> " . $data_campo . "<br>";
    }
    
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}
?>

<hr>
<h3>Links de Teste:</h3>
<a href="vendas_modal.php?id_pedido=1&id_cliente=1" target="_blank">Abrir Modal Normal</a><br>
<a href="vendas_modal.php?id_pedido=1&id_cliente=1&id_vendas=9598&acao=editar" target="_blank">Testar Edição (ID 9598)</a><br>
<a href="teste_correcao_datas.php" target="_blank">Voltar ao Teste Principal</a>