<?php
// Debug completo da estrutura e teste com 7,50
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

echo "<h2>Debug Completo - Problema 7,50 → 8,00</h2>";

// 1. Estrutura completa da tabela
echo "<h3>1. Estrutura da tabela financeiro_clientes:</h3>";
$sql = "SHOW CREATE TABLE financeiro_clientes";
$result = $conn->query($sql);
if ($result) {
    $row = $result->fetch_assoc();
    echo "<pre>" . htmlspecialchars($row['Create Table']) . "</pre>";
}

// 2. Informações detalhadas das colunas
echo "<h3>2. Informações detalhadas das colunas:</h3>";
$sql = "SELECT COLUMN_NAME, DATA_TYPE, COLUMN_TYPE, IS_NULLABLE, COLUMN_DEFAULT, NUMERIC_PRECISION, NUMERIC_SCALE 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'financeiro_clientes' 
        ORDER BY ORDINAL_POSITION";
$result = $conn->query($sql);
if ($result) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Tipo Completo</th><th>Nulo</th><th>Padrão</th><th>Precisão</th><th>Escala</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['COLUMN_NAME'] . "</td>";
        echo "<td>" . $row['DATA_TYPE'] . "</td>";
        echo "<td>" . $row['COLUMN_TYPE'] . "</td>";
        echo "<td>" . $row['IS_NULLABLE'] . "</td>";
        echo "<td>" . ($row['COLUMN_DEFAULT'] ?? 'NULL') . "</td>";
        echo "<td>" . ($row['NUMERIC_PRECISION'] ?? 'N/A') . "</td>";
        echo "<td>" . ($row['NUMERIC_SCALE'] ?? 'N/A') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// 3. Teste específico com 7.50
echo "<h3>3. Teste específico com valor 7.50:</h3>";

// Limpar registros de teste
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 66666");

// Teste A: Inserção direta com string
echo "<h4>Teste A: Inserção com string '7.50'</h4>";
$valor = '7.50';
$sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (66666, 1, ?, '2024-01-01')";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("s", $valor);
    if ($stmt->execute()) {
        $id_a = $conn->insert_id;
        echo "<p>✓ Inserido com ID: $id_a</p>";
        
        // Verificar valor salvo
        $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id_a");
        $row = $check->fetch_assoc();
        echo "<p><strong>Valor inserido:</strong> '$valor' | <strong>Valor salvo:</strong> '" . $row['valor'] . "'</p>";
        
        if ($row['valor'] != $valor) {
            echo "<p style='color: red;'>❌ DIFERENÇA: " . $valor . " → " . $row['valor'] . "</p>";
        }
    }
}

// Teste B: Inserção com float
echo "<h4>Teste B: Inserção com float 7.50</h4>";
$valor_float = 7.50;
$sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (66666, 1, ?, '2024-01-01')";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("d", $valor_float);
    if ($stmt->execute()) {
        $id_b = $conn->insert_id;
        echo "<p>✓ Inserido com ID: $id_b</p>";
        
        // Verificar valor salvo
        $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id_b");
        $row = $check->fetch_assoc();
        echo "<p><strong>Valor inserido:</strong> $valor_float | <strong>Valor salvo:</strong> '" . $row['valor'] . "'</p>";
    }
}

// Teste C: UPDATE de um valor existente
echo "<h4>Teste C: UPDATE para 7.50</h4>";
$conn->query("INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (66666, 1, '10.00', '2024-01-01')");
$id_c = $conn->insert_id;
echo "<p>Registro criado com valor 10.00, ID: $id_c</p>";

$novo_valor = '7.50';
$sql = "UPDATE financeiro_clientes SET valor = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("si", $novo_valor, $id_c);
    if ($stmt->execute()) {
        echo "<p>✓ UPDATE executado</p>";
        
        // Verificar valor após update
        $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id_c");
        $row = $check->fetch_assoc();
        echo "<p><strong>Valor enviado:</strong> '$novo_valor' | <strong>Valor salvo:</strong> '" . $row['valor'] . "'</p>";
        
        if ($row['valor'] != $novo_valor) {
            echo "<p style='color: red;'>❌ PROBLEMA NO UPDATE: " . $novo_valor . " → " . $row['valor'] . "</p>";
        }
    }
}

// 4. Teste com diferentes formatos de entrada
echo "<h3>4. Teste com diferentes formatos:</h3>";
$formatos = [
    '7,50' => str_replace(',', '.', '7,50'),
    '7.50' => '7.50',
    '7.5' => '7.5',
    '07.50' => '07.50',
    '7.500' => '7.500'
];

foreach ($formatos as $original => $processado) {
    echo "<h5>Formato: $original → $processado</h5>";
    
    $sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (66666, 1, ?, '2024-01-01')";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("s", $processado);
        if ($stmt->execute()) {
            $id = $conn->insert_id;
            $check = $conn->query("SELECT valor FROM financeiro_clientes WHERE id = $id");
            $row = $check->fetch_assoc();
            
            echo "<p>Enviado: '$processado' | Salvo: '" . $row['valor'] . "'";
            if ($row['valor'] != $processado) {
                echo " <span style='color: red;'>❌ DIFERENTE</span>";
            } else {
                echo " <span style='color: green;'>✓ OK</span>";
            }
            echo "</p>";
        }
    }
}

// 5. Verificar configurações do MySQL que podem afetar
echo "<h3>5. Configurações do MySQL:</h3>";
$configs = ['sql_mode', 'version', 'character_set_server', 'collation_server'];
foreach ($configs as $config) {
    $result = $conn->query("SHOW VARIABLES LIKE '$config'");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo "<p><strong>" . $row['Variable_name'] . ":</strong> " . $row['Value'] . "</p>";
    }
}

// 6. Listar todos os registros de teste
echo "<h3>6. Todos os registros de teste criados:</h3>";
$result = $conn->query("SELECT id, valor, data2 FROM financeiro_clientes WHERE id_pedido = 66666 ORDER BY id");
if ($result && $result->num_rows > 0) {
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Valor</th><th>Data</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr><td>" . $row['id'] . "</td><td>" . $row['valor'] . "</td><td>" . $row['data2'] . "</td></tr>";
    }
    echo "</table>";
}

// Limpeza
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 66666");
echo "<p><em>Registros de teste removidos.</em></p>";

?>