<?php
// Teste para verificar parâmetros do modal financeiro
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once 'dbconfig.php';

echo "<h2>Debug Modal Financeiro</h2>";

$id_pedido = isset($_GET['id_pedido']) ? (int)$_GET['id_pedido'] : 0;
$id_cliente = isset($_GET['id_cliente']) ? (int)$_GET['id_cliente'] : 0;

echo "<p><strong>Parâmetros recebidos:</strong></p>";
echo "<ul>";
echo "<li>id_pedido: " . $id_pedido . "</li>";
echo "<li>id_cliente: " . $id_cliente . "</li>";
echo "</ul>";

if ($id_pedido > 0) {
    // Testar busca de informações do pedido
    $sql = "SELECT p.id as pedido_id, p.data, u.nome as cliente_nome 
            FROM pedidos p 
            LEFT JOIN usuarios u ON p.id_cliente = u.id 
            WHERE p.id = ? AND p.id_cliente = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("ii", $id_pedido, $id_cliente);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            $info_pedido = $result->fetch_assoc();
            
            echo "<p><strong>Informações do pedido:</strong></p>";
            if ($info_pedido) {
                echo "<ul>";
                echo "<li>Pedido ID: " . $info_pedido['pedido_id'] . "</li>";
                echo "<li>Data: " . $info_pedido['data'] . "</li>";
                echo "<li>Cliente: " . $info_pedido['cliente_nome'] . "</li>";
                echo "</ul>";
            } else {
                echo "<p style='color: red;'>Nenhuma informação de pedido encontrada!</p>";
            }
        }
    }
    
    // Testar busca de pagamentos
    $sql = "SELECT * FROM financeiro_clientes WHERE id_pedido = ? ORDER BY id DESC";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("i", $id_pedido);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            $pagamentos = [];
            while ($row = $result->fetch_assoc()) {
                $pagamentos[] = $row;
            }
            
            echo "<p><strong>Pagamentos encontrados:</strong> " . count($pagamentos) . "</p>";
            
            if (count($pagamentos) > 0) {
                echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
                echo "<tr><th>ID</th><th>Valor</th><th>Data</th><th>Data2</th><th>Hora</th></tr>";
                foreach ($pagamentos as $p) {
                    echo "<tr>";
                    echo "<td>" . $p['id'] . "</td>";
                    echo "<td>R$ " . number_format($p['valor'], 2, ',', '.') . "</td>";
                    echo "<td>" . $p['data'] . "</td>";
                    echo "<td>" . $p['data2'] . "</td>";
                    echo "<td>" . $p['hora'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p style='color: orange;'>Nenhum pagamento encontrado para este pedido.</p>";
            }
        } else {
            echo "<p style='color: red;'>Erro ao executar query de pagamentos: " . $stmt->error . "</p>";
        }
    } else {
        echo "<p style='color: red;'>Erro ao preparar query de pagamentos: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color: red;'>ID do pedido é obrigatório!</p>";
}

// Mostrar estrutura da tabela financeiro_clientes
echo "<h3>Estrutura da tabela financeiro_clientes:</h3>";
$result = $conn->query("DESCRIBE financeiro_clientes");
if ($result) {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Mostrar todos os registros da tabela
echo "<h3>Todos os registros da tabela financeiro_clientes:</h3>";
$result = $conn->query("SELECT * FROM financeiro_clientes ORDER BY id DESC LIMIT 10");
if ($result && $result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>ID Pedido</th><th>Valor</th><th>Data</th><th>Data2</th><th>Hora</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['id_pedido'] . "</td>";
        echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $row['data'] . "</td>";
        echo "<td>" . $row['data2'] . "</td>";
        echo "<td>" . $row['hora'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Nenhum registro encontrado na tabela financeiro_clientes.</p>";
}
?>
