<?php
require_once 'dbconfig.php';

// Simular parâmetros de edição
$id_vendas = isset($_GET['id_vendas']) ? (int)$_GET['id_vendas'] : 1;

echo "<h2>Debug - Valor na Edição de Vendas</h2>";
echo "<p>ID da venda para teste: $id_vendas</p>";

// Buscar dados da venda
$sql = "SELECT * FROM vendas WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("i", $id_vendas);
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $venda = $result->fetch_assoc();
        
        if ($venda) {
            echo "<h3>Dados da Venda (Raw):</h3>";
            echo "<pre>";
            print_r($venda);
            echo "</pre>";
            
            echo "<h3>Análise do Campo Valor:</h3>";
            echo "<p><strong>Valor original:</strong> " . var_export($venda['valor'], true) . "</p>";
            echo "<p><strong>Tipo do valor:</strong> " . gettype($venda['valor']) . "</p>";
            echo "<p><strong>Valor é vazio?:</strong> " . (empty($venda['valor']) ? 'SIM' : 'NÃO') . "</p>";
            echo "<p><strong>Valor == 0?:</strong> " . ($venda['valor'] == 0 ? 'SIM' : 'NÃO') . "</p>";
            echo "<p><strong>Valor === 0?:</strong> " . ($venda['valor'] === 0 ? 'SIM' : 'NÃO') . "</p>";
            echo "<p><strong>Valor === '0'?:</strong> " . ($venda['valor'] === '0' ? 'SIM' : 'NÃO') . "</p>";
            
            echo "<h3>Formatação do Valor:</h3>";
            $valor_formatado = number_format($venda['valor'], 2, ',', '.');
            echo "<p><strong>Valor formatado:</strong> '$valor_formatado'</p>";
            
            echo "<h3>Simulação do Campo Input:</h3>";
            echo "<p>Campo valor seria preenchido com: <code>" . htmlspecialchars($valor_formatado) . "</code></p>";
            
            echo "<h3>Teste de Condição do Formulário:</h3>";
            $condicao_edicao = !empty($venda) ? 'true' : 'false';
            echo "<p>\$venda_edicao existe? $condicao_edicao</p>";
            
            if (!empty($venda)) {
                $valor_input = number_format($venda['valor'], 2, ',', '.');
                echo "<p>Valor que seria exibido no input: '$valor_input'</p>";
            }
            
        } else {
            echo "<p style='color: red;'>Nenhuma venda encontrada com ID $id_vendas</p>";
        }
    } else {
        echo "<p style='color: red;'>Erro ao executar consulta: " . $stmt->error . "</p>";
    }
} else {
    echo "<p style='color: red;'>Erro ao preparar consulta: " . $conn->error . "</p>";
}

// Listar algumas vendas disponíveis
echo "<h3>Vendas Disponíveis para Teste:</h3>";
$sql = "SELECT id, produto, valor, data2 FROM vendas ORDER BY id DESC LIMIT 5";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>ID</th><th>Produto</th><th>Valor</th><th>Data</th><th>Ação</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['produto']) . "</td>";
        echo "<td>" . $row['valor'] . "</td>";
        echo "<td>" . $row['data2'] . "</td>";
        echo "<td><a href='?id_vendas=" . $row['id'] . "'>Testar</a></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Nenhuma venda encontrada na tabela.</p>";
}

echo "<hr>";
echo "<p><a href='teste_edicao_final.php'>← Voltar ao teste de edição</a></p>";
?>