<?php
// Habilitar exibição de erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h2>Debug - Sistema de Vendas</h2>";

// Teste 1: Incluir dbconfig
echo "<h3>1. Testando inclusão do dbconfig.php</h3>";
try {
    include_once 'dbconfig.php';
    echo "✅ dbconfig.php incluído com sucesso<br>";
} catch (Exception $e) {
    echo "❌ Erro ao incluir dbconfig.php: " . $e->getMessage() . "<br>";
    exit;
}

// Teste 2: Verificar conexão
echo "<h3>2. Testando conexão com banco de dados</h3>";
if ($conn) {
    echo "✅ Conexão estabelecida com sucesso<br>";
    echo "Host: " . $conn->host_info . "<br>";
    echo "Charset: " . $conn->character_set_name() . "<br>";
} else {
    echo "❌ Erro na conexão: " . mysqli_connect_error() . "<br>";
    exit;
}

// Teste 3: Verificar se tabela vendas existe
echo "<h3>3. Verificando tabela vendas</h3>";
$sql = "SHOW TABLES LIKE 'vendas'";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "✅ Tabela 'vendas' existe<br>";
    
    // Verificar estrutura
    $sql = "DESCRIBE vendas";
    $result = $conn->query($sql);
    
    if ($result) {
        echo "<h4>Estrutura da tabela:</h4>";
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr style='background: #f0f0f0;'><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Chave</th><th>Padrão</th></tr>";
        
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} else {
    echo "❌ Tabela 'vendas' não existe<br>";
    
    // Listar tabelas disponíveis
    echo "<h4>Tabelas disponíveis:</h4>";
    $sql = "SHOW TABLES";
    $result = $conn->query($sql);
    
    if ($result) {
        echo "<ul>";
        while ($row = $result->fetch_array()) {
            echo "<li>" . $row[0] . "</li>";
        }
        echo "</ul>";
    }
    exit;
}

// Teste 4: Verificar tabelas pedidos e clientes
echo "<h3>4. Verificando tabelas relacionadas</h3>";

$tabelas = ['pedidos', 'clientes'];
foreach ($tabelas as $tabela) {
    $sql = "SHOW TABLES LIKE '$tabela'";
    $result = $conn->query($sql);
    
    if ($result && $result->num_rows > 0) {
        echo "✅ Tabela '$tabela' existe<br>";
        
        // Contar registros
        $sql = "SELECT COUNT(*) as total FROM $tabela";
        $result = $conn->query($sql);
        if ($result) {
            $row = $result->fetch_assoc();
            echo "&nbsp;&nbsp;&nbsp;📊 Total de registros: " . $row['total'] . "<br>";
        }
    } else {
        echo "❌ Tabela '$tabela' não existe<br>";
    }
}

// Teste 5: Testar consulta de vendas
echo "<h3>5. Testando consultas de vendas</h3>";

// Contar total de vendas
$sql = "SELECT COUNT(*) as total FROM vendas";
$result = $conn->query($sql);
if ($result) {
    $row = $result->fetch_assoc();
    echo "📊 Total de vendas no sistema: " . $row['total'] . "<br>";
    
    if ($row['total'] > 0) {
        // Mostrar algumas vendas de exemplo
        echo "<h4>Exemplos de vendas (últimas 5):</h4>";
        $sql = "SELECT id_vendas, id_pedido, id_cliente, produto, valor, data FROM vendas ORDER BY id_vendas DESC LIMIT 5";
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
            echo "<tr style='background: #f0f0f0;'><th>ID</th><th>ID Pedido</th><th>ID Cliente</th><th>Produto</th><th>Valor</th><th>Data</th></tr>";
            
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $row['id_vendas'] . "</td>";
                echo "<td>" . $row['id_pedido'] . "</td>";
                echo "<td>" . $row['id_cliente'] . "</td>";
                echo "<td>" . htmlspecialchars($row['produto']) . "</td>";
                echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
                echo "<td>" . date('d/m/Y', strtotime($row['data'])) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "ℹ️ Não há vendas cadastradas no sistema<br>";
    }
} else {
    echo "❌ Erro ao consultar vendas: " . $conn->error . "<br>";
}

// Teste 6: Testar parâmetros GET
echo "<h3>6. Testando parâmetros</h3>";
$id_pedido = isset($_GET['id_pedido']) ? (int)$_GET['id_pedido'] : 0;
$id_cliente = isset($_GET['id_cliente']) ? (int)$_GET['id_cliente'] : 0;

echo "ID Pedido recebido: " . $id_pedido . "<br>";
echo "ID Cliente recebido: " . $id_cliente . "<br>";

if ($id_pedido > 0 && $id_cliente > 0) {
    // Testar consulta específica
    echo "<h4>Testando consulta específica:</h4>";
    
    $sql = "SELECT * FROM vendas WHERE id_pedido = ? AND id_cliente = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("ii", $id_pedido, $id_cliente);
        
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            echo "✅ Consulta executada com sucesso<br>";
            echo "📊 Vendas encontradas: " . $result->num_rows . "<br>";
            
            if ($result->num_rows > 0) {
                echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
                echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Produto</th><th>Valor</th><th>Data</th></tr>";
                
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . $row['id_vendas'] . "</td>";
                    echo "<td>" . htmlspecialchars($row['produto']) . "</td>";
                    echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
                    echo "<td>" . date('d/m/Y', strtotime($row['data'])) . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
        } else {
            echo "❌ Erro ao executar consulta: " . $stmt->error . "<br>";
        }
    } else {
        echo "❌ Erro ao preparar consulta: " . $conn->error . "<br>";
    }
} else {
    echo "ℹ️ Para testar consulta específica, adicione ?id_pedido=X&id_cliente=Y na URL<br>";
}

// Teste 7: Testar inclusão do antisql
echo "<h3>7. Testando antisql.php</h3>";
try {
    include_once 'includes/antisql.php';
    echo "✅ antisql.php incluído com sucesso<br>";
    
    if (function_exists('antiSQL')) {
        echo "✅ Função antiSQL disponível<br>";
    } else {
        echo "❌ Função antiSQL não encontrada<br>";
    }
} catch (Exception $e) {
    echo "❌ Erro ao incluir antisql.php: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>Links de Teste:</h3>";
echo "<p><a href='debug_vendas.php?id_pedido=1&id_cliente=1'>Testar com ID Pedido=1, ID Cliente=1</a></p>";
echo "<p><a href='vendas_modal.php?id_pedido=1&id_cliente=1'>Testar Modal de Vendas</a></p>";
echo "<p><a href='pedidos.php'>Voltar para Pedidos</a></p>";

echo "<h3>Teste do Modal via AJAX:</h3>";
echo "<button onclick='testarModal()'>Testar Carregamento do Modal</button>";
echo "<div id='resultado' style='margin-top: 20px; padding: 10px; border: 1px solid #ccc;'></div>";

echo "<script src='https://code.jquery.com/jquery-3.6.0.min.js'></script>";
echo "<script>";
echo "function testarModal() {";
echo "    $('#resultado').html('Carregando...');";
echo "    $.ajax({";
echo "        url: 'vendas_modal.php',";
echo "        type: 'GET',";
echo "        data: { id_pedido: 1, id_cliente: 1 },";
echo "        success: function(response) {";
echo "            $('#resultado').html('<h4>Sucesso!</h4><pre>' + response.substring(0, 500) + '...</pre>');";
echo "        },";
echo "        error: function(xhr, status, error) {";
echo "            $('#resultado').html('<h4>Erro!</h4><p>Status: ' + status + '</p><p>Erro: ' + error + '</p><p>Response: ' + xhr.responseText + '</p>');";
echo "        }";
echo "    });";
echo "}";
echo "</script>";
?>