<?php
// Interceptor de todas as requisições POST
$log_file = 'e:/wamp64/logs/php_error.log';

$info = [
    'TIMESTAMP' => date('Y-m-d H:i:s.u'),
    'ARQUIVO_EXECUTADO' => __FILE__,
    'SCRIPT_NAME' => $_SERVER['SCRIPT_NAME'] ?? 'N/A',
    'REQUEST_URI' => $_SERVER['REQUEST_URI'] ?? 'N/A',
    'REQUEST_METHOD' => $_SERVER['REQUEST_METHOD'] ?? 'N/A',
    'HTTP_REFERER' => $_SERVER['HTTP_REFERER'] ?? 'N/A',
    'POST_DATA' => $_POST,
    'GET_DATA' => $_GET
];

error_log("🔍 INTERCEPTOR_REQUISICOES.PHP - CAPTURA: " . json_encode($info));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_log("🚨 POST INTERCEPTADO EM INTERCEPTOR_REQUISICOES.PHP!");
    
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'message' => 'Requisição interceptada pelo interceptor_requisicoes.php',
        'arquivo_executado' => __FILE__,
        'dados_recebidos' => $_POST,
        'debug_info' => $info
    ]);
    exit;
}

echo "<h1>Interceptor de Requisições</h1>";
echo "<p>Este arquivo intercepta todas as chamadas.</p>";
echo "<pre>" . json_encode($info, JSON_PRETTY_PRINT) . "</pre>";
?>
