<?php
// Arquivo para investigar inserções automáticas no financeiro_clientes
include 'dbconfig.php';

// Capturar timestamp atual para comparação
$timestamp_inicio = date('Y-m-d H:i:s');

// Listar as últimas inserções no financeiro_clientes
echo "<h2>🔍 Investigação: Inserções Automáticas no financeiro_clientes</h2>";
echo "<p><strong>Timestamp de início:</strong> $timestamp_inicio</p>";

echo "<h3>📊 Últimas 15 inserções no financeiro_clientes:</h3>";
$sql = "SELECT fc.*, p.id as pedido_id, u.nome as cliente_nome,
        CONCAT(fc.data, ' ', IFNULL(fc.hora, '00:00:00')) as datetime_completo
        FROM financeiro_clientes fc 
        LEFT JOIN pedidos p ON fc.id_pedido = p.id 
        LEFT JOIN usuarios u ON p.id_cliente = u.id 
        ORDER BY fc.id DESC 
        LIMIT 15";

$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background-color: #f0f0f0;'>
            <th>ID Financeiro</th>
            <th>ID Pedido</th>
            <th>Cliente</th>
            <th>Valor</th>
            <th>Data/Hora Completa</th>
            <th>🕐 Há quanto tempo</th>
          </tr>";
    
    while ($row = mysqli_fetch_assoc($result)) {
        $tempo_diferenca = strtotime($timestamp_inicio) - strtotime($row['datetime_completo']);
        $minutos = round($tempo_diferenca / 60);
        
        $cor_linha = $minutos < 2 ? 'background-color: #ffeb3b;' : ''; // Destacar inserções recentes
        
        echo "<tr style='$cor_linha'>";
        echo "<td><strong>" . $row['id'] . "</strong></td>";
        echo "<td>" . $row['id_pedido'] . "</td>";
        echo "<td>" . htmlspecialchars($row['cliente_nome']) . "</td>";
        echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $row['datetime_completo'] . "</td>";
        echo "<td>" . ($minutos < 1 ? '<span style="color: red; font-weight: bold;">Agora mesmo!</span>' : "$minutos min atrás") . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Nenhum registro encontrado no financeiro_clientes</p>";
}

echo "<h3>📊 Últimas 15 inserções em vendas:</h3>";
$sql = "SELECT v.*, p.id as pedido_id, u.nome as cliente_nome,
        CONCAT(v.data, ' ', IFNULL(v.hora, '00:00:00')) as datetime_completo
        FROM vendas v 
        LEFT JOIN pedidos p ON v.id_pedido = p.id 
        LEFT JOIN usuarios u ON p.id_cliente = u.id 
        ORDER BY v.id DESC 
        LIMIT 15";

$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background-color: #f0f0f0;'>
            <th>ID Venda</th>
            <th>ID Pedido</th>
            <th>Cliente</th>
            <th>Produto</th>
            <th>Valor</th>
            <th>Data/Hora Completa</th>
            <th>🕐 Há quanto tempo</th>
          </tr>";
    
    while ($row = mysqli_fetch_assoc($result)) {
        $tempo_diferenca = strtotime($timestamp_inicio) - strtotime($row['datetime_completo']);
        $minutos = round($tempo_diferenca / 60);
        
        $cor_linha = $minutos < 2 ? 'background-color: #c8e6c9;' : ''; // Destacar inserções recentes
        
        echo "<tr style='$cor_linha'>";
        echo "<td><strong>" . $row['id'] . "</strong></td>";
        echo "<td>" . $row['id_pedido'] . "</td>";
        echo "<td>" . htmlspecialchars($row['cliente_nome']) . "</td>";
        echo "<td>" . htmlspecialchars($row['produto']) . "</td>";
        echo "<td>R$ " . number_format($row['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $row['datetime_completo'] . "</td>";
        echo "<td>" . ($minutos < 1 ? '<span style="color: green; font-weight: bold;">Agora mesmo!</span>' : "$minutos min atrás") . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Nenhum registro encontrado em vendas</p>";
}

echo "<h3>🔍 Teste Prático:</h3>";
echo "<ol>";
echo "<li>✅ <strong>Deixe esta página aberta</strong></li>";
echo "<li>✅ <strong>Abra uma nova aba:</strong> <a href='pedidos.php' target='_blank' style='color: blue; text-decoration: underline;'>Ir para Pedidos</a></li>";
echo "<li>✅ <strong>Na nova aba:</strong> Clique em um botão de 'Vendas' (ícone amarelo) de qualquer pedido</li>";
echo "<li>✅ <strong>No modal que abrir:</strong> Tente adicionar uma nova venda</li>";
echo "<li>✅ <strong>Volte aqui e recarregue:</strong> Veja se apareceu um registro em financeiro_clientes em vez de vendas</li>";
echo "</ol>";

echo "<div style='background-color: #ffecb3; padding: 15px; border-radius: 8px; margin: 15px 0;'>";
echo "<h4>🎯 O que estamos investigando:</h4>";
echo "<p><strong>Problema relatado:</strong> Quando você tenta adicionar uma VENDA, o sistema está inserindo no FINANCEIRO_CLIENTES em vez da tabela VENDAS.</p>";
echo "<p><strong>Registros destacados:</strong></p>";
echo "<ul>";
echo "<li><span style='background-color: #c8e6c9; padding: 2px 6px;'>Verde</span> = Inserções recentes em <strong>vendas</strong> (correto)</li>";
echo "<li><span style='background-color: #ffeb3b; padding: 2px 6px;'>Amarelo</span> = Inserções recentes em <strong>financeiro_clientes</strong> (suspeito se foi feito via modal de vendas)</li>";
echo "</ul>";
echo "</div>";

echo "<p><a href='verificar_triggers.php' style='color: blue; text-decoration: underline;'>🔗 Ver triggers do banco de dados</a></p>";
echo "<p><a href='javascript:window.location.reload()' style='color: green; text-decoration: underline;'>🔄 Recarregar esta página</a></p>";

mysqli_close($conn);
?>
