-- OTIMIZAÇÃO DE PERFORMANCE PARA TABELA PEDIDOS
-- Execute estes comandos SQL para melhorar a performance das consultas

-- Índices para tabela pedidos
ALTER TABLE pedidos ADD INDEX idx_id_cliente (id_cliente);
ALTER TABLE pedidos ADD INDEX idx_data (data);

-- Índices para tabela vendas
ALTER TABLE vendas ADD INDEX idx_id_pedido (id_pedido);
ALTER TABLE vendas ADD INDEX idx_valor (valor);

-- Índices para tabela financeiro_clientes
ALTER TABLE financeiro_clientes ADD INDEX idx_id_pedido (id_pedido);
ALTER TABLE financeiro_clientes ADD INDEX idx_valor (valor);

-- Índices para tabela usuarios
ALTER TABLE usuarios ADD INDEX idx_id_empresa (id_empresa);
ALTER TABLE usuarios ADD INDEX idx_nome (nome);

-- Índice composto para consultas mais complexas
ALTER TABLE pedidos ADD INDEX idx_cliente_data (id_cliente, data);

-- NOTA: Execute apenas os índices que ainda não existem no seu banco de dados
-- Para verificar índices existentes, use: SHOW INDEX FROM nome_da_tabela;
