<?php include 'includes/tema/topo.php'; ?>

<style>
/* Estilos específicos para a linha de totais dinâmicos */
#totais-dinamicos {
    position: sticky;
    bottom: 0;
    z-index: 100;
    transition: all 0.3s ease;
}

/* Responsividade para dispositivos móveis */
@media (max-width: 767px) {
    #totais-dinamicos .row {
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 15px !important;
    }
    
    #totais-dinamicos .totais-valores {
        flex-direction: column !important;
        gap: 12px !important;
        margin-top: 10px !important;
        width: 100%;
    }
    
    #totais-dinamicos .totais-valores > div {
        justify-content: space-between;
        width: 100%;
        padding: 8px 12px;
        background: rgba(255,255,255,0.8);
        border-radius: 8px;
        border: 1px solid #e0e0e0;
    }
}

/* Melhorar contraste em telas pequenas */
@media (max-width: 576px) {
    #totais-dinamicos {
        padding: 15px 10px !important;
        font-size: 12px;
    }
    
    #totais-dinamicos .totais-valores span {
        font-size: 12px !important;
    }
}

/* Animação suave para os valores dos totais */
#total-vendas-filtrado, #total-pagamentos-filtrado, #diferenca-total-filtrado {
    transition: all 0.3s ease;
}

/* Efeito hover nos badges dos totais */
#totais-dinamicos .totais-valores > div:hover span[id*="total"] {
    transform: scale(1.05);
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

/* Garantir que a tabela tenha overflow controlado */
.dt-responsive {
    overflow-x: auto;
    position: relative;
}

/* Ajustar espaçamento do DataTable */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter,
.dataTables_wrapper .dataTables_info,
.dataTables_wrapper .dataTables_paginate {
    margin: 0.5em 0;
}

/* Melhorar visual dos inputs de busca no footer */
.footer-search-input {
    transition: all 0.3s ease;
    font-size: 12px !important;
}

.footer-search-input:focus {
    background-color: #fff3cd !important;
    border-color: #ffc107 !important;
    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.25) !important;
}

/* Indicador visual para linhas filtradas */
#footer-search tbody tr.filtered-out {
    opacity: 0.5;
    transition: opacity 0.3s ease;
}

/* Melhorar visual da info do DataTable */
.dataTables_info {
    font-size: 13px;
    color: #6c757d;
    font-weight: 500;
}

/* Destaque para totais dinâmicos durante atualização */
#totais-dinamicos.updating {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%) !important;
    border-color: #ffc107 !important;
}
</style>

<?

$acao = antiSQL($_GET['acao']);		
$idpedido = antiSQL($_GET['id_pedido']);
		
$Inserir = antiSQL($_POST['Inserir']);
$Alterar = antiSQL($_POST['Alterar']);
$Excluir = antiSQL($_GET['Excluir']);

$id_cliente = antiSQL($_POST['id_cliente']);	
$id_produto = antiSQL($_POST['id_produto']);
$data = antiSQL(date("d/m/Y"));
$hora = antiSQL(date("H:i"));		
$status = antiSQL($_POST['status']);			




$checa_pedidos = mysqli_query($conn,"SELECT * FROM pedidos ")->fetch_array(); 

if($checa_pedidos['id_cliente'] == $id_cliente){

    echo 'Já existe pedido cadastrado para este cliente';


}else{

if ($Inserir == "ok") {
mysqli_query($conn,"INSERT INTO pedidos (id_cliente,data,hora) VALUES ('$id_cliente','$data','$hora')");
header( 'Location: pedidos.php?cadastrado_sucesso=sim');
}

}		

if ($Alterar == "ok"){
mysqli_query($conn,"UPDATE pedidos SET id_cliente='$id_cliente',data='$data',hora='$hora' WHERE id=$idpedido");
	
header( 'Location: pedidos.php?alterado_sucesso=sim');
}

if ($Excluir == "ok") {	
    mysqli_query($conn,"DELETE FROM pedidos WHERE id=$idpedido");
    mysqli_query($conn,"ALTER TABLE pedidos AUTO_INCREMENT = 1");	
    header('Location: pedidos.php?deletado_sucesso=sim');
} 




?>

<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

            <? if ($acao == "Alterar") { 
             $sql = mysqli_query($conn,"SELECT * FROM pedidos WHERE id=$idpedido")->fetch_array(); 
             
             } ?>

            <? if ($acao != "") { ?>
            <div class="smart-wrap">
                <div class="smart-forms smart-container wrap-0">
                    <div class="form-header header-blue ">
                        <h4><i class="fa fa-calendar-o"></i> Pedidos  </h4>
                    </div><!-- end .form-header section -->



                    <form name="usuarios" id="usuarios" method="post" action="<?php echo $_SERVER['PHP_SELF']?>"
                        enctype="multipart/form-data">


                        <div class="form-body">


                            <div class="spacer-b30">
                                <div class="tagline"><span style="color: black"> Cliente</span></div><!-- .tagline -->
                            </div>

                            <div class="frm-row">
                                <div class="section colm colm4">
                                </div>
                                <div class="section colm colm4">
                                    <label class="field select prepend-icon">

                                        <select name="id_cliente" class="example-data-array smart-select2 select2-hidden-accessible" style="width:100%"
                                        tabindex="-1" aria-hidden="true">
                                        <option value="">Selecionar Cliente</option>
                                            <? $sqla = mysqli_query($conn,"SELECT * FROM usuarios ORDER BY id");
while ($coluna = mysqli_fetch_array($sqla)) { ?>

                                            <option value="<? echo $coluna[id]?>" <? if
                                                ($sql['id_cliente']==$coluna[id]) echo " selected" ; ?> >
                                                <span style="color: "><? echo $coluna[nome]?></span>
                                            </option>
                                            <? } ?>
                                        </select> <span class="field-icon"><i class="fa fa-user"></i></span> <b
                                            class="tooltip tip-right-top"><b>Selecione o <span
                                                    style="color:#6CF;">Cliente</span> Exemplo: <span
                                                    style="color:#6CF;"> Usuario </span></b></b> </label>
                                </div>
                            </div>










                        </div>




                        <div class="form-footer" align="center">
                            <input type="hidden" name="id_pedido" value="<?php echo $idpedido; ?>">
                            <input type="hidden" name="<?php echo $acao; ?>" value="ok">
                            <input type="submit" class="button btn-blue" name="Submit" value="<?php echo $acao; ?>">

                        </div>

                    </form>
                </div>
            </div>



            <div class="row page-titles">

<div class="col-md-7 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='<? $pagina = basename($_SERVER['PHP_SELF'], ''); echo $pagina; ?>';"><i
                class="fa fa-plus-circle"></i>
            Voltar</button>
    </div>
</div>
</div>


            <? } else { ?>


                <div style="clear: both;"></div>


<div class="col-sm-12">
    <div class="card">
        <div class="card-header">
            <h5>Tabela:
                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                    echo ucfirst(strtolower($pagina)); ?>
            </h5>
            <small>Aqui você tem as opções de <b>cadastrar</b>,<b>editar</b>,<b>excluir</b> <span
                    style="color:red;">
                    <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                        echo ucfirst(strtolower($pagina)); ?><span>.</small>
        </div>
        <div class="card-body">
            <div class="dt-responsive table-responsive">

                <table id="footer-search" class="table table-striped table-bordered nowrap">                                <thead>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;color:green" >Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead><tfoot>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;">Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>                                </tfoot><tbody>                                    <?
                                    // OTIMIZAÇÃO: Uma única query com JOINs para buscar todos os dados necessários
                                    $sqlpedidos = mysqli_query($conn,"
                                        SELECT 
                                            p.id,
                                            p.id_cliente,
                                            p.data,
                                            u.nome as cliente_nome,
                                            u.id_empresa,
                                            e.empresa as empresa_nome,
                                            COALESCE(v.total_vendas, 0) as total_vendas,
                                            COALESCE(f.total_pagamentos, 0) as total_pagamentos
                                        FROM pedidos p
                                        LEFT JOIN usuarios u ON p.id_cliente = u.id
                                        LEFT JOIN empresas e ON u.id_empresa = e.id
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_vendas 
                                            FROM vendas 
                                            GROUP BY id_pedido
                                        ) v ON p.id = v.id_pedido
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_pagamentos 
                                            FROM financeiro_clientes 
                                            GROUP BY id_pedido
                                        ) f ON p.id = f.id_pedido
                                        ORDER BY p.id ASC
                                    ");
                                    
                                    while ($pedidos = mysqli_fetch_array($sqlpedidos)) { 
                                        $total_vendas = floatval($pedidos['total_vendas']);
                                        $total_pagamentos = floatval($pedidos['total_pagamentos']);
                                        $diferenca = $total_vendas - $total_pagamentos;
                                    ?>                                    <tr>
                                        <td style="width: 5%"> 
                                            <? echo $pedidos['id']; ?>  
                                        </td>
                                        <td> 
                                            <a href="usuarios.php?acao=Alterar&id_usuario=<?php echo $pedidos['id_cliente'];?>">
                                                <?php echo $pedidos['cliente_nome']; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="empresas.php?acao=Alterar&id_empresas=<?php echo $pedidos['id_empresa'];?>">
                                                <?php echo $pedidos['empresa_nome']; ?>
                                            </a>
                                        </td><td style="width: 12%;" data-vendas="<?php echo $total_vendas; ?>">
                                            <?php echo 'R$ '.number_format($total_vendas, 2, "," , "." ); ?>
                                        </td>
                                        <td style="width: 7%" data-pagamentos="<?php echo $total_pagamentos; ?>">
                                            <?php echo 'R$ '.number_format($total_pagamentos, 2, "," , "." ); ?>
                                            
                                            <!-- Botão de Calculadora de ( + e - ) -->
                                            <i class="fa-solid fa-calculator-simple" data-toggle="tooltip" data-placement="top" title="" data-original-title="
                                                <?php 
                                                if ($total_pagamentos > $total_vendas) {
                                                    echo 'Tem Há Receber: R$ '.number_format(($total_pagamentos - $total_vendas), 2, "," , "." );
                                                } else {
                                                    echo 'Falta Pagar: R$ '.number_format($diferenca, 2, "," , "." );
                                                }
                                                ?>
                                            "></i>
                                        </td><td style="width: 7%">
                                            <? echo $pedidos['data']; ?>
                                        </td>                                        <td style="width: 40px;"> 
                                            <button type="button" class="btn waves-effect waves-light btn-outline-info" data-toggle="tooltip" data-placement="top" title="" data-original-title="Editar" aria-describedby="tooltip647345">
                                                <a href="?acao=Alterar&id_pedido=<?php echo $pedidos['id'];?>">
                                                    <i class="fa fa-edit" style="font-size:20px; color:#0A94E1"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-warning waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Vendas" aria-describedby="tooltip647345">
                                                <a href="vendas.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-ticket" style="font-size:20px; color:#E1740A"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-success waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Financeiro" aria-describedby="tooltip647345">
                                                <a href="financeiro_clientes.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-solid fa-badge-dollar" style="font-size:20px; color:#32CD32"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-danger waves-effect waves-light " data-toggle="tooltip" data-placement="top" title="" data-original-title="Excluir">
                                                <a href="?Excluir=ok&id_pedido=<? echo $pedidos['id']; ?>" onClick="return pergunta();">
                                                    <i class="fa fa-trash" style="font-size:20px; color:#C80306"></i>
                                                </a>
                                            </button>
                                        </td>
                                    </tr>
                                    <? } ?>                                </tbody>                            
                            </table>
                              <!-- Totais dinâmicos grudados à tabela -->
                            <div id="totais-dinamicos" style="
                                margin: 0; 
                                padding: 12px 15px; 
                                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                                border: 1px solid #dee2e6; 
                                border-top: 2px solid #007bff;
                                border-radius: 0 0 4px 4px;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                                position: relative;
                                z-index: 10;
                            ">
                                <div class="row" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px; margin: 0;">                                    <div style="font-weight: 600; color: #495057; font-size: 14px; display: flex; align-items: center;">
                                        <span style="margin-right: 8px; font-size: 16px;">📊</span>
                                        <span id="totais-label">Totais dos Dados Filtrados</span>
                                    </div>                                    <div class="totais-valores" style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#99a832; font-weight: 600; font-size: 13px;">💰 Vendas:</span> 
                                            <span id="total-vendas-filtrado" style="font-weight: 700; color: #2c5f2d; background: #d4edda; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#5ca832; font-weight: 600; font-size: 13px;">💳 Pagamentos:</span> 
                                            <span id="total-pagamentos-filtrado" style="font-weight: 700; color: #155724; background: #d1ecf1; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#3266a8; font-weight: 600; font-size: 13px;">📈 Saldo:</span> 
                                            <span id="diferenca-total-filtrado" style="font-weight: 700; color: #004085; background: #cce7ff; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                    </div>
                                </div>                            </div><?
                           // CORREÇÃO: Primeiro calcular todos os totais
                           $sql_totais_completos = mysqli_query($conn,"
                               SELECT 
                                   (SELECT COALESCE(SUM(valor), 0) FROM vendas) as total_vendas_completo,
                                   (SELECT COALESCE(SUM(valor), 0) FROM financeiro_clientes) as total_pagamentos_completo,
                                   (
                                       SELECT COALESCE(SUM(v.total_vendas), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_vendas 
                                           FROM vendas 
                                           GROUP BY id_pedido
                                       ) v ON p.id = v.id_pedido
                                   ) as total_vendas_por_pedidos,
                                   (
                                       SELECT COALESCE(SUM(f.total_pagamentos), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_pagamentos 
                                           FROM financeiro_clientes 
                                           GROUP BY id_pedido
                                       ) f ON p.id = f.id_pedido
                                   ) as total_pagamentos_por_pedidos
                           ");
                           
                           $totais_completos = mysqli_fetch_array($sql_totais_completos);
                           $diferenca_completa = $totais_completos['total_vendas_completo'] - $totais_completos['total_pagamentos_completo'];
                             // CORREÇÃO: Calcular registros órfãos baseado na diferença real
                           $vendas_orfas_valor = $totais_completos['total_vendas_completo'] - $totais_completos['total_vendas_por_pedidos'];
                           $pagamentos_orfaos_valor = $totais_completos['total_pagamentos_completo'] - $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // DEBUG: Forçar exibição para diagnóstico
                           $debug_vendas = $totais_completos['total_vendas_completo'];
                           $debug_vendas_pedidos = $totais_completos['total_vendas_por_pedidos']; 
                           $debug_pagamentos = $totais_completos['total_pagamentos_completo'];
                           $debug_pagamentos_pedidos = $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // Contar registros órfãos para exibição
                           $vendas_orfas = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM vendas v 
                               LEFT JOIN pedidos p ON v.id_pedido = p.id 
                               WHERE p.id IS NULL OR v.id_pedido = 0 OR v.id_pedido IS NULL
                           ");
                           $vendas_orfas_result = mysqli_fetch_array($vendas_orfas);
                           
                           $pagamentos_orfaos = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM financeiro_clientes f 
                               LEFT JOIN pedidos p ON f.id_pedido = p.id 
                               WHERE p.id IS NULL OR f.id_pedido = 0 OR f.id_pedido IS NULL
                           ");
                           $pagamentos_orfaos_result = mysqli_fetch_array($pagamentos_orfaos);
                           
                           ?>
                             </div>
                        </div>
                    </div>
                </div>
                  <!-- Totais Gerais do Sistema (fora do card da tabela) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-chart-line mr-2"></i>Totais Gerais do Sistema
                                <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                <span class="badge badge-danger ml-2">⚠️ Registros Órfãos</span>
                                <?php else: ?>
                                <span class="badge badge-success ml-2">✅ Dados Íntegros</span>
                                <?php endif; ?>
                            </h6>
                        </div>
                        <div class="card-body py-3">
                            <div class="row">                                <div class="col-md-8">
                                    <div style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#99a832; font-weight: 600;">💰 Total Vendas:</span>
                                            <span style="font-weight: 700; color: #2c5f2d; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_vendas_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#5ca832; font-weight: 600;">💳 Total Pagamentos:</span>
                                            <span style="font-weight: 700; color: #155724; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_pagamentos_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#3266a8; font-weight: 600;">📈 Saldo Total:</span>
                                            <span style="font-weight: 700; color: #004085; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($diferenca_completa, 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div><div class="col-md-4">
                                    <small style="color: #6c757d; line-height: 1.4;">
                                        <strong>Inclui todos os registros do sistema</strong><br>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <span style="color: #dc3545;">⚠️ Registros Órfãos Detectados:</span><br>
                                        <?php if($vendas_orfas_valor > 0): ?>
                                        • <strong>Vendas:</strong> <?php echo $vendas_orfas_result['total']; ?> registros 
                                        (R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?>)<br>
                                        <?php endif; ?>
                                        <?php if($pagamentos_orfaos_valor > 0): ?>
                                        • <strong>Pagamentos:</strong> <?php echo $pagamentos_orfaos_result['total']; ?> registros 
                                        (R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>)
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <span style="color: #28a745;">✅ Nenhum registro órfão detectado</span><br>
                                        <small style="color: #999;">Todos os registros estão vinculados a pedidos válidos</small>
                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>                            
                            <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #999; font-size: 12px;">
                                    <strong>📋 Totais apenas de Pedidos Válidos (sem órfãos):</strong><br>
                                    <span style="color:#99a832;">💰 Vendas:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#5ca832;">💳 Pagamentos:</span> R$ <?php echo number_format($totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#3266a8;">📈 Saldo:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'] - $totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                </small>
                            </div>
                            <?php else: ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #28a745; font-size: 12px;">
                                    <strong>✅ Todos os registros estão corretamente vinculados a pedidos válidos</strong>
                                </small>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>                
                <!-- Card de Debug/Auditoria (sempre visível para diagnóstico) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'exclamation-triangle' : 'info-circle'; ?> mr-2"></i>
                                <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'Auditoria de Registros Órfãos' : 'Auditoria dos Dados (Debug)'; ?>
                                <button class="btn btn-sm btn-outline-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'dark' : 'light'; ?> float-right" type="button" data-toggle="collapse" data-target="#collapseOrfaos" aria-expanded="false" aria-controls="collapseOrfaos">
                                    <i class="fa fa-chevron-down"></i> Detalhes
                                </button>
                            </h6>
                        </div>
                        <div class="collapse" id="collapseOrfaos">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 style="color: #dc3545;">🔍 Análise dos Dados:</h6>
                                        <ul style="font-size: 13px; margin-bottom: 0;">
                                            <li><strong>Total Vendas Sistema:</strong> R$ <?php echo number_format($debug_vendas, 2, "," , "." ); ?></li>
                                            <li><strong>Vendas em Pedidos:</strong> R$ <?php echo number_format($debug_vendas_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Vendas:</strong> R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?> 
                                                <?php if($vendas_orfas_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $vendas_orfas_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                            <hr style="margin: 10px 0;">
                                            <li><strong>Total Pagamentos Sistema:</strong> R$ <?php echo number_format($debug_pagamentos, 2, "," , "." ); ?></li>
                                            <li><strong>Pagamentos em Pedidos:</strong> R$ <?php echo number_format($debug_pagamentos_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Pagamentos:</strong> R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>
                                                <?php if($pagamentos_orfaos_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $pagamentos_orfaos_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                        </ul>
                                        
                                        <div class="mt-3">
                                            <small style="color: #666; background: #f8f9fa; padding: 8px; border-radius: 4px; display: block;">
                                                <strong>🔧 Debug Info:</strong><br>
                                                Vendas órfãs calculadas: <?php echo $vendas_orfas_valor; ?><br>
                                                Pagamentos órfãos calculados: <?php echo $pagamentos_orfaos_valor; ?><br>
                                                Condição (valor > 0): <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'TRUE' : 'FALSE'; ?>
                                            </small>                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 style="color: #856404;">⚙️ Status e Recomendações:</h6>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <div class="alert alert-warning py-2 mb-2">
                                            <strong>⚠️ Registros Órfãos Detectados</strong>
                                        </div>
                                        
                                        <h6 style="font-size: 12px; color: #dc3545; margin-bottom: 8px;">Possíveis Causas:</h6>
                                        <ul style="font-size: 12px; color: #6c757d; margin-bottom: 12px;">
                                            <?php if($vendas_orfas_valor > 0): ?>
                                            <li>Vendas com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Vendas criadas antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação das vendas</li>
                                            <?php endif; ?>
                                            <?php if($pagamentos_orfaos_valor > 0): ?>
                                            <li>Pagamentos com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Pagamentos criados antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação dos pagamentos</li>
                                            <?php endif; ?>
                                        </ul>
                                          <div style="background: #fff3cd; padding: 8px; border-radius: 4px; border-left: 3px solid #ffc107;">
                                            <small style="color: #856404;">
                                                <strong>💡 Recomendação:</strong> Verificar a integridade dos dados nas tabelas <code>vendas</code> e <code>financeiro_clientes</code>.
                                            </small>
                                        </div>
                                        
                                        <?php else: ?>
                                        <div class="alert alert-success py-2 mb-2">
                                            <strong>✅ Todos os Dados Estão Integros</strong>
                                        </div>
                                        
                                        <ul style="font-size: 12px; color: #28a745; margin-bottom: 12px;">
                                            <li>✓ Todas as vendas estão vinculadas a pedidos válidos</li>
                                            <li>✓ Todos os pagamentos estão vinculados a pedidos válidos</li>
                                            <li>✓ Não há registros órfãos no sistema</li>
                                        </ul>
                                          <div style="background: #d4edda; padding: 8px; border-radius: 4px; border-left: 3px solid #28a745;">
                                            <small style="color: #155724;">
                                                <strong>👍 Sistema OK:</strong> A integridade dos dados está mantida.
                                            </small>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>                        </div>
                    </div>
                </div>

            <div class="row page-titles">

<div class="col-md-3 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='?acao=Inserir';"><i class="fa fa-plus-circle"></i> Adicionar
            <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
echo ucfirst(strtolower($pagina)); ?>
        </button>
    </div>
</div>
</div>


<? } ?>

<!-- Search API (Regular Expressions) table end -->
</div>
</section>



<?php include 'includes/tema/base.php'; ?>

<script>
$(document).ready(function () {
    // Change selectboxes to selectize mode to be searchable
    $("select").select2();
    
    // Verificar se a tabela já foi inicializada e destruir se necessário
    if ($.fn.DataTable.isDataTable('#footer-search')) {
        $('#footer-search').DataTable().destroy();
    }      // Initialize DataTable com configuração melhorada
    var table = $('#footer-search').DataTable({
        dom: 'Blfrtip',
        mark: true,
        buttons: {
            name: 'primary',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        },
        "language": {
            "url": "datatable/pt-BR.json"
        },
        "pageLength": 25,
        "responsive": true,
        "processing": true,
        "search": {
            "regex": true,
            "caseInsensitive": true
        },"initComplete": function () {
            // Configurar busca no footer após inicialização completa
            setupFooterSearch();
            // Calcular totais iniciais com delay
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
            }, 500);
        },        "drawCallback": function () {
            // Recalcular totais sempre que a tabela for redesenhada (filtros, busca, paginação)
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
                
                // Reinicializar tooltips nas novas linhas
                $('[data-toggle="tooltip"]').tooltip('dispose').tooltip({
                    delay: { show: 300, hide: 100 }
                });
            }, 100);
        },
        "infoCallback": function(settings, start, end, max, total, pre) {
            // Personalizar a mensagem de informação para mostrar registros filtrados
            var filteredCount = settings.fnRecordsDisplay();
            var totalCount = settings.fnRecordsTotal();
            
            if (filteredCount === totalCount) {
                return "Mostrando registros de " + start + " a " + end + " de um total de " + total + " registros";
            } else {
                return "Mostrando registros de " + start + " a " + end + " de " + filteredCount + " registros filtrados (total: " + totalCount + " registros)";
            }
        }
    });

    // Função para ajustar layout dos totais em diferentes tamanhos de tela
    function ajustarLayoutTotais() {
        var $totais = $('#totais-dinamicos');
        var windowWidth = $(window).width();
        
        if (windowWidth < 768) {
            // Mobile: layout vertical
            $totais.find('.row').css({
                'flex-direction': 'column',
                'align-items': 'flex-start'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'column',
                'gap': '10px',
                'margin-top': '10px'
            });
        } else {
            // Desktop: layout horizontal
            $totais.find('.row').css({
                'flex-direction': 'row',
                'align-items': 'center'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'row',
                'gap': '25px',
                'margin-top': '0'
            });
        }
    }
    
    // Ajustar layout ao redimensionar janela
    $(window).resize(function() {
        setTimeout(ajustarLayoutTotais, 100);
    });    function setupFooterSearch() {        // Aguardar um pouco para garantir renderização completa
        setTimeout(function() {
            table.columns().every(function (index) {
                var column = this;
                var title = $(column.footer()).text().trim();
                
                // Pular coluna de Ações (última coluna)
                if (index === 6) {
                    $(column.footer()).html('');
                    return;
                }
                
                if (title) {
                    // Criar input com wrapper original
                    $(column.footer()).html('<div class="md-input-wrapper"><input type="text" class="md-form-control footer-search-input" placeholder="Buscar ' + title + '" data-column="' + index + '" /></div>');
                    
                    // Configurar evento de busca com delay para melhor performance
                    var searchTimeout;
                    $('input', column.footer()).on('keyup change clear', function () {
                        var searchValue = this.value;
                        var columnIndex = $(this).data('column');
                        
                        // Limpar timeout anterior
                        clearTimeout(searchTimeout);
                        
                        // Aplicar busca com delay
                        searchTimeout = setTimeout(function() {
                            if (column.search() !== searchValue) {
                                column.search(searchValue, true, false).draw();
                                
                                // Recalcular totais após busca
                                setTimeout(function() {
                                    calcularTotaisFiltrados();
                                }, 100);
                            }
                        }, 300);
                    });
                    
                    // Prevenir ordenação ao clicar no input
                    $('input', column.footer()).on('click', function(e) {
                        e.stopPropagation();
                    });
                }            });
            
            // Configurar busca global também - com evento mais específico
            $('.dataTables_filter input').off('keyup.totais change.totais').on('keyup.totais change.totais', function() {
                setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 300);
            });
            
            // Configurar evento para limpeza de busca
            $('.dataTables_filter input').off('search.totais').on('search.totais', function() {
                if (this.value === '') {
                    setTimeout(function() {
                        calcularTotaisFiltrados();
                    }, 100);
                }
            });
            
            // Inicializar tooltips após tudo carregado
            $('[data-toggle="tooltip"]').tooltip({
                delay: { show: 300, hide: 100 }            });
        }, 300);
    }    function calcularTotaisFiltrados() {
        // Adicionar indicador visual de atualização
        $('#totais-dinamicos').addClass('updating');
        
        var linhasVisiveis = table.rows({ filter: 'applied' }).count();
        var totalLinhas = table.rows().count();
        var buscaGlobal = table.search();
        
        // Verificar se há busca em alguma coluna
        var buscaPorColunaAtiva = false;
        table.columns().every(function() {
            if (this.search() !== '') {
                buscaPorColunaAtiva = true;
                return false;
            }
        });
        
        console.log('🔍 DEBUG calcularTotaisFiltrados:');
        console.log('  - Busca global:', '"' + buscaGlobal + '"', '(vazia:', buscaGlobal === '', ')');
        console.log('  - Busca por coluna ativa:', buscaPorColunaAtiva);
        console.log('  - Linhas visíveis:', linhasVisiveis);
        console.log('  - Total de linhas:', totalLinhas);
        
        // CORREÇÃO PRINCIPAL: Forçar detecção de filtro quando há diferença nas linhas
        // Mesmo que a busca pareça vazia, se há menos linhas visíveis, há filtro ativo
        var temFiltroAtivo = (buscaGlobal !== '') || buscaPorColunaAtiva || (linhasVisiveis < totalLinhas);
        
        console.log('  - Tem filtro ativo:', temFiltroAtivo);
        console.log('  - Critérios: busca_global=' + (buscaGlobal !== '') + ', busca_coluna=' + buscaPorColunaAtiva + ', linhas_diferentes=' + (linhasVisiveis < totalLinhas));
        
        if (!temFiltroAtivo) {
            console.log('✅ Exibindo totais gerais (sem filtros)');
            $('#totais-label').text('Totais Gerais dos Dados');
            setTimeout(function() {
                animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.vendas));
                animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.pagamentos));
                animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.diferenca));
                $('#totais-dinamicos').removeClass('updating');
            }, 200);
            return;
        }
        
        // Há filtros ativos - calcular totais apenas dos dados filtrados
        console.log('🔢 Calculando totais filtrados...');
        $('#totais-label').text('Totais dos Dados Filtrados (' + linhasVisiveis + ' de ' + totalLinhas + ' registros)');
        
        var totalVendas = 0;
        var totalPagamentos = 0;
        var contadorProcessado = 0;
        
        try {
            table.rows({ filter: 'applied' }).every(function() {
                var node = this.node();
                var $node = $(node);
                contadorProcessado++;
                
                // Método 1: Tentar atributos data-*
                var vendasAttr = $node.find('td[data-vendas]').attr('data-vendas');
                var pagamentosAttr = $node.find('td[data-pagamentos]').attr('data-pagamentos');
                
                var vendas = parseFloat(vendasAttr) || 0;
                var pagamentos = parseFloat(pagamentosAttr) || 0;
                
                // Método 2: Se não funcionou, extrair do texto
                if (vendas === 0 && pagamentos === 0) {
                    var vendasTexto = $node.find('td:eq(3)').text().trim();
                    var pagamentosTexto = $node.find('td:eq(4)').text().trim();
                    
                    vendas = extrairValorMonetario(vendasTexto);
                    pagamentos = extrairValorMonetario(pagamentosTexto);
                    
                    if (contadorProcessado <= 3) {
                        console.log('   📄 [' + contadorProcessado + '] Extraído do texto:');
                        console.log('     Vendas texto:', vendasTexto, '→', vendas);
                        console.log('     Pagamentos texto:', pagamentosTexto, '→', pagamentos);
                    }
                } else {
                    if (contadorProcessado <= 3) {
                        console.log('   🏷️ [' + contadorProcessado + '] Extraído dos atributos:');
                        console.log('     Vendas attr:', vendasAttr, '→', vendas);
                        console.log('     Pagamentos attr:', pagamentosAttr, '→', pagamentos);
                    }
                }
                
                totalVendas += vendas;
                totalPagamentos += pagamentos;
            });
            
        } catch (error) {
            console.error('❌ Erro ao calcular totais filtrados:', error);
            
            // Fallback: método alternativo
            $('#footer-search tbody tr:visible').each(function() {
                var $row = $(this);
                var vendasTexto = $row.find('td:eq(3)').text().trim();
                var pagamentosTexto = $row.find('td:eq(4)').text().trim();
                
                var vendas = extrairValorMonetario(vendasTexto);
                var pagamentos = extrairValorMonetario(pagamentosTexto);
                
                totalVendas += vendas;
                totalPagamentos += pagamentos;
            });
        }
        
        console.log('📊 Totais finais:');
        console.log('  - Registros processados:', contadorProcessado);
        console.log('  - Total Vendas:', totalVendas);
        console.log('  - Total Pagamentos:', totalPagamentos);
        console.log('  - Diferença:', totalVendas - totalPagamentos);
        
        var diferenca = totalVendas - totalPagamentos;
        
        // Atualizar elementos na página
        setTimeout(function() {
            animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totalVendas));
            animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totalPagamentos));
            animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(diferenca));
            $('#totais-dinamicos').removeClass('updating');
        }, 200);
    }
    
    // Função para animar atualização de valores
    function animarAtualizacaoValor(seletor, novoValor) {
        var $elemento = $(seletor);
        var valorAtual = $elemento.text();
        
        if (valorAtual !== novoValor) {
            $elemento.fadeOut(150, function() {
                $elemento.text(novoValor).fadeIn(150);
            });
        }    }
    
    // Auto-expandir card de auditoria se houver registros órfãos
    <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
    setTimeout(function() {
        $('#collapseOrfaos').collapse('show');
        
        // Scroll suave até o card de auditoria
        $('html, body').animate({
            scrollTop: $('#collapseOrfaos').offset().top - 100
        }, 1000);
    }, 1500);
    <?php endif; ?>
      // Adicionar variável JavaScript com os totais corretos do PHP
    var totaisCorretosPHP = {
        vendas: <?php echo $totais_completos['total_vendas_completo']; ?>,
        pagamentos: <?php echo $totais_completos['total_pagamentos_completo']; ?>,
        diferenca: <?php echo $diferenca_completa; ?>
    };    function extrairValorMonetario(texto) {
        if (!texto) return 0;
        
        // Converter para string e remover tags HTML e espaços extra
        var textoLimpo = texto.toString()
            .replace(/<[^>]*>/g, '')         // Remove tags HTML
            .replace(/&nbsp;/g, ' ')         // Remove &nbsp;
            .replace(/\s+/g, ' ')            // Normaliza espaços
            .trim();
        
        // Remover 'R$' e outros caracteres não numéricos exceto vírgula, ponto e dígitos
        var textoNumerico = textoLimpo
            .replace(/R\$\s*/g, '')          // Remove R$
            .replace(/[^\d,.]/g, '')         // Mantém apenas dígitos, vírgula e ponto
            .trim();
        
        if (!textoNumerico) {
            return 0;
        }
        
        // Padrões para valores monetários brasileiros
        var padroes = [
            /(\d{1,3}(?:\.\d{3})*,\d{2})/,    // Ex: 1.234,56 ou 123.456,78
            /(\d+,\d{2})/,                     // Ex: 1234,56
            /(\d+\.\d{2})/,                    // Ex: 1234.56 (formato americano)
            /(\d+)/                            // Ex: 1234 (sem centavos)
        ];
        
        for (var i = 0; i < padroes.length; i++) {
            var match = textoNumerico.match(padroes[i]);
            if (match) {
                var valorStr = match[1];
                
                // Converter para formato padrão JavaScript
                if (valorStr.includes(',')) {
                    // Formato brasileiro (vírgula como decimal)
                    valorStr = valorStr.replace(/\./g, '').replace(',', '.');
                }
                
                var resultado = parseFloat(valorStr) || 0;
                return resultado;
            }
        }        
        return 0;
    }
    
    function formatarValor(valor) {
        return valor.toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
      // Função de debug para testar manualmente no console    
    window.debugTotais = function() {
        console.log('=== DEBUG TOTAIS ===');
        console.log('DataTable instance:', table);
        console.log('Busca global:', table.search());
        console.log('Linhas total:', table.rows().count());
        console.log('Linhas filtradas:', table.rows({ filter: 'applied' }).count());
        
        table.columns().every(function(index) {
            var busca = this.search();
            if (busca !== '') {
                console.log('Coluna', index, 'busca:', busca);
            }
        });
        
        console.log('--- Dados das linhas filtradas ---');
        table.rows({ filter: 'applied' }).every(function() {
            var node = this.node();
            var $node = $(node);
            console.log('Linha:', $node.find('td:eq(1)').text(), 
                       'Vendas:', $node.find('td[data-vendas]').attr('data-vendas'),
                       'Pagamentos:', $node.find('td[data-pagamentos]').attr('data-pagamentos'));
        });
    };
      // Função adicional para debug da estrutura HTML
    window.debugEstruturaTabela = function() {
        console.log('=== DEBUG ESTRUTURA TABELA ===');
        
        var $tabela = $('#footer-search');
        console.log('Tabela encontrada:', $tabela.length > 0);
        
        if ($tabela.length > 0) {
            var $tbody = $tabela.find('tbody');
            var $linhas = $tbody.find('tr');
            
            console.log('Total de linhas no tbody:', $linhas.length);
            
            $linhas.each(function(index) {
                if (index < 3) { // Mostrar apenas as 3 primeiras linhas
                    var $linha = $(this);
                    console.log('--- Linha', index + 1, '---');
                    console.log('HTML da linha:', $linha[0].outerHTML.substring(0, 200) + '...');
                    
                    $linha.find('td').each(function(colIndex) {
                        var $celula = $(this);
                        var texto = $celula.text().trim();
                        var dataVendas = $celula.attr('data-vendas');
                        var dataPagamentos = $celula.attr('data-pagamentos');
                        
                        if (dataVendas || dataPagamentos || colIndex < 6) {
                            console.log('  Coluna', colIndex, ':', {
                                texto: texto,
                                dataVendas: dataVendas,
                                dataPagamentos: dataPagamentos
                            });
                        }
                    });
                }
            });
            
            // Testar busca atual
            console.log('--- Teste com dados filtrados ---');
            table.rows({ filter: 'applied' }).every(function() {
                var node = this.node();
                var $node = $(node);
                var cliente = $node.find('td:eq(1)').text().trim();
                var vendas = $node.find('td:eq(3)').text().trim();
                var pagamentos = $node.find('td:eq(4)').text().trim();
                
                console.log('Cliente filtrado:', cliente);
                console.log('  Vendas (texto):', vendas);
                console.log('  Pagamentos (texto):', pagamentos);
                console.log('  Vendas (data-attr):', $node.find('td[data-vendas]').attr('data-vendas'));
                console.log('  Pagamentos (data-attr):', $node.find('td[data-pagamentos]').attr('data-pagamentos'));
            });
        }
    };    // Função de teste específica para busca e totais
    window.testarBuscaETotais = function(termo) {
        termo = termo || 'Eliezer';
        console.log('=== TESTE COMPLETO DE BUSCA E TOTAIS ===');
        console.log('Termo de busca:', termo);
        
        // Limpar todas as buscas
        table.search('').columns().search('').draw();
        
        setTimeout(function() {
            console.log('1. Estado inicial (sem busca):');
            console.log('   Linhas visíveis:', table.rows({ filter: 'applied' }).count());
            console.log('   Total linhas:', table.rows().count());
            console.log('   Busca global atual:', '"' + table.search() + '"');
            
            // Executar busca
            console.log('2. Executando busca por "' + termo + '"...');
            table.search(termo).draw();
            
            setTimeout(function() {
                console.log('3. Após busca por "' + termo + '":');
                var linhasVisiveis = table.rows({ filter: 'applied' }).count();
                var totalLinhas = table.rows().count();
                var buscaAtual = table.search();
                
                console.log('   Linhas visíveis:', linhasVisiveis);
                console.log('   Total linhas:', totalLinhas);
                console.log('   Busca global atual:', '"' + buscaAtual + '"');
                console.log('   Busca vazia?', buscaAtual === '');
                console.log('   Filtro ativo?', linhasVisiveis < totalLinhas || buscaAtual !== '');
                
                console.log('4. Dados das linhas filtradas:');
                var somaVendas = 0, somaPagamentos = 0;
                var contadorLinhas = 0;
                
                table.rows({ filter: 'applied' }).every(function() {
                    contadorLinhas++;
                    var node = this.node();
                    var $node = $(node);
                    var cliente = $node.find('td:eq(1)').text().trim();
                    var vendasAttr = $node.find('td[data-vendas]').attr('data-vendas');
                    var pagamentosAttr = $node.find('td[data-pagamentos]').attr('data-pagamentos');
                    var vendasTexto = $node.find('td:eq(3)').text().trim();
                    var pagamentosTexto = $node.find('td:eq(4)').text().trim();
                    
                    var vendas = parseFloat(vendasAttr) || 0;
                    var pagamentos = parseFloat(pagamentosAttr) || 0;
                    
                    if (contadorLinhas <= 5) { // Mostrar apenas as primeiras 5
                        console.log('   → [' + contadorLinhas + '] Cliente:', cliente);
                        console.log('     Vendas (attr):', vendasAttr, '/ (parsed):', vendas);
                        console.log('     Pagamentos (attr):', pagamentosAttr, '/ (parsed):', pagamentos);
                        console.log('     Vendas (texto):', vendasTexto);
                        console.log('     Pagamentos (texto):', pagamentosTexto);
                    }
                    
                    somaVendas += vendas;
                    somaPagamentos += pagamentos;
                });
                
                console.log('5. Totais calculados manualmente (' + contadorLinhas + ' linhas):');
                console.log('   Vendas:', somaVendas);
                console.log('   Pagamentos:', somaPagamentos);
                console.log('   Diferença:', somaVendas - somaPagamentos);
                
                console.log('6. Forçando recálculo dos totais...');
                calcularTotaisFiltrados();
                
                setTimeout(function() {
                    console.log('7. Totais na tela após recálculo:');
                    console.log('   Label:', $('#totais-label').text());
                    console.log('   Vendas:', $('#total-vendas-filtrado').text());
                    console.log('   Pagamentos:', $('#total-pagamentos-filtrado').text());
                    console.log('   Saldo:', $('#diferenca-total-filtrado').text());
                }, 1000);
                
            }, 1000);
        }, 500);
    };
});
</script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>