<?php include 'includes/tema/topo.php'; ?>

<style>
/* Estilos específicos para a linha de totais dinâmicos */
#totais-dinamicos, #totais-pagina-atual {
    position: sticky;
    bottom: 0;
    z-index: 100;
    /* transition removida para evitar piscar */
}

/* Responsividade para dispositivos móveis */
@media (max-width: 767px) {
    #totais-dinamicos .row, #totais-pagina-atual .row {
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 15px !important;
    }
    
    #totais-dinamicos .totais-valores, #totais-pagina-atual .totais-valores-pagina {
        flex-direction: column !important;
        gap: 12px !important;
        margin-top: 10px !important;
        width: 100%;
    }
    
    #totais-dinamicos .totais-valores > div, #totais-pagina-atual .totais-valores-pagina > div {
        justify-content: space-between;
        width: 100%;
        padding: 8px 12px;
        background: rgba(255,255,255,0.8);
        border-radius: 8px;
        border: 1px solid #e0e0e0;
    }
}

/* Melhorar contraste em telas pequenas */
@media (max-width: 576px) {
    #totais-dinamicos, #totais-pagina-atual {
        padding: 15px 10px !important;
        font-size: 12px;
    }
    
    #totais-dinamicos .totais-valores span, #totais-pagina-atual .totais-valores-pagina span {
        font-size: 12px !important;
    }
}

/* Remover animações que causam piscar constante */
#total-vendas-filtrado, #total-pagamentos-filtrado, #diferenca-total-filtrado,
#total-vendas-pagina, #total-pagamentos-pagina, #diferenca-total-pagina {
    /* transition: all 0.3s ease; - REMOVIDO para evitar piscar */
}

/* Efeito hover nos badges dos totais - SEM animação */
#totais-dinamicos .totais-valores > div:hover span[id*="total"],
#totais-pagina-atual .totais-valores-pagina > div:hover span[id*="total"] {
    /* Removido transform e box-shadow para evitar efeitos de transição */
}

/* Garantir que a tabela tenha overflow controlado */
.dt-responsive {
    overflow-x: auto;
    position: relative;
}

/* Ajustar espaçamento do DataTable */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter,
.dataTables_wrapper .dataTables_info,
.dataTables_wrapper .dataTables_paginate {
    margin: 0.5em 0;
}

/* Melhorar visual dos inputs de busca no footer */
.footer-search-input {

}

.footer-search-input:focus {

}

/* Indicador visual para linhas filtradas - SEM animação */
#footer-search tbody tr.filtered-out {
    opacity: 0.5;
    /* transition removida para evitar piscar */
}

/* Melhorar visual da info do DataTable */
.dataTables_info {
    font-size: 13px;
    color: #6c757d;
    font-weight: 500;
}

/* Destaque para totais dinâmicos durante atualização - DESABILITADO */
#totais-dinamicos.updating, #totais-pagina-atual.updating {
    /* background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%) !important;
    border-color: #ffc107 !important; */
}

/* DIFERENCIAÇÃO VISUAL ESPECÍFICA ENTRE OS DOIS BLOCOS */

/* Bloco da Página Atual - Tom azul mais sutil */
#totais-pagina-atual {
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%) !important;
    border-left: 4px solid #2196f3 !important;
    border-top: 2px solid #2196f3 !important;
}

#totais-pagina-atual .totais-valores-pagina span[id*="total"] {
    background: rgba(33, 150, 243, 0.1) !important;
    color: #0d47a1 !important;
    border: 1px solid rgba(33, 150, 243, 0.2) !important;
    font-weight: 600 !important;
}

/* Bloco dos Totais Filtrados - Tom verde corporativo */
#totais-dinamicos {
    background: linear-gradient(135deg, #f1f8e9 0%, #dcedc8 100%) !important;
    border-left: 4px solid #4caf50 !important;
    border-top: 2px solid #4caf50 !important;
}

#totais-dinamicos .totais-valores span[id*="total"] {
    background: rgba(76, 175, 80, 0.12) !important;
    color: #1b5e20 !important;
    border: 1px solid rgba(76, 175, 80, 0.25) !important;
    font-weight: 700 !important;
}

/* Ícones específicos para cada bloco */
#totais-pagina-atual [style*="margin-right: 6px"] {
    color: #1976d2 !important;
}

#totais-dinamicos [style*="margin-right: 8px"] {
    color: #388e3c !important;
}

/* Hover effects diferenciados */
#totais-pagina-atual .totais-valores-pagina > div:hover span[id*="total"] {
    background: rgba(33, 150, 243, 0.2) !important;
    transform: scale(1.02);
    box-shadow: 0 2px 6px rgba(33, 150, 243, 0.3);
}

#totais-dinamicos .totais-valores > div:hover span[id*="total"] {
    background: rgba(76, 175, 80, 0.2) !important;
    transform: scale(1.02);
    box-shadow: 0 2px 6px rgba(76, 175, 80, 0.3);
}

/* Estilos personalizados para botões de exportação do DataTables */
.dt-buttons {
    margin-bottom: 15px;
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.dt-button {
    display: inline-flex !important;
    align-items: center;
    justify-content: center;
    padding: 8px 16px !important;
    margin: 0 !important;
    font-size: 13px !important;
    font-weight: 500 !important;
    border-radius: 6px !important;
    border: 1px solid transparent !important;
    transition: all 0.2s ease !important;
    text-decoration: none !important;
    cursor: pointer !important;
    min-height: 36px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1) !important;
}

/* Botão Copiar - Azul */
.dt-button[data-bs-original-title*="Copy"], 
.dt-button:contains("Copiar"),
.buttons-copy {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%) !important;
    color: white !important;
    border-color: #0056b3 !important;
}

.dt-button[data-bs-original-title*="Copy"]:hover,
.dt-button:contains("Copiar"):hover,
.buttons-copy:hover {
    background: linear-gradient(135deg, #0056b3 0%, #004085 100%) !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 8px rgba(0,123,255,0.3) !important;
}

/* Botão CSV - Verde */
.dt-button[data-bs-original-title*="CSV"],
.dt-button:contains("CSV"),
.buttons-csv {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%) !important;
    color: white !important;
    border-color: #1e7e34 !important;
}

.dt-button[data-bs-original-title*="CSV"]:hover,
.dt-button:contains("CSV"):hover,
.buttons-csv:hover {
    background: linear-gradient(135deg, #1e7e34 0%, #155724 100%) !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 8px rgba(40,167,69,0.3) !important;
}

/* Botão Excel - Verde escuro */
.dt-button[data-bs-original-title*="Excel"],
.dt-button:contains("Excel"),
.buttons-excel {
    background: linear-gradient(135deg, #198754 0%, #146c43 100%) !important;
    color: white !important;
    border-color: #146c43 !important;
}

.dt-button[data-bs-original-title*="Excel"]:hover,
.dt-button:contains("Excel"):hover,
.buttons-excel:hover {
    background: linear-gradient(135deg, #146c43 0%, #0f5132 100%) !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 8px rgba(25,135,84,0.3) !important;
}

/* Botão PDF - Vermelho */
.dt-button[data-bs-original-title*="PDF"],
.dt-button:contains("PDF"),
.buttons-pdf {
    background: linear-gradient(135deg, #dc3545 0%, #b02a37 100%) !important;
    color: white !important;
    border-color: #b02a37 !important;
}

.dt-button[data-bs-original-title*="PDF"]:hover,
.dt-button:contains("PDF"):hover,
.buttons-pdf:hover {
    background: linear-gradient(135deg, #b02a37 0%, #8b1e2b 100%) !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 8px rgba(220,53,69,0.3) !important;
}

/* Botão Imprimir - Roxo */
.dt-button[data-bs-original-title*="Print"],
.dt-button:contains("Imprimir"),
.buttons-print {
    background: linear-gradient(135deg, #6f42c1 0%, #5a2a9b 100%) !important;
    color: white !important;
    border-color: #5a2a9b !important;
}

.dt-button[data-bs-original-title*="Print"]:hover,
.dt-button:contains("Imprimir"):hover,
.buttons-print:hover {
    background: linear-gradient(135deg, #5a2a9b 0%, #4c237a 100%) !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 4px 8px rgba(111,66,193,0.3) !important;
}

/* Ícones dos botões */
.dt-button i {
    margin-right: 6px !important;
    font-size: 14px !important;
}

/* Responsividade para dispositivos móveis */
@media (max-width: 767px) {
    .dt-buttons {
        justify-content: center;
        margin-bottom: 20px;
    }
    
    .dt-button {
        padding: 10px 14px !important;
        font-size: 12px !important;
        min-width: 100px;
    }
    
    .dt-button i {
        margin-right: 4px !important;
        font-size: 12px !important;
    }
}

/* Container dos botões */
.dataTables_wrapper .dt-buttons {
    margin-bottom: 1rem;
    padding: 10px 0;
}

/* Efeito de loading nos botões quando clicados */
.dt-button:active {
    transform: translateY(0) !important;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2) !important;
}

/* Estilo especial para botões desabilitados */
.dt-button:disabled,
.dt-button.disabled {
    opacity: 0.6 !important;
    cursor: not-allowed !important;
    transform: none !important;
    box-shadow: none !important;
}
</style>

<?

$acao = antiSQL($_GET['acao']);		
$idpedido = antiSQL($_GET['id_pedido']);
		
$Inserir = antiSQL($_POST['Inserir']);
$Alterar = antiSQL($_POST['Alterar']);
$Excluir = antiSQL($_GET['Excluir']);

$id_cliente = antiSQL($_POST['id_cliente']);	
$id_produto = antiSQL($_POST['id_produto']);
$data = antiSQL(date("d/m/Y"));
$hora = antiSQL(date("H:i"));		
$status = antiSQL($_POST['status']);			




$checa_pedidos = mysqli_query($conn,"SELECT * FROM pedidos ")->fetch_array(); 

if($checa_pedidos['id_cliente'] == $id_cliente){

    echo 'Já existe pedido cadastrado para este cliente';


}else{

if ($Inserir == "ok") {
mysqli_query($conn,"INSERT INTO pedidos (id_cliente,data,hora) VALUES ('$id_cliente','$data','$hora')");
header( 'Location: pedidos.php?cadastrado_sucesso=sim');
}

}		

if ($Alterar == "ok"){
mysqli_query($conn,"UPDATE pedidos SET id_cliente='$id_cliente',data='$data',hora='$hora' WHERE id=$idpedido");
	
header( 'Location: pedidos.php?alterado_sucesso=sim');
}

if ($Excluir == "ok") {	
    mysqli_query($conn,"DELETE FROM pedidos WHERE id=$idpedido");
    mysqli_query($conn,"ALTER TABLE pedidos AUTO_INCREMENT = 1");	
    header('Location: pedidos.php?deletado_sucesso=sim');
} 




?>

<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

            <? if ($acao == "Alterar") { 
             $sql = mysqli_query($conn,"SELECT * FROM pedidos WHERE id=$idpedido")->fetch_array(); 
             
             } ?>

            <? if ($acao != "") { ?>
            <div class="smart-wrap">
                <div class="smart-forms smart-container wrap-0">
                    <div class="form-header header-blue ">
                        <h4><i class="fa fa-calendar-o"></i> Pedidos  </h4>
                    </div><!-- end .form-header section -->



                    <form name="usuarios" id="usuarios" method="post" action="<?php echo $_SERVER['PHP_SELF']?>"
                        enctype="multipart/form-data">


                        <div class="form-body">


                            <div class="spacer-b30">
                                <div class="tagline"><span style="color: black"> Cliente</span></div><!-- .tagline -->
                            </div>

                            <div class="frm-row">
                                <div class="section colm colm4">
                                </div>
                                <div class="section colm colm4">
                                    <label class="field select prepend-icon">

                                        <select name="id_cliente" class="example-data-array smart-select2 select2-hidden-accessible" style="width:100%"
                                        tabindex="-1" aria-hidden="true">
                                        <option value="">Selecionar Cliente</option>
                                            <?php $sqla = mysqli_query($conn,"SELECT * FROM usuarios ORDER BY id");
while ($coluna = mysqli_fetch_array($sqla)) { ?>

                                            <option value="<?php echo $coluna[id]?>" <?php if
                                                ($sql['id_cliente']==$coluna[id]) echo " selected" ; ?> >
                                                <span style="color: "><?php echo $coluna[nome]?></span>
                                            </option>
                                            <?php } ?>
                                        </select> <span class="field-icon"><i class="fa fa-user"></i></span> <b
                                            class="tooltip tip-right-top"><b>Selecione o <span
                                                    style="color:#6CF;">Cliente</span> Exemplo: <span
                                                    style="color:#6CF;"> Usuario </span></b></b> </label>
                                </div>
                            </div>










                        </div>




                        <div class="form-footer" align="center">
                            <input type="hidden" name="id_pedido" value="<?php echo $idpedido; ?>">
                            <input type="hidden" name="<?php echo $acao; ?>" value="ok">
                            <input type="submit" class="button btn-blue" name="Submit" value="<?php echo $acao; ?>">

                        </div>

                    </form>
                </div>
            </div>



            <div class="row page-titles">

<div class="col-md-7 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='<?php $pagina = basename($_SERVER['PHP_SELF'], ''); echo $pagina; ?>';"><i
                class="fa fa-plus-circle"></i>
            Voltar</button>
    </div>
</div>
</div>


            <?php } else { ?>


                <div style="clear: both;"></div>


<div class="col-sm-12">
    <div class="card">
        <div class="card-header">
            <h5>Tabela:
                <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                    echo ucfirst(strtolower($pagina)); ?>
            </h5>
            <small>Aqui você tem as opções de <b>cadastrar</b>,<b>editar</b>,<b>excluir</b> <span
                    style="color:red;">
                    <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
                        echo ucfirst(strtolower($pagina)); ?><span>.</small>
        </div>
        <div class="card-body">
            <div class="dt-responsive table-responsive">

                <table id="footer-search" class="table table-striped table-bordered nowrap">                                <thead>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;color:green" >Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead><tfoot>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;">Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>                                </tfoot><tbody>                                    <?
                                    // OTIMIZAÇÃO: Uma única query com JOINs para buscar todos os dados necessários
                                    $sqlpedidos = mysqli_query($conn,"
                                        SELECT 
                                            p.id,
                                            p.id_cliente,
                                            p.data,
                                            u.nome as cliente_nome,
                                            u.id_empresa,
                                            e.empresa as empresa_nome,
                                            COALESCE(v.total_vendas, 0) as total_vendas,
                                            COALESCE(f.total_pagamentos, 0) as total_pagamentos
                                        FROM pedidos p
                                        LEFT JOIN usuarios u ON p.id_cliente = u.id
                                        LEFT JOIN empresas e ON u.id_empresa = e.id
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_vendas 
                                            FROM vendas 
                                            GROUP BY id_pedido
                                        ) v ON p.id = v.id_pedido
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_pagamentos 
                                            FROM financeiro_clientes 
                                            GROUP BY id_pedido
                                        ) f ON p.id = f.id_pedido
                                        ORDER BY p.id ASC
                                    ");
                                    
                                    while ($pedidos = mysqli_fetch_array($sqlpedidos)) { 
                                        $total_vendas = floatval($pedidos['total_vendas']);
                                        $total_pagamentos = floatval($pedidos['total_pagamentos']);
                                        $diferenca = $total_vendas - $total_pagamentos;
                                    ?>
                                    <tr>
                                        <td style="width: 5%"> 
                                            <?php echo $pedidos['id']; ?>  
                                        </td>
                                        <td> 
                                            <a href="usuarios.php?acao=Alterar&id_usuario=<?php echo $pedidos['id_cliente'];?>">
                                                <?php echo $pedidos['cliente_nome']; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="empresas.php?acao=Alterar&id_empresas=<?php echo $pedidos['id_empresa'];?>">
                                                <?php echo $pedidos['empresa_nome']; ?>
                                            </a>
                                        </td><td style="width: 12%;" data-vendas="<?php echo $total_vendas; ?>">
                                            <?php echo 'R$ '.number_format($total_vendas, 2, "," , "." ); ?>
                                        </td>
                                        <td style="width: 7%" data-pagamentos="<?php echo $total_pagamentos; ?>">
                                            <?php echo 'R$ '.number_format($total_pagamentos, 2, "," , "." ); ?>
                                            
                                            <!-- Botão de Calculadora de ( + e - ) -->
                                            <i class="fa-solid fa-calculator-simple" data-toggle="tooltip" data-placement="top" title="" data-original-title="
                                                <?php 
                                                if ($total_pagamentos > $total_vendas) {
                                                    echo 'Tem Há Receber: R$ '.number_format(($total_pagamentos - $total_vendas), 2, "," , "." );
                                                } else {
                                                    echo 'Falta Pagar: R$ '.number_format($diferenca, 2, "," , "." );
                                                }
                                                ?>
                                            "></i>
                                        </td><td style="width: 7%">
                                            <?php echo $pedidos['data']; ?>
                                        </td>                                        <td style="width: 40px;"> 
                                            <button type="button" class="btn waves-effect waves-light btn-outline-info" data-toggle="tooltip" data-placement="top" title="" data-original-title="Editar" aria-describedby="tooltip647345">
                                                <a href="?acao=Alterar&id_pedido=<?php echo $pedidos['id'];?>">
                                                    <i class="fa fa-edit" style="font-size:20px; color:#0A94E1"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-warning waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Vendas" aria-describedby="tooltip647345" onclick="abrirModalVendas(<?php echo $pedidos['id'];?>, <?php echo $pedidos['id_cliente'];?>)">
                                                <i class="fa fa-ticket" style="font-size:20px; color:#E1740A"></i>
                                            </button>

                                            <button type="button" class="btn btn-inverse-success waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Financeiro" aria-describedby="tooltip647345" onclick="abrirModalFinanceiro(<?php echo $pedidos['id'];?>, <?php echo $pedidos['id_cliente'];?>)">
                                                <i class="fa fa-solid fa-badge-dollar" style="font-size:20px; color:#32CD32"></i>
                                            </button>

                                            <button type="button" class="btn btn-inverse-danger waves-effect waves-light " data-toggle="tooltip" data-placement="top" title="" data-original-title="Excluir">
                                                <a href="?Excluir=ok&id_pedido=<?php echo $pedidos['id']; ?>" onClick="return pergunta();">
                                                    <i class="fa fa-trash" style="font-size:20px; color:#C80306"></i>
                                                </a>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php } ?>                                </tbody>                            
                            </table>                              <!-- Totais dinâmicos grudados à tabela -->
                            <!-- NÍVEL 1: Totais da Página Atual -->
                            <div id="totais-pagina-atual" style="
                                margin: 0; 
                                padding: 8px 15px; 
                                background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
                                border: 1px solid #90caf9; 
                                border-top: 2px solid #2196f3;
                                border-radius: 0;
                                box-shadow: 0 1px 3px rgba(0,0,0,0.1);
                                position: relative;
                                z-index: 10;
                            ">
                                <div class="row" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 8px; margin: 0;">
                                    <div style="font-weight: 600; color: #1565c0; font-size: 12px; display: flex; align-items: center;">
                                        <span style="margin-right: 6px; font-size: 14px;">📋</span>
                                        <span id="totais-pagina-label">Totais da Página Atual</span>
                                        <span id="info-filtros-aplicados" style="margin-left: 8px; font-size: 11px; color: #666; font-weight: normal;"></span>
                                    </div>
                                    <div class="totais-valores-pagina" style="display: flex; gap: 20px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 4px;">
                                            <span style="color:#1976d2; font-weight: 600; font-size: 11px;">💰</span> 
                                            <span id="total-vendas-pagina" style="font-weight: 700; color: #0d47a1; background: #e1f5fe; padding: 1px 6px; border-radius: 8px; font-size: 11px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 4px;">
                                            <span style="color:#1976d2; font-weight: 600; font-size: 11px;">💳</span> 
                                            <span id="total-pagamentos-pagina" style="font-weight: 700; color: #0d47a1; background: #e0f2f1; padding: 1px 6px; border-radius: 8px; font-size: 11px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 4px;">
                                            <span style="color:#1976d2; font-weight: 600; font-size: 11px;">📈</span> 
                                            <span id="diferenca-total-pagina" style="font-weight: 700; color: #0d47a1; background: #f3e5f5; padding: 1px 6px; border-radius: 8px; font-size: 11px;">R$ 0,00</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- NÍVEL 2: Totais de Todos os Dados Filtrados -->
                            <div id="totais-dinamicos" style="
                                margin: 0; 
                                padding: 12px 15px; 
                                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                                border: 1px solid #dee2e6; 
                                border-top: 2px solid #007bff;
                                border-radius: 0 0 4px 4px;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                                position: relative;
                                z-index: 10;
                            ">
                                <div class="row" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px; margin: 0;">
                                    <div style="font-weight: 600; color: #495057; font-size: 14px; display: flex; align-items: center;">
                                        <span style="margin-right: 8px; font-size: 16px;">📊</span>
                                        <span id="totais-label">Totais de Todos os Dados Filtrados</span>
                                        <span id="contador-registros-filtrados" style="margin-left: 8px; font-size: 12px; color: #666; font-weight: normal;"></span>
                                    </div>
                                    <div class="totais-valores" style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#99a832; font-weight: 600; font-size: 13px;">💰 Vendas:</span> 
                                            <span id="total-vendas-filtrado" style="font-weight: 700; color: #2c5f2d; background: #d4edda; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#5ca832; font-weight: 600; font-size: 13px;">💳 Pagamentos:</span> 
                                            <span id="total-pagamentos-filtrado" style="font-weight: 700; color: #155724; background: #d1ecf1; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#3266a8; font-weight: 600; font-size: 13px;">📈 Saldo:</span> 
                                            <span id="diferenca-total-filtrado" style="font-weight: 700; color: #004085; background: #cce7ff; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                    </div>
                                </div>
                            </div><?
                           // CORREÇÃO: Primeiro calcular todos os totais
                           $sql_totais_completos = mysqli_query($conn,"
                               SELECT 
                                   (SELECT COALESCE(SUM(valor), 0) FROM vendas) as total_vendas_completo,
                                   (SELECT COALESCE(SUM(valor), 0) FROM financeiro_clientes) as total_pagamentos_completo,
                                   (
                                       SELECT COALESCE(SUM(v.total_vendas), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_vendas 
                                           FROM vendas 
                                           GROUP BY id_pedido
                                       ) v ON p.id = v.id_pedido
                                   ) as total_vendas_por_pedidos,
                                   (
                                       SELECT COALESCE(SUM(f.total_pagamentos), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_pagamentos 
                                           FROM financeiro_clientes 
                                           GROUP BY id_pedido
                                       ) f ON p.id = f.id_pedido
                                   ) as total_pagamentos_por_pedidos
                           ");
                             $totais_completos = mysqli_fetch_array($sql_totais_completos);
                           $diferenca_completa = $totais_completos['total_vendas_completo'] - $totais_completos['total_pagamentos_completo'];
                           
                           // Contar total de pedidos para usar no JavaScript
                           $sql_count_total_pedidos = mysqli_query($conn,"SELECT COUNT(*) as total FROM pedidos");
                           $count_total_pedidos = mysqli_fetch_array($sql_count_total_pedidos);
                           $total_pedidos_sistema = $count_total_pedidos['total'];
                           
                           // CORREÇÃO: Calcular registros órfãos baseado na diferença real
                           $vendas_orfas_valor = $totais_completos['total_vendas_completo'] - $totais_completos['total_vendas_por_pedidos'];
                           $pagamentos_orfaos_valor = $totais_completos['total_pagamentos_completo'] - $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // DEBUG: Forçar exibição para diagnóstico
                           $debug_vendas = $totais_completos['total_vendas_completo'];
                           $debug_vendas_pedidos = $totais_completos['total_vendas_por_pedidos']; 
                           $debug_pagamentos = $totais_completos['total_pagamentos_completo'];
                           $debug_pagamentos_pedidos = $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // Contar registros órfãos para exibição
                           $vendas_orfas = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM vendas v 
                               LEFT JOIN pedidos p ON v.id_pedido = p.id 
                               WHERE p.id IS NULL OR v.id_pedido = 0 OR v.id_pedido IS NULL
                           ");
                           $vendas_orfas_result = mysqli_fetch_array($vendas_orfas);
                           
                           $pagamentos_orfaos = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM financeiro_clientes f 
                               LEFT JOIN pedidos p ON f.id_pedido = p.id 
                               WHERE p.id IS NULL OR f.id_pedido = 0 OR f.id_pedido IS NULL
                           ");
                           $pagamentos_orfaos_result = mysqli_fetch_array($pagamentos_orfaos);
                           
                           ?>
                             </div>
                        </div>
                    </div>
                </div>
                  <!-- Totais Gerais do Sistema (fora do card da tabela) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-chart-line mr-2"></i>Totais Gerais do Sistema
                                <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                <span class="badge badge-danger ml-2">⚠️ Registros Órfãos</span>
                                <?php else: ?>
                                <span class="badge badge-success ml-2">✅ Dados Íntegros</span>
                                <?php endif; ?>
                            </h6>
                        </div>
                        <div class="card-body py-3">
                            <div class="row">                                <div class="col-md-8">
                                    <div style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#99a832; font-weight: 600;">💰 Total Vendas:</span>
                                            <span style="font-weight: 700; color: #2c5f2d; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_vendas_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#5ca832; font-weight: 600;">💳 Total Pagamentos:</span>
                                            <span style="font-weight: 700; color: #155724; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_pagamentos_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#3266a8; font-weight: 600;">📈 Saldo Total:</span>
                                            <span style="font-weight: 700; color: #004085; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($diferenca_completa, 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div><div class="col-md-4">
                                    <small style="color: #6c757d; line-height: 1.4;">
                                        <strong>Inclui todos os registros do sistema</strong><br>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <span style="color: #dc3545;">⚠️ Registros Órfãos Detectados:</span><br>
                                        <?php if($vendas_orfas_valor > 0): ?>
                                        • <strong>Vendas:</strong> <?php echo $vendas_orfas_result['total']; ?> registros 
                                        (R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?>)<br>
                                        <?php endif; ?>
                                        <?php if($pagamentos_orfaos_valor > 0): ?>
                                        • <strong>Pagamentos:</strong> <?php echo $pagamentos_orfaos_result['total']; ?> registros 
                                        (R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>)
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <span style="color: #28a745;">✅ Nenhum registro órfão detectado</span><br>
                                        <small style="color: #999;">Todos os registros estão vinculados a pedidos válidos</small>
                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>                            
                            <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #999; font-size: 12px;">
                                    <strong>📋 Totais apenas de Pedidos Válidos (sem órfãos):</strong><br>
                                    <span style="color:#99a832;">💰 Vendas:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#5ca832;">💳 Pagamentos:</span> R$ <?php echo number_format($totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#3266a8;">📈 Saldo:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'] - $totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                </small>
                            </div>
                            <?php else: ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #28a745; font-size: 12px;">
                                    <strong>✅ Todos os registros estão corretamente vinculados a pedidos válidos</strong>
                                </small>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>                
                <!-- Card de Debug/Auditoria (sempre visível para diagnóstico) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'exclamation-triangle' : 'info-circle'; ?> mr-2"></i>
                                <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'Auditoria de Registros Órfãos' : 'Auditoria dos Dados (Debug)'; ?>
                                <button class="btn btn-sm btn-outline-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'dark' : 'light'; ?> float-right" type="button" data-toggle="collapse" data-target="#collapseOrfaos" aria-expanded="false" aria-controls="collapseOrfaos">
                                    <i class="fa fa-chevron-down"></i> Detalhes
                                </button>
                            </h6>
                        </div>
                        <div class="collapse" id="collapseOrfaos">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 style="color: #dc3545;">🔍 Análise dos Dados:</h6>
                                        <ul style="font-size: 13px; margin-bottom: 0;">
                                            <li><strong>Total Vendas Sistema:</strong> R$ <?php echo number_format($debug_vendas, 2, "," , "." ); ?></li>
                                            <li><strong>Vendas em Pedidos:</strong> R$ <?php echo number_format($debug_vendas_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Vendas:</strong> R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?> 
                                                <?php if($vendas_orfas_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $vendas_orfas_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                            <hr style="margin: 10px 0;">
                                            <li><strong>Total Pagamentos Sistema:</strong> R$ <?php echo number_format($debug_pagamentos, 2, "," , "." ); ?></li>
                                            <li><strong>Pagamentos em Pedidos:</strong> R$ <?php echo number_format($debug_pagamentos_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Pagamentos:</strong> R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>
                                                <?php if($pagamentos_orfaos_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $pagamentos_orfaos_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                        </ul>
                                        
                                        <div class="mt-3">
                                            <small style="color: #666; background: #f8f9fa; padding: 8px; border-radius: 4px; display: block;">
                                                <strong>🔧 Debug Info:</strong><br>
                                                Vendas órfãs calculadas: <?php echo $vendas_orfas_valor; ?><br>
                                                Pagamentos órfãos calculados: <?php echo $pagamentos_orfaos_valor; ?><br>
                                                Condição (valor > 0): <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'TRUE' : 'FALSE'; ?>
                                            </small>                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 style="color: #856404;">⚙️ Status e Recomendações:</h6>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <div class="alert alert-warning py-2 mb-2">
                                            <strong>⚠️ Registros Órfãos Detectados</strong>
                                        </div>
                                        
                                        <h6 style="font-size: 12px; color: #dc3545; margin-bottom: 8px;">Possíveis Causas:</h6>
                                        <ul style="font-size: 12px; color: #6c757d; margin-bottom: 12px;">
                                            <?php if($vendas_orfas_valor > 0): ?>
                                            <li>Vendas com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Vendas criadas antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação das vendas</li>
                                            <?php endif; ?>
                                            <?php if($pagamentos_orfaos_valor > 0): ?>
                                            <li>Pagamentos com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Pagamentos criados antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação dos pagamentos</li>
                                            <?php endif; ?>
                                        </ul>
                                          <div style="background: #fff3cd; padding: 8px; border-radius: 4px; border-left: 3px solid #ffc107;">
                                            <small style="color: #856404;">
                                                <strong>💡 Recomendação:</strong> Verificar a integridade dos dados nas tabelas <code>vendas</code> e <code>financeiro_clientes</code>.
                                            </small>
                                        </div>
                                        
                                        <?php else: ?>
                                        <div class="alert alert-success py-2 mb-2">
                                            <strong>✅ Todos os Dados Estão Integros</strong>
                                        </div>
                                        
                                        <ul style="font-size: 12px; color: #28a745; margin-bottom: 12px;">
                                            <li>✓ Todas as vendas estão vinculadas a pedidos válidos</li>
                                            <li>✓ Todos os pagamentos estão vinculados a pedidos válidos</li>
                                            <li>✓ Não há registros órfãos no sistema</li>
                                        </ul>
                                          <div style="background: #d4edda; padding: 8px; border-radius: 4px; border-left: 3px solid #28a745;">
                                            <small style="color: #155724;">
                                                <strong>👍 Sistema OK:</strong> A integridade dos dados está mantida.
                                            </small>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <div class="row page-titles">

<div class="col-md-3 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='?acao=Inserir';"><i class="fa fa-plus-circle"></i> Adicionar
            <?php $pagina = basename($_SERVER['PHP_SELF'], '.php');
echo ucfirst(strtolower($pagina)); ?>
        </button>
    </div>
</div>
</div>


<?php } ?>

<!-- Search API (Regular Expressions) table end -->
</div>
</section>



<?php include 'includes/tema/base.php'; ?>

<!-- DataTables Buttons CSS e JS - Versões Compatíveis -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap4.min.js"></script>

<script>
// Verificação de compatibilidade com DataTables
if (typeof $.fn.DataTable === 'undefined') {
    console.error('❌ DataTables não está carregado!');
}

// Verificação de compatibilidade com DataTables Buttons
if (typeof $.fn.DataTable !== 'undefined' && typeof $.fn.DataTable.Buttons === 'undefined') {
    console.error('❌ DataTables Buttons não está carregado!');
}

// Prevenir conflitos com outros scripts
$(document).ready(function () {
    // Change selectboxes to selectize mode to be searchable
    $("select").select2();
    
    // Variável global para referenciar a tabela
    var table;
    
    // Verificar se a tabela já foi inicializada e destruir se necessário
    if ($.fn.DataTable.isDataTable('#footer-search')) {
        $('#footer-search').DataTable().destroy();
    }
      // Initialize DataTable com configuração melhorada
    table = $('#footer-search').DataTable({
        dom: 'Blfrtip',
        mark: true,        buttons: [
            {
                extend: 'copy',
                text: '<i class="fa fa-copy"></i> Copiar',
                title: 'Pedidos - ' + new Date().toLocaleDateString('pt-BR'),
                className: 'btn btn-primary buttons-copy',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4, 5], // Excluir coluna de ações
                    format: {
                        body: function (data, row, column, node) {
                            // Formatar valores monetários para exportação
                            if (column === 3) { // Coluna de vendas
                                var valor = $(node).attr('data-vendas');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            if (column === 4) { // Coluna de pagamentos
                                var valor = $(node).attr('data-pagamentos');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            // Limpar HTML das outras colunas
                            return $('<div>').html(data).text();
                        }
                    }
                }            },
            {
                extend: 'csv',
                text: '<i class="fa fa-file-csv"></i> CSV',
                title: 'Pedidos_' + new Date().toISOString().split('T')[0],
                className: 'btn btn-success buttons-csv',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4, 5],
                    format: {
                        body: function (data, row, column, node) {
                            if (column === 3) { // Coluna de vendas
                                var valor = $(node).attr('data-vendas');
                                if (valor && valor !== '') {
                                    return parseFloat(valor).toFixed(2);
                                }
                                return '0.00';
                            }
                            if (column === 4) { // Coluna de pagamentos
                                var valor = $(node).attr('data-pagamentos');
                                if (valor && valor !== '') {
                                    return parseFloat(valor).toFixed(2);
                                }
                                return '0.00';
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                }            },
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel"></i> Excel',
                title: 'Pedidos',
                className: 'btn btn-success buttons-excel',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4, 5],
                    format: {
                        body: function (data, row, column, node) {
                            if (column === 3) { // Coluna de vendas
                                var valor = $(node).attr('data-vendas');
                                if (valor && valor !== '') {
                                    return parseFloat(valor);
                                }
                                return 0;
                            }
                            if (column === 4) { // Coluna de pagamentos
                                var valor = $(node).attr('data-pagamentos');
                                if (valor && valor !== '') {
                                    return parseFloat(valor);
                                }
                                return 0;
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                },
                customize: function (xlsx) {
                    // Personalizar planilha Excel
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    
                    // Adicionar formatação monetária nas colunas D e E (vendas e pagamentos)
                    $('row c[r^="D"], row c[r^="E"]', sheet).each(function () {
                        if ($(this).attr('t') != 'inlineStr') {
                            $(this).attr('s', '2'); // Formato monetário
                        }
                    });                }
            },            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf"></i> PDF',
                title: 'Relatório de Pedidos',
                className: 'btn btn-danger buttons-pdf',
                orientation: 'landscape',
                pageSize: 'A4',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4, 5],
                    format: {
                        body: function (data, row, column, node) {
                            if (column === 3) { // Coluna de vendas
                                var valor = $(node).attr('data-vendas');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            if (column === 4) { // Coluna de pagamentos
                                var valor = $(node).attr('data-pagamentos');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                },
                customize: function (doc) {
                    // Personalizar PDF
                    doc.content[1].table.headerRows = 1;
                    doc.content[1].table.widths = ['8%', '30%', '20%', '15%', '15%', '12%'];
                    
                    // Adicionar totais no final do PDF
                    var totaisInfo = [
                        ['', '', '', '', '', ''],
                        ['TOTAIS:', '', '', 
                         $('#total-vendas-filtrado').text(), 
                         $('#total-pagamentos-filtrado').text(), 
                         $('#diferenca-total-filtrado').text()]
                    ];
                    
                    doc.content[1].table.body = doc.content[1].table.body.concat(totaisInfo);
                    
                    // Estilizar linha de totais
                    var rowCount = doc.content[1].table.body.length;
                    doc.content[1].table.body[rowCount-1].forEach(function(cell, index) {
                        if (index === 0) {
                            cell.fillColor = '#f0f0f0';
                            cell.bold = true;
                        } else if (index >= 3) {
                            cell.fillColor = '#e8f4fd';
                            cell.bold = true;
                        }
                    });                }
            },            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Imprimir',
                title: 'Relatório de Pedidos',
                className: 'btn btn-secondary buttons-print',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4, 5],
                    format: {
                        body: function (data, row, column, node) {
                            if (column === 3) { // Coluna de vendas
                                var valor = $(node).attr('data-vendas');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            if (column === 4) { // Coluna de pagamentos
                                var valor = $(node).attr('data-pagamentos');
                                if (valor && valor !== '') {
                                    return 'R$ ' + parseFloat(valor).toLocaleString('pt-BR', {minimumFractionDigits: 2});
                                }
                                return 'R$ 0,00';
                            }
                            return $('<div>').html(data).text();
                        }
                    }
                },
                customize: function (win) {
                    // Adicionar totais na impressão
                    var totaisHtml = '<div style="margin-top: 20px; border-top: 2px solid #000; padding-top: 10px;">' +
                        '<h3>TOTAIS DOS DADOS FILTRADOS:</h3>' +
                        '<p><strong>Total Vendas:</strong> ' + $('#total-vendas-filtrado').text() + '</p>' +
                        '<p><strong>Total Pagamentos:</strong> ' + $('#total-pagamentos-filtrado').text() + '</p>' +
                        '<p><strong>Saldo:</strong> ' + $('#diferenca-total-filtrado').text() + '</p>' +
                        '</div>';
                    
                    $(win.document.body).find('table').after(totaisHtml);
                    
                    // Estilizar impressão
                    $(win.document.body).find('h1').css('text-align', 'center');
                    $(win.document.body).find('table').css('font-size', '12px');
                }
            }
        ],
        "language": {
            "url": "datatable/pt-BR.json"
        },
        "pageLength": 25,
        "responsive": true,
        "processing": true,
        "info": true,        "search": {
            "regex": false,
            "caseInsensitive": true
        },
        "initComplete": function () {
            console.log('🚀 DataTable inicializado');
            // Configurar busca no footer após inicialização completa
            setupFooterSearch();
            // Calcular totais iniciais com delay MUITO maior para evitar múltiplas execuções
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();            }, 2000); // Delay muito maior (2 segundos) para evitar piscar inicial
        },
        "drawCallback": function (settings) {
            // Recalcular totais APENAS quando necessário (reduzir frequência MÁXIMA)
            setTimeout(function() {
                // Só recalcular se realmente houve mudança na paginação
                var info = table.page.info();
                var paginaAtual = info.page;
                var tamanhoPagina = info.length;
                
                // Verificar se houve mudança real na página ou tamanho
                if (window.ultimaPaginaDataTable !== paginaAtual || window.ultimoTamanhoDataTable !== tamanhoPagina) {
                    window.ultimaPaginaDataTable = paginaAtual;
                    window.ultimoTamanhoDataTable = tamanhoPagina;
                    
                    // Só calcular se passou tempo suficiente desde o último cálculo
                    var agora = Date.now();
                    if (agora - ultimoCalculoTotais > 1000) { // Mínimo 1 segundo
                        calcularTotaisFiltrados();
                        console.log('🎯 Draw callback - Página alterada para:', paginaAtual);
                    }
                    ajustarLayoutTotais();
                }
                
                // Reinicializar tooltips nas novas linhas
                $('[data-toggle="tooltip"]').tooltip('dispose').tooltip({
                    delay: { show: 300, hide: 100 }
                });
                
                // Verificar se os inputs ainda existem após redraw
                var $inputs = $('.footer-search-input');
                if ($inputs.length === 0) {
                    console.log('⚠️ DRAW CALLBACK: Inputs perdidos após redraw, recriando...');
                    setTimeout(function() {
                        criarInputsManualmenteCompleto();
                    }, 200);
                }
            }, 300); // Aumentar delay
        },
        "infoCallback": function(settings, start, end, max, total, pre) {
            // Personalizar a mensagem de informação para mostrar registros filtrados
            var filteredCount = settings.fnRecordsDisplay();
            var totalCount = settings.fnRecordsTotal();
            
            // Detectar se há filtros ativos
            var temFiltroAtivo = false;
            
            // Verificar busca global
            try {
                var buscaGlobal = table.search();
                if (buscaGlobal && buscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                }
            } catch (e) {
                // Fallback para input de busca no DOM
                var inputBuscaGlobal = $('.dataTables_filter input').val() || '';
                if (inputBuscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                }
            }
            
            // Verificar filtros por coluna
            try {
                if (table && table.columns) {
                    table.columns().every(function() {
                        if (this.search() && this.search().trim() !== '') {
                            temFiltroAtivo = true;
                        }
                    });
                }
            } catch (e) {
                console.log('⚠️ Erro ao verificar filtros por coluna:', e);
            }
            
            // Verificar inputs do footer
            $('.footer-search-input').each(function() {
                if ($(this).val() && $(this).val().trim() !== '') {
                    temFiltroAtivo = true;
                }
            });
            
            // Verificar diferença entre registros exibidos e totais
            if (filteredCount !== totalCount) {
                temFiltroAtivo = true;
            }
            
            // Gerar mensagem apropriada
            var mensagemFinal = '';
            if (!temFiltroAtivo || filteredCount === totalCount) {
                mensagemFinal = "Mostrando registros de " + start + " a " + end + " de um total de " + total + " registros";
            } else {
                if (filteredCount === 0) {
                    mensagemFinal = "Nenhum registro encontrado (filtrado de " + totalCount + " registros)";
                } else if (filteredCount === 1) {
                    mensagemFinal = "Mostrando 1 registro filtrado de um total de " + totalCount + " registros";
                } else {
                    if (start === 1 && end === filteredCount) {
                        mensagemFinal = "Mostrando " + filteredCount + " registros filtrados de um total de " + totalCount + " registros";
                    } else {
                        mensagemFinal = "Mostrando registros de " + start + " a " + end + " de " + filteredCount + " registros filtrados (total: " + totalCount + " registros)";
                    }
                }
            }
            
            return mensagemFinal;
        }
    });    // Função para ajustar layout dos totais em diferentes tamanhos de tela
    function ajustarLayoutTotais() {
        var $totais = $('#totais-dinamicos');
        var $totaisPagina = $('#totais-pagina-atual');
        var windowWidth = $(window).width();
        
        if (windowWidth < 768) {
            // Mobile: layout vertical
            $totais.find('.row').css({
                'flex-direction': 'column',
                'align-items': 'flex-start'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'column',
                'gap': '10px',
                'margin-top': '10px'
            });
            
            $totaisPagina.find('.row').css({
                'flex-direction': 'column',
                'align-items': 'flex-start'
            });
            $totaisPagina.find('.totais-valores-pagina').css({
                'flex-direction': 'column',
                'gap': '8px',
                'margin-top': '8px'
            });
        } else {
            // Desktop: layout horizontal
            $totais.find('.row').css({
                'flex-direction': 'row',
                'align-items': 'center'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'row',
                'gap': '25px',
                'margin-top': '0'
            });
            
            $totaisPagina.find('.row').css({
                'flex-direction': 'row',
                'align-items': 'center'
            });
            $totaisPagina.find('.totais-valores-pagina').css({
                'flex-direction': 'row',
                'gap': '20px',
                'margin-top': '0'
            });
        }
    }
    
    // Ajustar layout ao redimensionar janela
    $(window).resize(function() {
        setTimeout(ajustarLayoutTotais, 100);
    });
    
    function setupFooterSearch() {
        setTimeout(function() {
            console.log('🔧 SETUP FOOTER SEARCH - Iniciando...');
            
            // Verificar se já existem inputs criados
            var $inputsExistentes = $('.footer-search-input');
            if ($inputsExistentes.length > 0) {
                console.log('✅ Inputs já criados, pulando criação');
                return;
            }
            
            // Tentar método automático primeiro
            var inputsCriados = 0;
            try {
                table.columns().every(function (index) {
                    var column = this;
                    var title = $(column.footer()).text().trim();
                    
                    // Pular coluna de Ações (última coluna)
                    if (index === 6) {
                        $(column.footer()).html('');
                        return;
                    }
                    
                    if (title) {
                        try {
                            // Criar input com wrapper
                            var inputHtml = '<div class="md-input-wrapper"><input type="text" class="md-form-control footer-search-input" placeholder="' + title.replace(/'/g, '&#39;').replace(/"/g, '&quot;') + '" data-column="' + index + '" /></div>';
                            $(column.footer()).html(inputHtml);
                            inputsCriados++;                            // Configurar evento de busca com throttling MÁXIMO
                            var searchTimeout;
                            $('input', column.footer()).on('keyup change clear', function () {
                                var searchValue = this.value;
                                
                                // Limpar timeout anterior
                                clearTimeout(searchTimeout);
                                
                                searchTimeout = setTimeout(function() {
                                    if (column.search() !== searchValue) {
                                        column.search(searchValue, false, false).draw();
                                        
                                        // Recalcular totais após busca com delay MAIOR
                                        clearTimeout(window.timeoutFiltroColuna);
                                        window.timeoutFiltroColuna = setTimeout(function() {
                                            calcularTotaisFiltrados();
                                        }, 1200); // Delay muito maior para evitar piscar
                                    }
                                }, 800); // Delay inicial muito maior
                            });
                            
                            // Prevenir ordenação ao clicar no input
                            $('input', column.footer()).on('click', function(e) {
                                e.stopPropagation();
                            });
                            
                        } catch (error) {
                            console.log('❌ Erro ao criar input para coluna', index, ':', error);
                        }
                    }
                });
            } catch (error) {
                console.log('❌ Erro no método automático:', error);
                inputsCriados = 0;
            }
            
            // Se não conseguiu criar automaticamente, forçar criação manual
            if (inputsCriados === 0) {
                console.log('⚠️ Método automático falhou, forçando criação manual...');
                criarInputsManualmenteCompleto();
            } else {
                console.log('✅ Setup concluído com sucesso! Inputs criados:', inputsCriados);
            }            // Configurar busca global com throttling MÁXIMO
            $('.dataTables_filter input').off('keyup.totais change.totais').on('keyup.totais change.totais', function() {
                clearTimeout(window.timeoutBuscaGlobal);
                window.timeoutBuscaGlobal = setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 1500); // Delay máximo para evitar piscar
            });
            
            // Configurar eventos de paginação específicos (muito menos frequentes)
            $(document).off('click.paginacao').on('click.paginacao', '.dataTables_paginate .paginate_button', function() {
                if (!$(this).hasClass('disabled')) {
                    console.log('🔄 Mudança de página detectada via clique');
                    clearTimeout(window.timeoutPaginacao);
                    window.timeoutPaginacao = setTimeout(function() {
                        calcularTotaisFiltrados();
                    }, 800); // Delay maior
                }
            });
            
            // Configurar evento para mudança de tamanho de página
            $(document).off('change.pageLength').on('change.pageLength', '.dataTables_length select', function() {
                console.log('📏 Mudança de tamanho de página detectada');
                clearTimeout(window.timeoutTamanhoPagina);
                window.timeoutTamanhoPagina = setTimeout(function() {
                    calcularTotaisFiltrados();
                }, 1000); // Delay muito maior
            });
            
            // Inicializar tooltips
            $('[data-toggle="tooltip"]').tooltip({
                delay: { show: 300, hide: 100 }
            });
        }, 300);
    }

    // Função para criar inputs manualmente
    function criarInputsManualmenteCompleto() {
        console.log('🔧 CRIAÇÃO MANUAL COMPLETA - Iniciando...');
        
        // Definir cabeçalhos das colunas
        var colunas = [
            { titulo: 'N°', placeholder: 'N°' },
            { titulo: 'Cliente', placeholder: 'Cliente' },
            { titulo: 'Empresa', placeholder: 'Empresa' },
            { titulo: 'Vendas', placeholder: 'Vendas' },
            { titulo: 'Pagamentos', placeholder: 'Pagamentos' },
            { titulo: 'Data', placeholder: 'Data' },
            { titulo: 'Ações', placeholder: '' }
        ];
        
        // Verificar se footer existe
        var $footer = $('#footer-search tfoot');
        if ($footer.length === 0) {
            console.log('❌ Footer não encontrado, criando...');
            $('#footer-search').append('<tfoot><tr>' + '<th></th>'.repeat(7) + '</tr></tfoot>');
            $footer = $('#footer-search tfoot');
        }
        
        var $footerCells = $footer.find('th');
        
        // Criar inputs para cada coluna (exceto a última - Ações)
        for (var i = 0; i < colunas.length - 1; i++) {
            var coluna = colunas[i];
            var $cell = $footerCells.eq(i);
            
            if ($cell.length > 0) {
                // Criar input com wrapper
                var inputHtml = '<div class="md-input-wrapper">' +
                    '<input type="text" class="md-form-control footer-search-input" ' +
                    'placeholder="' + coluna.placeholder + '" data-column="' + i + '" />' +
                    '</div>';
                
                $cell.html(inputHtml);
                  // Configurar evento de busca com throttling
                var $input = $cell.find('.footer-search-input');
                (function(columnIndex) {                    $input.on('keyup change clear', function() {
                        var searchValue = this.value;
                        
                        // Aplicar filtro na coluna com throttling MÁXIMO
                        clearTimeout(window['timeout_col_' + columnIndex]);
                        window['timeout_col_' + columnIndex] = setTimeout(function() {
                            if (table.column(columnIndex).search() !== searchValue) {
                                table.column(columnIndex).search(searchValue, false, false).draw();
                                
                                // Recalcular totais após busca com delay MAIOR
                                clearTimeout(window.timeoutFiltroManual);
                                window.timeoutFiltroManual = setTimeout(function() {
                                    calcularTotaisFiltrados();
                                }, 1200); // Delay muito maior para evitar piscar
                            }
                        }, 800); // Delay inicial muito maior
                    });
                    
                    // Prevenir ordenação ao clicar no input
                    $input.on('click', function(e) {
                        e.stopPropagation();
                    });
                })(i);
            }
        }
        
        // Limpar última coluna (Ações)
        if ($footerCells.length > 6) {
            $footerCells.eq(6).html('');
        }
        
        console.log('🔧 CRIAÇÃO MANUAL COMPLETA - Concluída!');
    }    // Variáveis globais para controle de throttling AGRESSIVO
    var ultimoCalculoTotais = 0;
    var intervaloMinimoCalculo = 1500; // 1.5 segundos entre cálculos para reduzir piscar
    var timeoutCalculoTotais = null;    // Função OTIMIZADA para atualizar valores sem qualquer animação ou piscar
    function atualizarValorSemAnimacao(seletor, novoValor) {
        var $elemento = $(seletor);
        if ($elemento.length > 0) {
            var valorAtual = $elemento.text().trim();
            var novoValorFormatado = novoValor.toString().trim();
            
            // Só atualizar se o valor realmente mudou
            if (valorAtual !== novoValorFormatado) {
                // Atualizar diretamente sem qualquer efeito
                $elemento.text(novoValorFormatado);
            }
        }
    }

    function formatarValor(valor) {
        if (typeof valor !== 'number' || isNaN(valor)) {
            return 'R$ 0,00';
        }
        return 'R$ ' + valor.toLocaleString('pt-BR', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }    function extrairValorMonetario(texto) {
        if (!texto || typeof texto !== 'string') {
            return 0;
        }
        
        // Limpar o texto de espaços e quebras de linha
        texto = texto.trim();
        
        // Remover R$ e outros caracteres, manter apenas dígitos, pontos e vírgulas
        var numerico = texto.replace(/[^\d.,]/g, '');
        
        if (!numerico || numerico === '') {
            return 0;
        }
        
        // Tratar formato brasileiro (1.234,56) convertendo para formato americano (1234.56)
        if (numerico.includes(',')) {
            // Se tem vírgula, assumir formato brasileiro
            numerico = numerico.replace(/\./g, '').replace(',', '.');
        }
        
        var valor = parseFloat(numerico) || 0;
        console.log('🔢 Extração monetária:', texto, '->', numerico, '->', valor);
        return valor;
    }// Cache de valores para evitar atualizações desnecessárias
    var cacheUltimosValores = {
        vendasFiltrado: null,
        pagamentosFiltrado: null,
        vendasPagina: null,
        pagamentosPagina: null
    };    // Função principal OTIMIZADA para calcular totais
    function calcularTotaisFiltrados() {
        // Implementar throttling para evitar cálculos excessivos
        var agora = Date.now();
        if (agora - ultimoCalculoTotais < intervaloMinimoCalculo) {
            // Se já há um timeout agendado, cancelar
            if (timeoutCalculoTotais) {
                clearTimeout(timeoutCalculoTotais);
            }
            
            // Agendar novo cálculo após o intervalo mínimo
            timeoutCalculoTotais = setTimeout(function() {
                calcularTotaisFiltrados();
            }, intervaloMinimoCalculo - (agora - ultimoCalculoTotais));
            return;
        }
        
        ultimoCalculoTotais = agora;
        console.log('💰 Calculando totais filtrados...');

        var totalVendasFiltrado = 0;
        var totalPagamentosFiltrado = 0;
        var totalVendasPagina = 0;
        var totalPagamentosPagina = 0;
        var linhasProcessadasTotal = 0;
        var linhasProcessadasPagina = 0;
        
        try {
            // === CALCULAR TOTAIS DA PÁGINA ATUAL (SEMPRE) ===
            var $linhasPaginaAtual = $('#footer-search tbody tr:visible');
            console.log('🔍 Linhas encontradas:', $linhasPaginaAtual.length);
            
            $linhasPaginaAtual.each(function() {
                var $row = $(this);
                
                // Pular linhas de totais se existirem
                if ($row.hasClass('totais-linha-tabela')) {
                    console.log('⏭️ Pulando linha de totais');
                    return;
                }
                
                linhasProcessadasPagina++;
                var $tds = $row.find('td');
                console.log('📊 Processando linha', linhasProcessadasPagina, '- TDs encontrados:', $tds.length);
                
                var vendas = 0;
                var pagamentos = 0;
                  if ($tds.length >= 5) {
                    // Debug: Verificar estrutura das células
                    console.log('🔍 Debug célula vendas - HTML:', $tds.eq(3).html());
                    console.log('🔍 Debug célula vendas - Attributes:', $tds.eq(3)[0].attributes);
                    console.log('🔍 Debug célula pagamentos - HTML:', $tds.eq(4).html());
                    console.log('🔍 Debug célula pagamentos - Attributes:', $tds.eq(4)[0].attributes);
                    
                    // Tentar extrair dos data attributes primeiro
                    var vendasAttr = $tds.eq(3).attr('data-vendas');
                    var pagamentosAttr = $tds.eq(4).attr('data-pagamentos');
                    
                    console.log('💰 Linha', linhasProcessadasPagina, '- Vendas attr:', vendasAttr, '- Pagamentos attr:', pagamentosAttr);
                      if (vendasAttr !== undefined && vendasAttr !== null && vendasAttr !== '') {
                        vendas = parseFloat(vendasAttr) || 0;
                        console.log('✅ Vendas extraído do attr:', vendas);
                    } else {
                        // Fallback: extrair do texto
                        var vendasTexto = $tds.eq(3).text();
                        vendas = extrairValorMonetario(vendasTexto);
                        console.log('🔄 Vendas extraído do texto:', vendasTexto, '->', vendas);
                    }
                    
                    if (pagamentosAttr !== undefined && pagamentosAttr !== null && pagamentosAttr !== '') {
                        pagamentos = parseFloat(pagamentosAttr) || 0;
                        console.log('✅ Pagamentos extraído do attr:', pagamentos);
                    } else {
                        // Fallback: extrair do texto
                        var pagamentosTexto = $tds.eq(4).text();
                        pagamentos = extrairValorMonetario(pagamentosTexto);
                        console.log('🔄 Pagamentos extraído do texto:', pagamentosTexto, '->', pagamentos);
                    }
                    
                    // Validação adicional: garantir que os valores são numéricos
                    if (isNaN(vendas) || vendas < 0) {
                        console.log('⚠️ Valor de vendas inválido, usando 0');
                        vendas = 0;
                    }
                    if (isNaN(pagamentos) || pagamentos < 0) {
                        console.log('⚠️ Valor de pagamentos inválido, usando 0');
                        pagamentos = 0;
                    }
                } else {
                    console.log('⚠️ Linha com menos de 5 TDs:', $tds.length);
                }
                
                totalVendasPagina += vendas;
                totalPagamentosPagina += pagamentos;
                console.log('📈 Totais acumulados - Vendas:', totalVendasPagina, 'Pagamentos:', totalPagamentosPagina);
            });

            console.log('🎯 TOTAIS FINAIS DA PÁGINA - Vendas:', totalVendasPagina, 'Pagamentos:', totalPagamentosPagina, 'Linhas:', linhasProcessadasPagina);

            // === CALCULAR TOTAIS FILTRADOS ===
            // Verificar se há filtros ativos
            var temFiltroAtivo = false;
            
            try {
                var buscaGlobal = table.search();
                if (buscaGlobal && buscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                }
            } catch (e) {
                var inputBuscaGlobal = $('.dataTables_filter input').val() || '';
                if (inputBuscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                }
            }
            
            $('.footer-search-input').each(function() {
                if ($(this).val() && $(this).val().trim() !== '') {
                    temFiltroAtivo = true;
                }
            });

            // === LÓGICA CORRIGIDA: TOTAIS FILTRADOS ===
            var info = table.page.info();
            linhasProcessadasTotal = info.recordsDisplay;            if (!temFiltroAtivo) {
                // SEM FILTROS: Usar totais do sistema inteiro (valores PHP)
                // Estes valores vêm do PHP e representam TODOS os registros do sistema
                totalVendasFiltrado = <?php echo $totais_completos['total_vendas_por_pedidos']; ?>;
                totalPagamentosFiltrado = <?php echo $totais_completos['total_pagamentos_por_pedidos']; ?>;
                linhasProcessadasTotal = <?php echo $total_pedidos_sistema; ?>;
                console.log('📊 SEM FILTROS: Usando totais do sistema completo (V: ' + totalVendasFiltrado + ', P: ' + totalPagamentosFiltrado + ')');
            } else if (temFiltroAtivo) {
                // COM FILTROS: Calcular baseado nos dados filtrados
                if (info.recordsDisplay === linhasProcessadasPagina) {
                    // Todos os registros filtrados estão na página atual
                    totalVendasFiltrado = totalVendasPagina;
                    totalPagamentosFiltrado = totalPagamentosPagina;
                } else {
                    // Estimar baseado na proporção dos registros filtrados
                    var proporcao = info.recordsDisplay / linhasProcessadasPagina;
                    totalVendasFiltrado = totalVendasPagina * proporcao;
                    totalPagamentosFiltrado = totalPagamentosPagina * proporcao;                }
                console.log('📊 COM FILTROS: Calculando totais filtrados proporcionalmente (V: ' + totalVendasFiltrado + ', P: ' + totalPagamentosFiltrado + ')');
            }
            
        } catch (error) {
            console.error('❌ Erro ao calcular totais:', error);
        }var diferencaFiltrado = totalVendasFiltrado - totalPagamentosFiltrado;
        var diferencaPagina = totalVendasPagina - totalPagamentosPagina;

        // Verificar se os valores mudaram significativamente antes de atualizar
        var valoresMudaram = (
            cacheUltimosValores.vendasFiltrado !== totalVendasFiltrado ||
            cacheUltimosValores.pagamentosFiltrado !== totalPagamentosFiltrado ||
            cacheUltimosValores.vendasPagina !== totalVendasPagina ||
            cacheUltimosValores.pagamentosPagina !== totalPagamentosPagina
        );

        if (!valoresMudaram) {
            console.log('📊 Valores inalterados, pulando atualização');
            return;
        }

        // Atualizar cache
        cacheUltimosValores.vendasFiltrado = totalVendasFiltrado;
        cacheUltimosValores.pagamentosFiltrado = totalPagamentosFiltrado;
        cacheUltimosValores.vendasPagina = totalVendasPagina;
        cacheUltimosValores.pagamentosPagina = totalPagamentosPagina;

        // Atualizar informações contextuais
        atualizarInfoFiltros(linhasProcessadasTotal, linhasProcessadasPagina);

        // Atualizar interface SEM ANIMAÇÃO
        // Totais filtrados (todos)
        atualizarValorSemAnimacao('#total-vendas-filtrado', formatarValor(totalVendasFiltrado));
        atualizarValorSemAnimacao('#total-pagamentos-filtrado', formatarValor(totalPagamentosFiltrado));
        atualizarValorSemAnimacao('#diferenca-total-filtrado', formatarValor(diferencaFiltrado));
        
        // Totais da página atual
        atualizarValorSemAnimacao('#total-vendas-pagina', formatarValor(totalVendasPagina));
        atualizarValorSemAnimacao('#total-pagamentos-pagina', formatarValor(totalPagamentosPagina));
        atualizarValorSemAnimacao('#diferenca-total-pagina', formatarValor(diferencaPagina));
        
        console.log('📊 Totais atualizados - Página: V=' + totalVendasPagina + ', P=' + totalPagamentosPagina + ' | Filtrados: V=' + totalVendasFiltrado + ', P=' + totalPagamentosFiltrado);
    }// Função auxiliar para atualizar informações contextuais
    function atualizarInfoFiltros(totalFiltrado, totalPagina) {
        try {
            // Obter informações de filtros ativos
            var filtrosAtivos = [];
            
            // Verificar busca global
            var buscaGlobal = $('.dataTables_filter input').val() || '';
            if (buscaGlobal.trim() !== '') {
                filtrosAtivos.push('Busca: "' + buscaGlobal.trim() + '"');
            }
            
            // Verificar filtros por coluna
            $('.footer-search-input').each(function() {
                var valor = $(this).val();
                var coluna = $(this).attr('placeholder') || 'Coluna';
                if (valor && valor.trim() !== '') {
                    filtrosAtivos.push(coluna + ': "' + valor.trim() + '"');
                }
            });
            
            // Atualizar label dos totais filtrados
            var labelFiltrados = '';
            if (filtrosAtivos.length > 0) {
                labelFiltrados = ' (' + filtrosAtivos.join(', ') + ')';
                $('#totais-label').text('Totais Filtrados' + labelFiltrados);
            } else {
                $('#totais-label').text('Totais Gerais');
            }
            $('#contador-registros-filtrados').text('(' + totalFiltrado + ' registros)');
            
            // Atualizar label da página atual
            try {
                var infoDataTable = $('.dataTables_info').text() || '';
                var pageInfo = '';
                
                if (infoDataTable) {
                    // Extrair informação da página atual do DataTables
                    var match = infoDataTable.match(/(\d+)\s+a\s+(\d+)\s+de/);
                    if (match) {
                        var inicio = match[1];
                        var fim = match[2];
                        pageInfo = '(Registros ' + inicio + ' a ' + fim + ')';
                    } else {
                        pageInfo = '(' + totalPagina + ' registros visíveis)';
                    }
                } else {
                    pageInfo = '(' + totalPagina + ' registros visíveis)';
                }
                
                $('#info-filtros-aplicados').text(pageInfo);
                
                // Atualizar título do bloco da página atual
                if (filtrosAtivos.length > 0) {
                    $('#totais-pagina-label').text('Totais da Página Atual');
                } else {
                    $('#totais-pagina-label').text('Totais da Página Atual');
                }
                
            } catch (error) {
                console.error('❌ Erro ao processar info da página:', error);
                $('#info-filtros-aplicados').text('(' + totalPagina + ' registros)');
            }
            
        } catch (error) {
            console.error('❌ Erro ao atualizar info de filtros:', error);
        }
    }    // Garantir que os inputs sejam criados após carregamento completo
    setTimeout(function() {
        var $inputs = $('.footer-search-input');
        if ($inputs.length === 0) {
            console.log('🚨 VERIFICAÇÃO FINAL: Inputs não foram criados, forçando criação...');
            criarInputsManualmenteCompleto();
        }
        
        // FORÇAR CÁLCULO DOS TOTAIS APÓS CARREGAMENTO COMPLETO
        console.log('🚀 FORÇANDO CÁLCULO DOS TOTAIS...');
        calcularTotaisFiltrados();
    }, 2000); // Aumentar para 2 segundos
    
    // Adicionar um evento de clique no documento para recalcular totais
    $(document).on('click', function() {
        setTimeout(function() {
            console.log('👆 Clique detectado, recalculando totais...');
            calcularTotaisFiltrados();
        }, 500);
    });
    
    // Forçar cálculo quando a tabela estiver completamente carregada
    $(window).on('load', function() {
        setTimeout(function() {
            console.log('🌍 Window load - Forçando cálculo final...');
            calcularTotaisFiltrados();
        }, 1000);
    });
});

// Função para confirmar exclusão
function pergunta() {
    return confirm('Tem certeza que deseja excluir este pedido?');
}
</script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

<!-- Modal para Vendas -->
<div class="modal fade" id="modalVendas" tabindex="-1" aria-labelledby="modalVendasLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalVendasLabel">Vendas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="conteudoVendas">
                    <div class="text-center">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para Financeiro -->
<div class="modal fade" id="modalFinanceiro" tabindex="-1" aria-labelledby="modalFinanceiroLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalFinanceiroLabel">Financeiro</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="conteudoFinanceiro">
                    <div class="text-center">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Função para abrir modal de vendas
function abrirModalVendas(idPedido, idCliente) {
    console.log('Abrindo modal de vendas para pedido:', idPedido, 'cliente:', idCliente);
    
    // Mostrar o modal
    var modal = new bootstrap.Modal(document.getElementById('modalVendas'));
    modal.show();
    
    // Carregar conteúdo via AJAX
    $.ajax({
        url: 'vendas_modal.php',
        type: 'GET',
        data: {
            id_pedido: idPedido,
            id_cliente: idCliente
        },
        success: function(response) {
            $('#conteudoVendas').html(response);
        },
        error: function(xhr, status, error) {
            console.error('Erro ao carregar vendas:', error);
            $('#conteudoVendas').html('<div class="alert alert-danger">Erro ao carregar dados de vendas.</div>');
        }
    });
}

// Função para abrir modal de financeiro
function abrirModalFinanceiro(idPedido, idCliente) {
    console.log('Abrindo modal de financeiro para pedido:', idPedido, 'cliente:', idCliente);
    
    // Mostrar o modal
    var modal = new bootstrap.Modal(document.getElementById('modalFinanceiro'));
    modal.show();
    
    // Carregar conteúdo via AJAX
    $.ajax({
        url: 'financeiro_clientes_modal.php',
        type: 'GET',
        data: {
            id_pedido: idPedido,
            id_cliente: idCliente
        },
        success: function(response) {
            $('#conteudoFinanceiro').html(response);
        },
        error: function(xhr, status, error) {
            console.error('Erro ao carregar financeiro:', error);
            $('#conteudoFinanceiro').html('<div class="alert alert-danger">Erro ao carregar dados financeiros.</div>');
        }
    });
}

// Função para recarregar dados após operações nos modais
function recarregarDadosModal(tipo, idPedido, idCliente) {
    if (tipo === 'vendas') {
        $.ajax({
            url: 'vendas_modal.php',
            type: 'GET',
            data: {
                id_pedido: idPedido,
                id_cliente: idCliente
            },
            success: function(response) {
                $('#conteudoVendas').html(response);
                // Recarregar a tabela principal de pedidos
                if (typeof table !== 'undefined' && table.ajax) {
                    table.ajax.reload(null, false);
                }
            }
        });
    } else if (tipo === 'financeiro') {
        $.ajax({
            url: 'financeiro_clientes_modal.php',
            type: 'GET',
            data: {
                id_pedido: idPedido,
                id_cliente: idCliente
            },
            success: function(response) {
                $('#conteudoFinanceiro').html(response);
                // Recarregar a tabela principal de pedidos
                if (typeof table !== 'undefined' && table.ajax) {
                    table.ajax.reload(null, false);
                }
            }
        });
    }
}
</script>