<!DOCTYPE html>
<html>
<head>
    <title>Teste AJAX - Edição Inline</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <h2>Teste da Funcionalidade AJAX</h2>
    
    <div>
        <h3>1. Teste de Atualização de Venda</h3>
        <button onclick="testarAtualizacao()">Testar Atualização</button>
        <div id="resultado1"></div>
    </div>
    
    <div>
        <h3>2. Teste de Busca de Venda</h3>
        <button onclick="testarBusca()">Testar Busca</button>
        <div id="resultado2"></div>
    </div>
    
    <script>
    function testarAtualizacao() {
        $.ajax({
            url: 'vendas_ajax.php',
            type: 'POST',
            data: {
                acao: 'alterar',
                id_vendas: 1, // Assumindo que existe uma venda com ID 1
                produto: 'Produto Teste Atualizado',
                valor: '99.99',
                data: '2024-01-15',
                id_pedido: 1,
                id_cliente: 1
            },
            dataType: 'json',
            success: function(response) {
                $('#resultado1').html('<div style="color: green;">Sucesso: ' + JSON.stringify(response) + '</div>');
                console.log('Resposta:', response);
            },
            error: function(xhr, status, error) {
                $('#resultado1').html('<div style="color: red;">Erro: ' + error + '<br>Status: ' + status + '<br>Response: ' + xhr.responseText + '</div>');
                console.log('Erro:', xhr.responseText);
            }
        });
    }
    
    function testarBusca() {
        $.ajax({
            url: 'vendas_ajax.php',
            type: 'GET',
            data: {
                acao: 'buscar_venda',
                id_vendas: 1
            },
            dataType: 'json',
            success: function(response) {
                $('#resultado2').html('<div style="color: green;">Sucesso: ' + JSON.stringify(response) + '</div>');
                console.log('Resposta:', response);
            },
            error: function(xhr, status, error) {
                $('#resultado2').html('<div style="color: red;">Erro: ' + error + '<br>Status: ' + status + '<br>Response: ' + xhr.responseText + '</div>');
                console.log('Erro:', xhr.responseText);
            }
        });
    }
    </script>
</body>
</html>