<?php
// Teste simples da função buscar_venda
include_once 'dbconfig.php';

// Simular requisição GET
$_GET['acao'] = 'buscar_venda';
$_GET['id_vendas'] = '1';
$_GET['id_pedido'] = '1';
$_GET['id_cliente'] = '1';

echo "<h2>Teste da Função buscar_venda</h2>";
echo "<p>Parâmetros GET:</p>";
echo "<pre>" . print_r($_GET, true) . "</pre>";

// Verificar se existe venda com ID 1
$sql = "SELECT * FROM vendas WHERE id = 1";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $venda = $result->fetch_assoc();
    echo "<h3>Venda encontrada:</h3>";
    echo "<pre>" . print_r($venda, true) . "</pre>";
    
    // Simular resposta JSON
    $valor_formatado = number_format($venda['valor'], 2, ',', '.');
    $response = [
        'success' => true,
        'data' => [
            'produto' => $venda['produto'],
            'valor_formatado' => $valor_formatado,
            'data_venda' => $venda['data2']
        ]
    ];
    
    echo "<h3>Resposta JSON esperada:</h3>";
    echo "<pre>" . json_encode($response, JSON_PRETTY_PRINT) . "</pre>";
} else {
    echo "<p style='color: red;'>Nenhuma venda encontrada com ID 1</p>";
    
    // Listar todas as vendas disponíveis
    echo "<h3>Vendas disponíveis:</h3>";
    $sql = "SELECT id, produto, valor FROM vendas LIMIT 5";
    $result = $conn->query($sql);
    
    if ($result && $result->num_rows > 0) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Produto</th><th>Valor</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr><td>" . $row['id'] . "</td><td>" . $row['produto'] . "</td><td>" . $row['valor'] . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p>Nenhuma venda encontrada na tabela.</p>";
    }
}

echo "<h3>Teste direto da URL AJAX:</h3>";
echo "<p><a href='vendas_modal.php?acao=buscar_venda&id_vendas=1&id_pedido=1&id_cliente=1' target='_blank'>Testar URL AJAX</a></p>";

$conn->close();
?>