<?php
// Teste simples para verificar comunicação AJAX
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

// Verificar se a conexão foi estabelecida
if (!$conn) {
    echo json_encode(['success' => false, 'message' => 'Erro de conexão com banco de dados: ' . mysqli_connect_error()]);
    exit;
}

// Log de debug usando error_log (mais confiável)
error_log('AJAX DEBUG - Método: ' . $_SERVER['REQUEST_METHOD']);
error_log('AJAX DEBUG - GET: ' . print_r($_GET, true));
error_log('AJAX DEBUG - POST: ' . print_r($_POST, true));
error_log('AJAX DEBUG - RAW INPUT: ' . file_get_contents('php://input'));

// Tentar também salvar em arquivo local
@file_put_contents('test_log.txt', date('Y-m-d H:i:s') . ' - Método: ' . $_SERVER['REQUEST_METHOD'] . "\n", FILE_APPEND);
@file_put_contents('test_log.txt', date('Y-m-d H:i:s') . ' - POST: ' . print_r($_POST, true) . "\n", FILE_APPEND);

// Sempre retornar JSON válido
header('Content-Type: application/json');

// Usar dados POST ou GET
$dados = $_SERVER['REQUEST_METHOD'] === 'POST' ? $_POST : $_GET;

// Log dos dados recebidos
error_log('AJAX DEBUG - Dados recebidos (' . $_SERVER['REQUEST_METHOD'] . '): ' . print_r($dados, true));
@file_put_contents('test_log.txt', date('Y-m-d H:i:s') . ' - Dados: ' . print_r($dados, true) . "\n", FILE_APPEND);

$acao = isset($dados['acao']) ? $dados['acao'] : '';
$id_pedido = isset($dados['id_pedido']) ? (int)$dados['id_pedido'] : 0;
$id_vendas = isset($dados['id_vendas']) ? (int)$dados['id_vendas'] : 0;

// Log da ação recebida
error_log('AJAX DEBUG - Ação recebida: "' . $acao . '"');
@file_put_contents('test_log.txt', date('Y-m-d H:i:s') . ' - Ação: "' . $acao . '"' . "\n", FILE_APPEND);

// Processar a ação recebida

// Resposta padrão para qualquer ação
$resposta = [
    'success' => true,
    'message' => 'Comunicação funcionando! Ação: "' . $acao . '"',
    'dados_recebidos' => $dados,
    'metodo' => $_SERVER['REQUEST_METHOD'],
    'acao_vazia' => empty($acao),
    'timestamp' => date('Y-m-d H:i:s')
];

// Teste simples de resposta
if ($acao === 'teste') {
    $resposta['message'] = 'Teste de comunicação AJAX bem-sucedido!';
    echo json_encode($resposta);
    exit;
}
    
// Teste de consulta no banco
if ($acao === 'teste_banco') {
    $sql = "SELECT COUNT(*) as total FROM vendas";
    $result = mysqli_query($conn, $sql);
    
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $resposta['message'] = 'Banco de dados funcionando!';
        $resposta['total_vendas'] = $row['total'];
    } else {
        $resposta['success'] = false;
        $resposta['message'] = 'Erro na consulta: ' . mysqli_error($conn);
    }
    echo json_encode($resposta);
    exit;
}
    
// Teste de atualização
if ($acao === 'alterar' && $id_vendas > 0) {
    $produto = isset($dados['produto']) ? $dados['produto'] : '';
    $valor = isset($dados['valor']) ? str_replace(',', '.', $dados['valor']) : 0;
    $data = isset($dados['data']) ? $dados['data'] : date('Y-m-d');
    
    error_log('AJAX DEBUG - Dados para atualização: produto=' . $produto . ', valor=' . $valor . ', data=' . $data . ', id=' . $id_vendas);
    @file_put_contents('test_log.txt', date('Y-m-d H:i:s') . ' - Dados para atualização: produto=' . $produto . ', valor=' . $valor . ', data=' . $data . ', id=' . $id_vendas . "\n", FILE_APPEND);
    
    if (!empty($produto) && $valor > 0) {
        $sql = "UPDATE vendas SET produto = ?, valor = ?, data2 = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        
        if ($stmt) {
            $stmt->bind_param("sdsi", $produto, $valor, $data, $id_vendas);
            
            if ($stmt->execute()) {
                $resposta['message'] = 'Venda atualizada com sucesso!';
            } else {
                error_log('AJAX DEBUG - Erro na execução: ' . $stmt->error);
                $resposta['success'] = false;
                $resposta['message'] = 'Erro ao atualizar venda: ' . $stmt->error;
            }
        } else {
            error_log('AJAX DEBUG - Erro na preparação: ' . $conn->error);
            $resposta['success'] = false;
            $resposta['message'] = 'Erro ao preparar consulta: ' . $conn->error;
        }
    } else {
        $resposta['success'] = false;
        $resposta['message'] = 'Produto e valor são obrigatórios.';
    }
    echo json_encode($resposta);
    exit;
}

// Se chegou aqui, nenhuma ação válida foi encontrada
$resposta['success'] = false;
$resposta['message'] = 'Ação não reconhecida: ' . $acao;
echo json_encode($resposta);
exit;
?>