<?php
include 'dbconfig.php';

// Teste de inserção e atualização com centavos
echo "<h2>Teste de Centavos - Modal Financeiro</h2>";

// Simular inserção com centavos
echo "<h3>1. Teste de Inserção com Centavos</h3>";
$valor_teste = "71,50";
$valor_convertido = (float)str_replace(',', '.', $valor_teste);
echo "Valor original: $valor_teste<br>";
echo "Valor convertido: $valor_convertido<br>";
echo "Tipo: " . gettype($valor_convertido) . "<br><br>";

// Simular atualização com centavos
echo "<h3>2. Teste de Atualização com Centavos</h3>";
$valor_teste2 = "85,75";
$valor_convertido2 = (float)str_replace(',', '.', $valor_teste2);
echo "Valor original: $valor_teste2<br>";
echo "Valor convertido: $valor_convertido2<br>";
echo "Tipo: " . gettype($valor_convertido2) . "<br><br>";

// Verificar estrutura da tabela
echo "<h3>3. Estrutura da Tabela financeiro_clientes</h3>";
$sql = "DESCRIBE financeiro_clientes";
$result = mysqli_query($conn, $sql);

if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table><br>";
} else {
    echo "Erro ao verificar estrutura: " . mysqli_error($conn) . "<br><br>";
}

// Teste de inserção real (se houver pedido válido)
echo "<h3>4. Teste de Inserção Real</h3>";
$sql_pedido = "SELECT id FROM pedidos LIMIT 1";
$result_pedido = mysqli_query($conn, $sql_pedido);

if ($result_pedido && mysqli_num_rows($result_pedido) > 0) {
    $pedido = mysqli_fetch_assoc($result_pedido);
    $id_pedido_teste = $pedido['id'];
    
    // Inserir valor com centavos
    $valor_teste_real = 123.45;
    $sql_insert = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql_insert);
    
    if ($stmt) {
        $id_cliente_teste = 1; // Cliente padrão
        $data_teste = date('Y-m-d');
        
        $stmt->bind_param("iids", $id_pedido_teste, $id_cliente_teste, $valor_teste_real, $data_teste);
        
        if ($stmt->execute()) {
            $id_inserido = $conn->insert_id;
            echo "✅ Inserção bem-sucedida!<br>";
            echo "ID inserido: $id_inserido<br>";
            echo "Valor inserido: $valor_teste_real<br><br>";
            
            // Verificar o valor salvo no banco
            $sql_verificar = "SELECT valor FROM financeiro_clientes WHERE id = ?";
            $stmt_verificar = $conn->prepare($sql_verificar);
            $stmt_verificar->bind_param("i", $id_inserido);
            $stmt_verificar->execute();
            $result_verificar = $stmt_verificar->get_result();
            $row_verificar = $result_verificar->fetch_assoc();
            
            echo "Valor recuperado do banco: " . $row_verificar['valor'] . "<br>";
            echo "Formatado: R$ " . number_format($row_verificar['valor'], 2, ',', '.') . "<br><br>";
            
            // Teste de atualização
            echo "<h3>5. Teste de Atualização</h3>";
            $novo_valor = 456.78;
            $sql_update = "UPDATE financeiro_clientes SET valor = ? WHERE id = ?";
            $stmt_update = $conn->prepare($sql_update);
            $stmt_update->bind_param("di", $novo_valor, $id_inserido);
            
            if ($stmt_update->execute()) {
                echo "✅ Atualização bem-sucedida!<br>";
                echo "Novo valor: $novo_valor<br><br>";
                
                // Verificar o novo valor
                $stmt_verificar->execute();
                $result_verificar2 = $stmt_verificar->get_result();
                $row_verificar2 = $result_verificar2->fetch_assoc();
                
                echo "Novo valor recuperado: " . $row_verificar2['valor'] . "<br>";
                echo "Formatado: R$ " . number_format($row_verificar2['valor'], 2, ',', '.') . "<br><br>";
            } else {
                echo "❌ Erro na atualização: " . $stmt_update->error . "<br><br>";
            }
            
            // Limpar teste
            $sql_delete = "DELETE FROM financeiro_clientes WHERE id = ?";
            $stmt_delete = $conn->prepare($sql_delete);
            $stmt_delete->bind_param("i", $id_inserido);
            $stmt_delete->execute();
            echo "🗑️ Registro de teste removido.<br>";
            
        } else {
            echo "❌ Erro na inserção: " . $stmt->error . "<br><br>";
        }
    } else {
        echo "❌ Erro ao preparar consulta: " . $conn->error . "<br><br>";
    }
} else {
    echo "❌ Nenhum pedido encontrado para teste.<br><br>";
}

echo "<h3>6. Teste de Formatação JavaScript</h3>";
echo "<script>";
echo "console.log('Teste de formatação:');";
echo "var valor1 = '71,50';";
echo "var valorParaBanco1 = valor1.replace(/\\./g, '').replace(',', '.');";
echo "console.log('Valor original:', valor1);";
echo "console.log('Valor para banco:', valorParaBanco1);";
echo "console.log('Valor numérico:', parseFloat(valorParaBanco1));";
echo "</script>";

echo "<p><a href='teste_modal_financeiro_corrigido_simples.php'>🔗 Testar Modal Financeiro</a></p>";
?>