<?php
include 'includes/tema/topo.php';

// Teste simples do endpoint
if (isset($_POST['acao']) && $_POST['acao'] == 'alterar_nome_cliente') {
    header('Content-Type: application/json');
    
    $id_cliente = (int)antiSQL($_POST['id_cliente']);
    $novo_nome = trim(antiSQL($_POST['novo_nome']));
    
    echo json_encode([
        'success' => true, 
        'message' => 'Teste bem-sucedido',
        'id_cliente' => $id_cliente,
        'novo_nome' => $novo_nome,
        'debug' => [
            'post_data' => $_POST,
            'endpoint' => 'teste_cliente_ajax.php'
        ]
    ]);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <h2>Teste do Endpoint de Alteração do Cliente</h2>
    
    <div>
        <label>ID Cliente: <input type="number" id="id_cliente" value="1"></label><br><br>
        <label>Novo Nome: <input type="text" id="novo_nome" value="Cliente Teste"></label><br><br>
        <button onclick="testarEndpoint()">Testar Endpoint</button>
    </div>
    
    <div id="resultado" style="margin-top: 20px; padding: 10px; border: 1px solid #ccc;"></div>

    <script>
    function testarEndpoint() {
        var idCliente = $('#id_cliente').val();
        var novoNome = $('#novo_nome').val();
        
        console.log('🧪 TESTE - Enviando dados:', {
            acao: 'alterar_nome_cliente',
            id_cliente: idCliente,
            novo_nome: novoNome
        });
        
        $.ajax({
            url: window.location.pathname,
            type: 'POST',
            data: {
                acao: 'alterar_nome_cliente',
                id_cliente: idCliente,
                novo_nome: novoNome
            },
            dataType: 'json',
            success: function(response) {
                console.log('✅ TESTE - Sucesso:', response);
                $('#resultado').html('<h3>Sucesso!</h3><pre>' + JSON.stringify(response, null, 2) + '</pre>');
            },
            error: function(xhr, status, error) {
                console.error('❌ TESTE - Erro:', xhr.responseText);
                $('#resultado').html('<h3>Erro!</h3><p>Status: ' + status + '</p><p>Error: ' + error + '</p><p>Response: ' + xhr.responseText + '</p>');
            }
        });
    }
    </script>
</body>
</html>
