<?php
include_once 'dbconfig.php';

echo "<h2>Teste de Contagem de Vendas</h2>";

// Buscar todos os pedidos que têm vendas
$sql_pedidos = "SELECT DISTINCT id_pedido, COUNT(*) as total_vendas FROM vendas GROUP BY id_pedido ORDER BY total_vendas DESC LIMIT 10";
$result_pedidos = $conn->query($sql_pedidos);

echo "<h3>Pedidos com mais vendas:</h3>";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>ID Pedido</th><th>Total de Vendas</th><th>Testar Modal</th></tr>";

while ($pedido = $result_pedidos->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $pedido['id_pedido'] . "</td>";
    echo "<td>" . $pedido['total_vendas'] . "</td>";
    echo "<td><a href='pedidos.php' target='_blank'>Testar no sistema</a></td>";
    echo "</tr>";
}

echo "</table>";

// Buscar detalhes de um pedido específico (o que tem mais vendas)
$sql_primeiro = "SELECT id_pedido FROM vendas GROUP BY id_pedido ORDER BY COUNT(*) DESC LIMIT 1";
$result_primeiro = $conn->query($sql_primeiro);

if ($row = $result_primeiro->fetch_assoc()) {
    $id_pedido_teste = $row['id_pedido'];
    
    echo "<h3>Detalhes do pedido $id_pedido_teste (com mais vendas):</h3>";
    
    $sql_detalhes = "SELECT id, produto, valor, data2, data, hora FROM vendas WHERE id_pedido = ? ORDER BY data2 DESC, id DESC";
    $stmt = $conn->prepare($sql_detalhes);
    $stmt->bind_param("i", $id_pedido_teste);
    $stmt->execute();
    $result_detalhes = $stmt->get_result();
    
    echo "<p><strong>Total de registros encontrados:</strong> " . $result_detalhes->num_rows . "</p>";
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%; font-size: 12px;'>";
    echo "<tr><th>ID</th><th>Produto</th><th>Valor</th><th>Data2</th><th>Data</th><th>Hora</th></tr>";
    
    $contador = 0;
    while ($venda = $result_detalhes->fetch_assoc()) {
        $contador++;
        echo "<tr>";
        echo "<td>" . $venda['id'] . "</td>";
        echo "<td>" . htmlspecialchars($venda['produto']) . "</td>";
        echo "<td>R$ " . number_format($venda['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . $venda['data2'] . "</td>";
        echo "<td>" . $venda['data'] . "</td>";
        echo "<td>" . $venda['hora'] . "</td>";
        echo "</tr>";
        
        // Limitar exibição para não sobrecarregar a página
        if ($contador >= 50) {
            echo "<tr><td colspan='6'><em>... mostrando apenas os primeiros 50 registros ...</em></td></tr>";
            break;
        }
    }
    
    echo "</table>";
    
    echo "<p><strong>Registros exibidos:</strong> " . min($contador, 50) . " de " . $result_detalhes->num_rows . " total</p>";
}

?>

<script>
console.log('Página de teste de vendas carregada');
</script>
