<?php
// Teste isolado para criação de empresa
require_once 'dbconfig.php';

echo "<h2>Teste de Criação de Empresa</h2>";

// Verificar conexão com banco
if ($conn->ping()) {
    echo "<p style='color: green;'>✅ Conexão com banco OK</p>";
} else {
    echo "<p style='color: red;'>❌ Erro na conexão com banco</p>";
    exit;
}

// Verificar se tabelas existem
$tables_check = ['empresas', 'usuarios'];
foreach ($tables_check as $table) {
    $result = $conn->query("SHOW TABLES LIKE '$table'");
    if ($result->num_rows > 0) {
        echo "<p style='color: green;'>✅ Tabela '$table' existe</p>";
    } else {
        echo "<p style='color: red;'>❌ Tabela '$table' não encontrada</p>";
    }
}

// Verificar estrutura da tabela empresas
echo "<h3>Estrutura da tabela empresas:</h3>";
$result = $conn->query("DESCRIBE empresas");
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Chave</th><th>Padrão</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Default']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Verificar um cliente existente
echo "<h3>Clientes disponíveis (primeiros 5):</h3>";
$result = $conn->query("SELECT id, nome FROM usuarios LIMIT 5");
if ($result && $result->num_rows > 0) {
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Nome</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['id']) . "</td>";
        echo "<td>" . htmlspecialchars($row['nome']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>❌ Nenhum cliente encontrado</p>";
}

// Testar criação de empresa via POST
if ($_POST) {
    echo "<h3>Resultado do teste de criação:</h3>";
    
    $nome_empresa = $_POST['nome_empresa'] ?? '';
    $id_cliente = (int)($_POST['id_cliente'] ?? 0);
    
    echo "<p>Nome empresa: " . htmlspecialchars($nome_empresa) . "</p>";
    echo "<p>ID cliente: " . $id_cliente . "</p>";
    
    // Simular o que o criar_empresa.php faz
    if (empty($nome_empresa)) {
        echo "<p style='color: red;'>❌ Nome da empresa vazio</p>";
    } elseif ($id_cliente <= 0) {
        echo "<p style='color: red;'>❌ ID do cliente inválido</p>";
    } else {
        // Verificar se cliente existe
        $stmt = $conn->prepare("SELECT nome FROM usuarios WHERE id = ?");
        $stmt->bind_param("i", $id_cliente);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            echo "<p style='color: red;'>❌ Cliente não encontrado</p>";
        } else {
            $cliente = $result->fetch_assoc();
            echo "<p style='color: blue;'>Cliente encontrado: " . htmlspecialchars($cliente['nome']) . "</p>";
            
            // Verificar se empresa já existe
            $stmt = $conn->prepare("SELECT id, empresa FROM empresas WHERE empresa = ?");
            $stmt->bind_param("s", $nome_empresa);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                echo "<p style='color: orange;'>⚠️ Empresa já existe</p>";
                $empresa = $result->fetch_assoc();
                echo "<p>ID da empresa existente: " . $empresa['id'] . "</p>";
            } else {
                // Tentar criar empresa
                try {
                    $stmt = $conn->prepare("INSERT INTO empresas (empresa, ativo, data_criacao) VALUES (?, 1, NOW())");
                    $stmt->bind_param("s", $nome_empresa);
                    
                    if ($stmt->execute()) {
                        $nova_empresa_id = $conn->insert_id;
                        echo "<p style='color: green;'>✅ Empresa criada com ID: $nova_empresa_id</p>";
                        
                        // Tentar associar ao cliente
                        $stmt = $conn->prepare("UPDATE usuarios SET id_empresa = ? WHERE id = ?");
                        $stmt->bind_param("ii", $nova_empresa_id, $id_cliente);
                        
                        if ($stmt->execute()) {
                            echo "<p style='color: green;'>✅ Empresa associada ao cliente com sucesso!</p>";
                        } else {
                            echo "<p style='color: red;'>❌ Erro ao associar empresa ao cliente: " . $stmt->error . "</p>";
                        }
                    } else {
                        echo "<p style='color: red;'>❌ Erro ao criar empresa: " . $stmt->error . "</p>";
                    }
                } catch (Exception $e) {
                    echo "<p style='color: red;'>❌ Exceção: " . $e->getMessage() . "</p>";
                }
            }
        }
    }
}
?>

<h3>Formulário de Teste</h3>
<form method="POST">
    <p>
        <label>Nome da Empresa:</label><br>
        <input type="text" name="nome_empresa" value="Empresa Teste <?= date('Y-m-d H:i:s') ?>" style="width: 300px;">
    </p>
    <p>
        <label>ID do Cliente:</label><br>
        <input type="number" name="id_cliente" value="1" min="1">
    </p>
    <p>
        <button type="submit">Testar Criação de Empresa</button>
    </p>
</form>

<h3>Teste via AJAX</h3>
<button onclick="testarAjax()">Testar AJAX</button>
<div id="resultado-ajax"></div>

<script>
function testarAjax() {
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'criar_empresa.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            var resultado = document.getElementById('resultado-ajax');
            resultado.innerHTML = '<h4>Resultado AJAX:</h4>';
            resultado.innerHTML += '<p><strong>Status:</strong> ' + xhr.status + '</p>';
            resultado.innerHTML += '<p><strong>Response:</strong></p>';
            resultado.innerHTML += '<pre>' + xhr.responseText + '</pre>';
            
            try {
                var json = JSON.parse(xhr.responseText);
                resultado.innerHTML += '<h4>JSON Parseado:</h4>';
                resultado.innerHTML += '<pre>' + JSON.stringify(json, null, 2) + '</pre>';
            } catch (e) {
                resultado.innerHTML += '<p style="color: red;">Erro ao parsear JSON: ' + e.message + '</p>';
            }
        }
    };
    
    var data = 'nome_empresa=Empresa AJAX Teste ' + new Date().getTime() + '&id_cliente=1';
    xhr.send(data);
}
</script>
