<?php
// Teste de debug para verificar o problema do UPDATE
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

// Verificar estrutura da tabela
echo "<h3>Estrutura da tabela financeiro_clientes:</h3>";
$sql = "DESCRIBE financeiro_clientes";
$result = $conn->query($sql);
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Chave</th><th>Padrão</th><th>Extra</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Listar todos os registros
echo "<h3>Registros existentes:</h3>";
$sql = "SELECT * FROM financeiro_clientes ORDER BY id DESC LIMIT 10";
$result = $conn->query($sql);
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>ID Pedido</th><th>ID Cliente</th><th>Valor</th><th>Data2</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['id_pedido'] . "</td>";
        echo "<td>" . $row['id_cliente'] . "</td>";
        echo "<td>" . $row['valor'] . "</td>";
        echo "<td>" . $row['data2'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Teste de UPDATE se houver registros
$sql = "SELECT id FROM financeiro_clientes LIMIT 1";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $test_id = $row['id'];
    
    echo "<h3>Testando UPDATE no ID: $test_id</h3>";
    
    // Teste 1: UPDATE simples
    $sql = "UPDATE financeiro_clientes SET valor = 99.99 WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $test_id);
        if ($stmt->execute()) {
            echo "<p>✓ UPDATE executado com sucesso. Linhas afetadas: " . $stmt->affected_rows . "</p>";
        } else {
            echo "<p>✗ Erro no UPDATE: " . $stmt->error . "</p>";
        }
    } else {
        echo "<p>✗ Erro ao preparar UPDATE: " . $conn->error . "</p>";
    }
    
    // Teste 2: UPDATE com data
    $sql = "UPDATE financeiro_clientes SET valor = ?, data2 = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $valor = 88.88;
        $data = '2024-01-15';
        $stmt->bind_param("dsi", $valor, $data, $test_id);
        if ($stmt->execute()) {
            echo "<p>✓ UPDATE com data executado com sucesso. Linhas afetadas: " . $stmt->affected_rows . "</p>";
        } else {
            echo "<p>✗ Erro no UPDATE com data: " . $stmt->error . "</p>";
        }
    } else {
        echo "<p>✗ Erro ao preparar UPDATE com data: " . $conn->error . "</p>";
    }
    
    // Verificar o registro após UPDATE
    echo "<h3>Registro após UPDATE:</h3>";
    $sql = "SELECT * FROM financeiro_clientes WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $test_id);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            if ($row) {
                echo "<p>ID: " . $row['id'] . ", Valor: " . $row['valor'] . ", Data: " . $row['data2'] . "</p>";
            } else {
                echo "<p>Registro não encontrado!</p>";
            }
        }
    }
} else {
    echo "<p>Nenhum registro encontrado para teste.</p>";
}
?>

<h3>Teste Manual</h3>
<form method="post">
    <p>ID para testar: <input type="number" name="test_id" value="1"></p>
    <p>Novo valor: <input type="number" step="0.01" name="test_valor" value="123.45"></p>
    <p>Nova data: <input type="date" name="test_data" value="2024-01-20"></p>
    <p><input type="submit" name="test_update" value="Testar UPDATE"></p>
</form>

<?php
if (isset($_POST['test_update'])) {
    $test_id = (int)$_POST['test_id'];
    $test_valor = (float)$_POST['test_valor'];
    $test_data = $_POST['test_data'];
    
    echo "<h4>Resultado do teste manual:</h4>";
    echo "<p>Testando ID: $test_id, Valor: $test_valor, Data: $test_data</p>";
    
    // Verificar se existe
    $sql = "SELECT id FROM financeiro_clientes WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $test_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            echo "<p>✓ Registro encontrado</p>";
            
            // Fazer UPDATE
            $sql = "UPDATE financeiro_clientes SET valor = ?, data2 = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("dsi", $test_valor, $test_data, $test_id);
                if ($stmt->execute()) {
                    echo "<p>✓ UPDATE executado. Linhas afetadas: " . $stmt->affected_rows . "</p>";
                } else {
                    echo "<p>✗ Erro no UPDATE: " . $stmt->error . "</p>";
                }
            }
        } else {
            echo "<p>✗ Registro com ID $test_id não encontrado</p>";
        }
    }
}
?>