<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Teste de Debug - Modal de Vendas</h2>";

// Verificar se a requisição POST está chegando
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_log("=== TESTE_DEBUG_VENDAS.PHP - REQUISIÇÃO POST RECEBIDA ===");
    error_log("POST DATA: " . print_r($_POST, true));
    error_log("PHP_SELF: " . $_SERVER['PHP_SELF']);
    error_log("SCRIPT_NAME: " . $_SERVER['SCRIPT_NAME']);
    error_log("REQUEST_URI: " . $_SERVER['REQUEST_URI']);
    error_log("HTTP_REFERER: " . (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'N/A'));
    
    echo "<div style='background: #f8f9fa; border: 1px solid #dee2e6; padding: 15px; margin: 10px 0;'>";
    echo "<h3>POST recebido neste arquivo de teste!</h3>";
    echo "<p><strong>Dados POST:</strong></p>";
    echo "<pre>" . print_r($_POST, true) . "</pre>";
    echo "<p><strong>Arquivo atual:</strong> " . __FILE__ . "</p>";
    echo "<p><strong>Script executado:</strong> " . $_SERVER['SCRIPT_NAME'] . "</p>";
    echo "</div>";
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Teste Modal Vendas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4>Teste de Captura - Formulário de Vendas</h4>
            </div>
            <div class="card-body">
                <p>Este formulário simula o que deveria acontecer quando você adiciona uma venda:</p>
                
                <form method="POST" action="teste_debug_vendas.php">
                    <div class="mb-3">
                        <label class="form-label">Produto:</label>
                        <input type="text" name="produto" class="form-control" value="Teste Produto" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Valor:</label>
                        <input type="text" name="valor" class="form-control" value="100.50" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Data:</label>
                        <input type="date" name="data" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    <input type="hidden" name="acao" value="inserir">
                    <input type="hidden" name="id_pedido" value="1">
                    <input type="hidden" name="id_cliente" value="1">
                    
                    <button type="submit" class="btn btn-primary">Testar POST direto</button>
                </form>
                
                <hr>
                
                <h5>Teste AJAX (como deveria funcionar no modal):</h5>
                <button id="testarAjax" class="btn btn-success">Testar AJAX para vendas_modal.php</button>
                <button id="testarAjaxErrado" class="btn btn-danger">Testar AJAX para financeiro_clientes_modal.php</button>
                
                <div id="resultado" class="mt-3"></div>
            </div>
        </div>
    </div>

    <script>
    $('#testarAjax').click(function() {
        console.log('Testando AJAX correto...');
        fetch('vendas_modal.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                acao: 'inserir',
                produto: 'Teste AJAX Correto',
                valor: '50.25',
                data: '<?php echo date('Y-m-d'); ?>',
                id_pedido: 1,
                id_cliente: 1
            })
        })
        .then(response => response.text())
        .then(data => {
            $('#resultado').html('<div class="alert alert-success">AJAX CORRETO - Resposta do vendas_modal.php:<br><pre>' + data + '</pre></div>');
        })
        .catch(error => {
            $('#resultado').html('<div class="alert alert-danger">Erro: ' + error + '</div>');
        });
    });
    
    $('#testarAjaxErrado').click(function() {
        console.log('Testando AJAX errado...');
        fetch('financeiro_clientes_modal.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                acao: 'inserir',
                produto: 'Teste AJAX Errado',
                valor: '50.25',
                data: '<?php echo date('Y-m-d'); ?>',
                id_pedido: 1,
                id_cliente: 1
            })
        })
        .then(response => response.text())
        .then(data => {
            $('#resultado').html('<div class="alert alert-warning">AJAX ERRADO - Resposta do financeiro_clientes_modal.php:<br><pre>' + data + '</pre></div>');
        })
        .catch(error => {
            $('#resultado').html('<div class="alert alert-danger">Erro: ' + error + '</div>');
        });
    });
    </script>
</body>
</html>
