<?php
// Arquivo de teste para verificar a estrutura da tabela empresas
require_once 'dbconfig.php';

echo "<h3>Teste de Estrutura da Tabela Empresas</h3>";

// Verificar se a conexão está funcionando
if (!$conn) {
    die("Erro de conexão: " . mysqli_connect_error());
}

echo "<p>✅ Conexão com banco estabelecida</p>";

// Verificar a estrutura da tabela empresas
echo "<h4>Estrutura da tabela 'empresas':</h4>";
$result = $conn->query("DESCRIBE empresas");

if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Chave</th><th>Padrão</th><th>Extra</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Erro ao obter estrutura da tabela: " . $conn->error . "</p>";
}

// Contar quantas empresas existem
echo "<h4>Total de empresas cadastradas:</h4>";
$result = $conn->query("SELECT COUNT(*) as total FROM empresas");
if ($result) {
    $row = $result->fetch_assoc();
    echo "<p>Total: " . $row['total'] . " empresas</p>";
} else {
    echo "<p>❌ Erro ao contar empresas: " . $conn->error . "</p>";
}

// Listar algumas empresas
echo "<h4>Primeiras 5 empresas:</h4>";
$result = $conn->query("SELECT * FROM empresas LIMIT 5");
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Empresa</th><th>Data</th><th>Hora</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['empresa'] . "</td>";
        echo "<td>" . $row['data'] . "</td>";
        echo "<td>" . $row['hora'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Erro ao listar empresas: " . $conn->error . "</p>";
}

// Testar query de inserção (sem executar)
echo "<h4>Teste da query de inserção:</h4>";
$teste_nome = "Empresa Teste";
$teste_data = date("d/m/Y");
$teste_hora = date("H:i");

$stmt = $conn->prepare("INSERT INTO empresas (empresa, data, hora) VALUES (?, ?, ?)");
if ($stmt) {
    echo "<p>✅ Query de inserção preparada com sucesso</p>";
    echo "<p>Query: INSERT INTO empresas (empresa, data, hora) VALUES ('$teste_nome', '$teste_data', '$teste_hora')</p>";
    $stmt->close();
} else {
    echo "<p>❌ Erro ao preparar query de inserção: " . $conn->error . "</p>";
}

// Verificar se a tabela usuarios tem a coluna id_empresa
echo "<h4>Verificando coluna id_empresa na tabela usuarios:</h4>";
$result = $conn->query("DESCRIBE usuarios");
if ($result) {
    $tem_id_empresa = false;
    while ($row = $result->fetch_assoc()) {
        if ($row['Field'] == 'id_empresa') {
            $tem_id_empresa = true;
            echo "<p>✅ Coluna 'id_empresa' encontrada: " . $row['Type'] . "</p>";
            break;
        }
    }
    if (!$tem_id_empresa) {
        echo "<p>❌ Coluna 'id_empresa' NÃO encontrada na tabela usuarios</p>";
    }
} else {
    echo "<p>❌ Erro ao verificar estrutura da tabela usuarios: " . $conn->error . "</p>";
}

$conn->close();
?>
