<?php
include 'includes/tema/topo.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h2>Teste de Debug - Modal Financeiro</h2>
            <p>Esta página testa as correções no modal financeiro para problemas de salvamento de valor e formatação de data.</p>
            
            <div class="alert alert-info">
                <strong>Problemas Corrigidos:</strong>
                <ul>
                    <li>Valor não estava sendo salvo corretamente</li>
                    <li>Data ficava estranha após salvar</li>
                    <li>Formatação inconsistente entre exibição e edição</li>
                </ul>
            </div>
            
            <div class="mb-3">
                <button type="button" class="btn btn-primary" onclick="abrirModalFinanceiro()">
                    <i class="fas fa-money-bill"></i> Abrir Modal Financeiro (Pedido 1)
                </button>
                
                <button type="button" class="btn btn-info" onclick="verificarLogs()">
                    <i class="fas fa-bug"></i> Verificar Logs de Debug
                </button>
            </div>
            
            <div class="alert alert-warning">
                <strong>Como testar:</strong>
                <ol>
                    <li>Abra o modal financeiro</li>
                    <li>Edite um valor existente (clique no valor)</li>
                    <li>Altere o valor e a data</li>
                    <li>Clique no botão verde para salvar</li>
                    <li>Verifique se o valor foi salvo corretamente</li>
                    <li>Verifique se a data está no formato correto</li>
                </ol>
            </div>
            
            <div id="modal-content" class="border p-3 mt-3" style="min-height: 400px; background-color: #f8f9fa;">
                <p class="text-muted">Clique no botão acima para carregar o modal financeiro.</p>
            </div>
            
            <div class="mt-3">
                <h4>Logs de Debug</h4>
                <div id="debug-logs" class="border p-3" style="background-color: #000; color: #0f0; font-family: monospace; height: 200px; overflow-y: auto;">
                    <p>Aguardando logs...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function abrirModalFinanceiro() {
    const modalContent = document.getElementById('modal-content');
    modalContent.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Carregando modal financeiro...</div>';
    
    fetch('financeiro_clientes_modal.php?id_pedido=1&id_cliente=1')
        .then(response => response.text())
        .then(html => {
            modalContent.innerHTML = html;
            adicionarLogDebug('Modal financeiro carregado com sucesso');
        })
        .catch(error => {
            modalContent.innerHTML = '<div class="alert alert-danger">Erro ao carregar modal: ' + error + '</div>';
            adicionarLogDebug('Erro ao carregar modal: ' + error);
        });
}

function verificarLogs() {
    // Capturar logs do console
    const originalLog = console.log;
    const originalError = console.error;
    
    console.log = function(...args) {
        adicionarLogDebug('LOG: ' + args.join(' '));
        originalLog.apply(console, args);
    };
    
    console.error = function(...args) {
        adicionarLogDebug('ERROR: ' + args.join(' '));
        originalError.apply(console, args);
    };
    
    adicionarLogDebug('Captura de logs ativada');
}

function adicionarLogDebug(mensagem) {
    const debugLogs = document.getElementById('debug-logs');
    const timestamp = new Date().toLocaleTimeString();
    const logEntry = document.createElement('div');
    logEntry.innerHTML = `[${timestamp}] ${mensagem}`;
    debugLogs.appendChild(logEntry);
    debugLogs.scrollTop = debugLogs.scrollHeight;
}

// Ativar captura de logs automaticamente
verificarLogs();
</script>

<?php include 'includes/tema/rodape.php'; ?>