<?php
// Teste simples para verificar se os modais não causam mais conflitos
include 'includes/tema/topo.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h2>Teste de Conflito de Modais</h2>
            <p>Esta página testa se os modais não estão mais causando conflitos de estilo.</p>
            
            <div class="alert alert-info">
                <strong>Teste:</strong> Se você conseguir ver esta página com estilos normais, 
                e os botões abaixo funcionarem corretamente, o problema foi resolvido.
            </div>
            
            <div class="mb-3">
                <button type="button" class="btn btn-primary" onclick="testarModal('vendas')">
                    <i class="fas fa-shopping-cart"></i> Testar Modal Vendas
                </button>
                
                <button type="button" class="btn btn-success" onclick="testarModal('financeiro')">
                    <i class="fas fa-money-bill"></i> Testar Modal Financeiro
                </button>
            </div>
            
            <div id="modal-content" class="border p-3 mt-3" style="min-height: 200px; background-color: #f8f9fa;">
                <p class="text-muted">Clique em um dos botões acima para carregar o conteúdo do modal.</p>
            </div>
        </div>
    </div>
</div>

<script>
function testarModal(tipo) {
    const modalContent = document.getElementById('modal-content');
    modalContent.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>';
    
    let url = '';
    if (tipo === 'vendas') {
        url = 'vendas_modal.php?id_pedido=1&id_cliente=1';
    } else if (tipo === 'financeiro') {
        url = 'financeiro_clientes_modal.php?id_pedido=1&id_cliente=1';
    }
    
    fetch(url)
        .then(response => response.text())
        .then(html => {
            modalContent.innerHTML = html;
        })
        .catch(error => {
            modalContent.innerHTML = '<div class="alert alert-danger">Erro ao carregar modal: ' + error + '</div>';
        });
}
</script>

<?php include 'includes/tema/rodape.php'; ?>