<?php
// Teste que simula exatamente o processo do modal financeiro
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

echo "<h2>Teste Simulando Processo Exato do Modal</h2>";

// Simular exatamente o que acontece no modal
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<h3>Processando POST...</h3>";
    
    $acao = $_POST['acao'];
    $valor_original = $_POST['valor'];
    $valor_processado = str_replace(',', '.', $valor_original);
    
    echo "<p><strong>Ação:</strong> $acao</p>";
    echo "<p><strong>Valor original (do form):</strong> '$valor_original'</p>";
    echo "<p><strong>Valor processado:</strong> '$valor_processado'</p>";
    echo "<p><strong>Tipo do valor processado:</strong> " . gettype($valor_processado) . "</p>";
    
    if ($acao === 'inserir') {
        $sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        
        if ($stmt) {
            $id_pedido = 77777;
            $id_cliente = 1;
            $data = '2024-01-01';
            
            echo "<p><strong>Bind param:</strong> iiss</p>";
            echo "<p><strong>Parâmetros:</strong> id_pedido=$id_pedido, id_cliente=$id_cliente, valor='$valor_processado', data='$data'</p>";
            
            $stmt->bind_param("iiss", $id_pedido, $id_cliente, $valor_processado, $data);
            
            if ($stmt->execute()) {
                $id_inserido = $conn->insert_id;
                echo "<p style='color: green;'>✓ Inserção realizada! ID: $id_inserido</p>";
                
                // Verificar o que foi salvo
                $sql_check = "SELECT valor FROM financeiro_clientes WHERE id = ?";
                $stmt_check = $conn->prepare($sql_check);
                if ($stmt_check) {
                    $stmt_check->bind_param("i", $id_inserido);
                    $stmt_check->execute();
                    $result = $stmt_check->get_result();
                    $row = $result->fetch_assoc();
                    
                    echo "<p><strong>Valor salvo no banco:</strong> '" . $row['valor'] . "'</p>";
                    
                    if ($row['valor'] != $valor_processado) {
                        echo "<p style='color: red; font-size: 18px;'>❌ PROBLEMA ENCONTRADO!</p>";
                        echo "<p>Valor enviado: '$valor_processado'</p>";
                        echo "<p>Valor salvo: '" . $row['valor'] . "'</p>";
                    } else {
                        echo "<p style='color: green;'>✓ Valor salvo corretamente</p>";
                    }
                }
            } else {
                echo "<p style='color: red;'>❌ Erro na inserção: " . $stmt->error . "</p>";
            }
        }
    } elseif ($acao === 'alterar') {
        // Primeiro inserir um registro para alterar
        $conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 77777");
        $conn->query("INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (77777, 1, '10.00', '2024-01-01')");
        $id_para_alterar = $conn->insert_id;
        
        echo "<p>Registro criado para alteração com ID: $id_para_alterar (valor inicial: 10.00)</p>";
        
        $sql = "UPDATE financeiro_clientes SET valor = ?, data2 = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        
        if ($stmt) {
            $data = '2024-01-01';
            
            echo "<p><strong>Bind param:</strong> ssi</p>";
            echo "<p><strong>Parâmetros:</strong> valor='$valor_processado', data='$data', id=$id_para_alterar</p>";
            
            $stmt->bind_param("ssi", $valor_processado, $data, $id_para_alterar);
            
            if ($stmt->execute()) {
                echo "<p style='color: green;'>✓ Alteração realizada!</p>";
                
                // Verificar o que foi salvo
                $sql_check = "SELECT valor FROM financeiro_clientes WHERE id = ?";
                $stmt_check = $conn->prepare($sql_check);
                if ($stmt_check) {
                    $stmt_check->bind_param("i", $id_para_alterar);
                    $stmt_check->execute();
                    $result = $stmt_check->get_result();
                    $row = $result->fetch_assoc();
                    
                    echo "<p><strong>Valor salvo no banco:</strong> '" . $row['valor'] . "'</p>";
                    
                    if ($row['valor'] != $valor_processado) {
                        echo "<p style='color: red; font-size: 18px;'>❌ PROBLEMA ENCONTRADO!</p>";
                        echo "<p>Valor enviado: '$valor_processado'</p>";
                        echo "<p>Valor salvo: '" . $row['valor'] . "'</p>";
                    } else {
                        echo "<p style='color: green;'>✓ Valor alterado corretamente</p>";
                    }
                }
            } else {
                echo "<p style='color: red;'>❌ Erro na alteração: " . $stmt->error . "</p>";
            }
        }
    }
    
    // Limpeza
    $conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 77777");
    echo "<p><em>Registros de teste removidos.</em></p>";
    
} else {
    // Formulário de teste
    echo "<h3>Formulário de Teste</h3>";
    echo "<p>Digite exatamente como você digitaria no modal:</p>";
    
    echo '<form method="POST">';
    echo '<p><label>Valor: <input type="text" name="valor" value="7,50" placeholder="Ex: 7,50"></label></p>';
    echo '<p><label>Ação: ';
    echo '<select name="acao">';
    echo '<option value="inserir">Inserir</option>';
    echo '<option value="alterar">Alterar</option>';
    echo '</select>';
    echo '</label></p>';
    echo '<p><button type="submit">Testar</button></p>';
    echo '</form>';
    
    echo "<h3>Informações do Sistema:</h3>";
    echo "<p><strong>Versão do PHP:</strong> " . phpversion() . "</p>";
    echo "<p><strong>Versão do MySQL:</strong> " . $conn->server_info . "</p>";
    
    // Verificar configurações do MySQL
    echo "<h4>Configurações relevantes do MySQL:</h4>";
    $configs = ['sql_mode', 'version'];
    foreach ($configs as $config) {
        $result = $conn->query("SHOW VARIABLES LIKE '$config'");
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            echo "<p><strong>" . $row['Variable_name'] . ":</strong> " . $row['Value'] . "</p>";
        }
    }
}

?>