<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste Modal Financeiro - Corrigido</title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables com Bootstrap 5 -->
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h2>Teste Modal Financeiro - Versão Corrigida</h2>
        
        <div class="alert alert-info">
            <h5>Instruções de Teste:</h5>
            <ol>
                <li>Clique no botão abaixo para abrir o modal financeiro</li>
                <li>Tente editar um valor existente (clique no ícone de editar)</li>
                <li>Modifique o valor e a data</li>
                <li>Clique em salvar e verifique se a atualização funciona</li>
                <li>Verifique se não aparece mais a mensagem "Nenhuma linha foi atualizada"</li>
            </ol>
        </div>
        
        <div class="alert alert-success">
            <h5>Correções Aplicadas:</h5>
            <ul>
                <li>✓ Corrigido bind_param de "dsi" para "ssi" (valor como string)</li>
                <li>✓ Adicionada verificação de existência do registro antes do UPDATE</li>
                <li>✓ Melhorada a formatação de valores no JavaScript</li>
                <li>✓ Corrigida conversão de datas entre formatos</li>
            </ul>
        </div>
        
        <!-- Botões de teste -->
        <div class="mb-3">
            <button type="button" class="btn btn-primary" onclick="abrirModalFinanceiro(1, 1)">
                <i class="fas fa-money-bill"></i> Abrir Modal Financeiro (Pedido 1, Cliente 1)
            </button>
            
            <button type="button" class="btn btn-info" onclick="abrirModalFinanceiro(2, 2)">
                <i class="fas fa-money-bill"></i> Abrir Modal Financeiro (Pedido 2, Cliente 2)
            </button>
            
            <a href="teste_debug_update.php" class="btn btn-warning" target="_blank">
                <i class="fas fa-bug"></i> Ver Debug da Tabela
            </a>
        </div>
        
        <!-- Logs de teste -->
        <div class="card">
            <div class="card-header">
                <h5>Logs de Teste</h5>
            </div>
            <div class="card-body">
                <div id="logs" class="bg-light p-3" style="height: 200px; overflow-y: auto; font-family: monospace; font-size: 12px;">
                    <div>Sistema iniciado - aguardando testes...</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Container -->
    <div id="modalContainer"></div>
    
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        function log(message) {
            const logs = document.getElementById('logs');
            const time = new Date().toLocaleTimeString();
            logs.innerHTML += `<div>[${time}] ${message}</div>`;
            logs.scrollTop = logs.scrollHeight;
        }
        
        function abrirModalFinanceiro(idPedido, idCliente) {
            log(`Abrindo modal financeiro para Pedido ${idPedido}, Cliente ${idCliente}`);
            
            fetch(`financeiro_clientes_modal.php?id_pedido=${idPedido}&id_cliente=${idCliente}`)
                .then(response => response.text())
                .then(html => {
                    document.getElementById('modalContainer').innerHTML = html;
                    
                    // Criar e mostrar o modal
                    const modalElement = document.querySelector('#modalFinanceiroClientes');
                    if (modalElement) {
                        const modal = new bootstrap.Modal(modalElement);
                        modal.show();
                        log('Modal carregado e exibido com sucesso');
                        
                        // Interceptar chamadas fetch para log
                        const originalFetch = window.fetch;
                        window.fetch = function(...args) {
                            if (args[0].includes('financeiro_clientes_modal.php') && args[1] && args[1].method === 'POST') {
                                log('Enviando requisição POST para salvar dados...');
                            }
                            return originalFetch.apply(this, args)
                                .then(response => {
                                    if (args[0].includes('financeiro_clientes_modal.php') && args[1] && args[1].method === 'POST') {
                                        return response.clone().json().then(data => {
                                            if (data.success) {
                                                log('✓ Dados salvos com sucesso: ' + data.message);
                                            } else {
                                                log('✗ Erro ao salvar: ' + data.message);
                                            }
                                            return response;
                                        });
                                    }
                                    return response;
                                });
                        };
                    } else {
                        log('✗ Erro: Modal não encontrado no HTML retornado');
                    }
                })
                .catch(error => {
                    log('✗ Erro ao carregar modal: ' + error.message);
                    console.error('Erro:', error);
                });
        }
        
        // Log inicial
        log('Página carregada - pronta para testes');
    </script>
</body>
</html>