<?php
include 'dbconfig.php';

echo "<h2>Teste de Precisão de Centavos - Corrigido</h2>";

// Valores específicos para testar
$valores_teste = [
    '71.50',
    '85.75', 
    '123.45',
    '999.99',
    '0.01',
    '1234.56',
    '10.05',
    '50.25'
];

echo "<h3>1. Teste de Inserção com Precisão</h3>";

// Buscar um pedido válido
$sql_pedido = "SELECT id FROM pedidos LIMIT 1";
$result_pedido = mysqli_query($conn, $sql_pedido);

if ($result_pedido && mysqli_num_rows($result_pedido) > 0) {
    $pedido = mysqli_fetch_assoc($result_pedido);
    $id_pedido_teste = $pedido['id'];
    $id_cliente_teste = 1;
    
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Valor Original</th><th>Valor Inserido</th><th>Valor Recuperado</th><th>Precisão</th></tr>";
    
    foreach ($valores_teste as $valor_original) {
        // Simular o processo do modal: converter vírgula para ponto
        $valor_para_banco = str_replace(',', '.', $valor_original);
        
        // Inserir usando string (como corrigido)
        $sql_insert = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql_insert);
        
        if ($stmt) {
            $data_teste = date('Y-m-d');
            $stmt->bind_param("iiss", $id_pedido_teste, $id_cliente_teste, $valor_para_banco, $data_teste);
            
            if ($stmt->execute()) {
                $id_inserido = $conn->insert_id;
                
                // Recuperar valor
                $sql_select = "SELECT valor FROM financeiro_clientes WHERE id = ?";
                $stmt_select = $conn->prepare($sql_select);
                $stmt_select->bind_param("i", $id_inserido);
                $stmt_select->execute();
                $result_select = $stmt_select->get_result();
                $row_select = $result_select->fetch_assoc();
                
                $valor_recuperado = $row_select['valor'];
                
                // Verificar precisão
                $precisao_ok = (number_format($valor_para_banco, 2, '.', '') == number_format($valor_recuperado, 2, '.', ''));
                $status = $precisao_ok ? '✅ OK' : '❌ ERRO';
                
                echo "<tr>";
                echo "<td>$valor_original</td>";
                echo "<td>$valor_para_banco</td>";
                echo "<td>$valor_recuperado</td>";
                echo "<td>$status</td>";
                echo "</tr>";
                
                // Limpar teste
                $sql_delete = "DELETE FROM financeiro_clientes WHERE id = ?";
                $stmt_delete = $conn->prepare($sql_delete);
                $stmt_delete->bind_param("i", $id_inserido);
                $stmt_delete->execute();
                
            } else {
                echo "<tr><td>$valor_original</td><td colspan='3'>Erro: " . $stmt->error . "</td></tr>";
            }
        }
    }
    echo "</table><br>";
    
    echo "<h3>2. Teste de Atualização com Precisão</h3>";
    
    // Inserir um registro para testar atualização
    $valor_inicial = '100.00';
    $sql_insert = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql_insert);
    $stmt->bind_param("iiss", $id_pedido_teste, $id_cliente_teste, $valor_inicial, date('Y-m-d'));
    
    if ($stmt->execute()) {
        $id_teste = $conn->insert_id;
        
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Valor Original</th><th>Valor para Update</th><th>Valor Recuperado</th><th>Precisão</th></tr>";
        
        foreach ($valores_teste as $valor_original) {
            $valor_para_banco = str_replace(',', '.', $valor_original);
            
            // Atualizar usando string (como corrigido)
            $sql_update = "UPDATE financeiro_clientes SET valor = ? WHERE id = ?";
            $stmt_update = $conn->prepare($sql_update);
            $stmt_update->bind_param("si", $valor_para_banco, $id_teste);
            
            if ($stmt_update->execute()) {
                // Recuperar valor atualizado
                $sql_select = "SELECT valor FROM financeiro_clientes WHERE id = ?";
                $stmt_select = $conn->prepare($sql_select);
                $stmt_select->bind_param("i", $id_teste);
                $stmt_select->execute();
                $result_select = $stmt_select->get_result();
                $row_select = $result_select->fetch_assoc();
                
                $valor_recuperado = $row_select['valor'];
                
                // Verificar precisão
                $precisao_ok = (number_format($valor_para_banco, 2, '.', '') == number_format($valor_recuperado, 2, '.', ''));
                $status = $precisao_ok ? '✅ OK' : '❌ ERRO';
                
                echo "<tr>";
                echo "<td>$valor_original</td>";
                echo "<td>$valor_para_banco</td>";
                echo "<td>$valor_recuperado</td>";
                echo "<td>$status</td>";
                echo "</tr>";
            } else {
                echo "<tr><td>$valor_original</td><td colspan='3'>Erro: " . $stmt_update->error . "</td></tr>";
            }
        }
        echo "</table><br>";
        
        // Limpar registro de teste
        $sql_delete = "DELETE FROM financeiro_clientes WHERE id = ?";
        $stmt_delete = $conn->prepare($sql_delete);
        $stmt_delete->bind_param("i", $id_teste);
        $stmt_delete->execute();
        echo "🗑️ Registro de teste removido.<br><br>";
    }
    
} else {
    echo "❌ Nenhum pedido encontrado para teste.<br>";
}

echo "<h3>3. Simulação do Processo Completo do Modal</h3>";
echo "<script>";
echo "console.log('=== SIMULAÇÃO JAVASCRIPT ===');";
echo "var valoresInterface = ['71,50', '85,75', '123,45'];";
echo "valoresInterface.forEach(function(valorInterface) {";
echo "    // Processo do modal: remover pontos e trocar vírgula por ponto";
echo "    var valorParaBanco = valorInterface.replace(/\\./g, '').replace(',', '.');";
echo "    console.log('Interface:', valorInterface, '→ Banco:', valorParaBanco);";
echo "});";
echo "</script>";

echo "<h3>4. Conclusão</h3>";
echo "<p><strong>Correções aplicadas:</strong></p>";
echo "<ul>";
echo "<li>✅ Inserção: bind_param alterado de 'iids' para 'iiss' (string para valor)</li>";
echo "<li>✅ Atualização: bind_param alterado de 'dsi' para 'ssi' (string para valor)</li>";
echo "<li>✅ Remoção de conversão (float) que causava perda de precisão</li>";
echo "<li>✅ Valor tratado como string em todo o processo</li>";
echo "</ul>";

echo "<p><a href='teste_modal_financeiro_corrigido_simples.php'>🔗 Testar Modal Financeiro</a></p>";
?>