<?php
// Teste simples de criação de empresa
require_once 'dbconfig.php';

header('Content-Type: application/json; charset=utf-8');

try {
    if (!$conn) {
        throw new Exception('Conexão com banco falhou: ' . mysqli_connect_error());
    }
    
    echo json_encode(['step' => 1, 'message' => 'Conexão OK'], JSON_UNESCAPED_UNICODE) . "\n";
    
    // Verificar estrutura da tabela empresas
    $result = $conn->query("DESCRIBE empresas");
    if (!$result) {
        throw new Exception('Erro ao verificar estrutura da tabela: ' . $conn->error);
    }
    
    $colunas = [];
    while ($row = $result->fetch_assoc()) {
        $colunas[] = $row['Field'];
    }
    
    echo json_encode(['step' => 2, 'message' => 'Estrutura da tabela', 'colunas' => $colunas], JSON_UNESCAPED_UNICODE) . "\n";
    
    // Testar inserção
    $teste_nome = "Empresa Teste " . date('Y-m-d H:i:s');
    $teste_data = date("d/m/Y");
    $teste_hora = date("H:i");
    
    $stmt = $conn->prepare("INSERT INTO empresas (empresa, data, hora) VALUES (?, ?, ?)");
    if (!$stmt) {
        throw new Exception('Erro ao preparar query: ' . $conn->error);
    }
    
    echo json_encode(['step' => 3, 'message' => 'Query preparada OK'], JSON_UNESCAPED_UNICODE) . "\n";
    
    $stmt->bind_param("sss", $teste_nome, $teste_data, $teste_hora);
    
    echo json_encode(['step' => 4, 'message' => 'Parâmetros vinculados OK'], JSON_UNESCAPED_UNICODE) . "\n";
    
    if (!$stmt->execute()) {
        throw new Exception('Erro ao executar: ' . $stmt->error);
    }
    
    $novo_id = $conn->insert_id;
    
    echo json_encode(['step' => 5, 'message' => 'Empresa criada com sucesso', 'id' => $novo_id], JSON_UNESCAPED_UNICODE) . "\n";
    
    // Limpar o teste
    $conn->query("DELETE FROM empresas WHERE id = $novo_id");
    
    echo json_encode(['step' => 6, 'message' => 'Teste concluído e limpo'], JSON_UNESCAPED_UNICODE) . "\n";
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE) . "\n";
}
?>
