<?php
// Verificação detalhada do campo valor na tabela financeiro_clientes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'dbconfig.php';

echo "<h2>Verificação Detalhada do Campo Valor</h2>";

// 1. Verificar a estrutura exata do campo valor
echo "<h3>1. Estrutura do campo 'valor':</h3>";
$sql = "SELECT COLUMN_NAME, DATA_TYPE, NUMERIC_PRECISION, NUMERIC_SCALE, COLUMN_TYPE 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_SCHEMA = DATABASE() 
        AND TABLE_NAME = 'financeiro_clientes' 
        AND COLUMN_NAME = 'valor'";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo "<table border='1'>";
    echo "<tr><th>Campo</th><th>Valor</th></tr>";
    foreach ($row as $key => $value) {
        echo "<tr><td>$key</td><td>$value</td></tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>Erro ao obter informações do campo</p>";
}

// 2. Teste direto com INSERT e SELECT
echo "<h3>2. Teste direto INSERT/SELECT:</h3>";

// Limpar registros de teste
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 88888");

// Testar inserção direta com diferentes valores
$valores_teste = ['7.50', '7.51', '7.49', '8.00', '71.50'];

foreach ($valores_teste as $valor) {
    echo "<h4>Testando valor: $valor</h4>";
    
    // Inserir
    $sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (88888, 1, ?, '2024-01-01')";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("s", $valor);
        
        if ($stmt->execute()) {
            $id = $conn->insert_id;
            echo "<p>✓ Inserido com ID: $id</p>";
            
            // Buscar o valor inserido
            $sql_select = "SELECT valor FROM financeiro_clientes WHERE id = ?";
            $stmt_select = $conn->prepare($sql_select);
            
            if ($stmt_select) {
                $stmt_select->bind_param("i", $id);
                $stmt_select->execute();
                $result_select = $stmt_select->get_result();
                $row_select = $result_select->fetch_assoc();
                
                echo "<p><strong>Valor inserido:</strong> $valor</p>";
                echo "<p><strong>Valor recuperado:</strong> " . $row_select['valor'] . "</p>";
                
                if ($row_select['valor'] != $valor) {
                    echo "<p style='color: red;'>❌ DIFERENÇA DETECTADA!</p>";
                } else {
                    echo "<p style='color: green;'>✓ Valores iguais</p>";
                }
            }
        } else {
            echo "<p style='color: red;'>❌ Erro na inserção: " . $stmt->error . "</p>";
        }
    }
    
    echo "<hr>";
}

// 3. Verificar se há triggers ou procedures
echo "<h3>3. Verificar triggers na tabela:</h3>";
$sql = "SHOW TRIGGERS LIKE 'financeiro_clientes'";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    echo "<table border='1'>";
    echo "<tr><th>Trigger</th><th>Event</th><th>Table</th><th>Statement</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Trigger'] . "</td>";
        echo "<td>" . $row['Event'] . "</td>";
        echo "<td>" . $row['Table'] . "</td>";
        echo "<td>" . htmlspecialchars($row['Statement']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Nenhum trigger encontrado na tabela financeiro_clientes</p>";
}

// 4. Testar UPDATE
echo "<h3>4. Teste de UPDATE:</h3>";

// Inserir um registro para testar update
$sql = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (88888, 1, '10.00', '2024-01-01')";
if ($conn->query($sql)) {
    $id_update = $conn->insert_id;
    echo "<p>Registro criado para teste de UPDATE com ID: $id_update</p>";
    
    // Testar update com 7.50
    $novo_valor = '7.50';
    $sql_update = "UPDATE financeiro_clientes SET valor = ? WHERE id = ?";
    $stmt_update = $conn->prepare($sql_update);
    
    if ($stmt_update) {
        $stmt_update->bind_param("si", $novo_valor, $id_update);
        
        if ($stmt_update->execute()) {
            echo "<p>✓ UPDATE executado</p>";
            
            // Verificar o valor após update
            $sql_check = "SELECT valor FROM financeiro_clientes WHERE id = ?";
            $stmt_check = $conn->prepare($sql_check);
            
            if ($stmt_check) {
                $stmt_check->bind_param("i", $id_update);
                $stmt_check->execute();
                $result_check = $stmt_check->get_result();
                $row_check = $result_check->fetch_assoc();
                
                echo "<p><strong>Valor antes do UPDATE:</strong> 10.00</p>";
                echo "<p><strong>Valor enviado no UPDATE:</strong> $novo_valor</p>";
                echo "<p><strong>Valor após UPDATE:</strong> " . $row_check['valor'] . "</p>";
                
                if ($row_check['valor'] != $novo_valor) {
                    echo "<p style='color: red;'>❌ PROBLEMA NO UPDATE DETECTADO!</p>";
                } else {
                    echo "<p style='color: green;'>✓ UPDATE funcionou corretamente</p>";
                }
            }
        } else {
            echo "<p style='color: red;'>❌ Erro no UPDATE: " . $stmt_update->error . "</p>";
        }
    }
}

// Limpeza
$conn->query("DELETE FROM financeiro_clientes WHERE id_pedido = 88888");
echo "<p><em>Registros de teste removidos.</em></p>";

?>