<?php
require_once 'dbconfig.php';

try {
    // Buscar algumas vendas para análise
    $stmt = $pdo->prepare("SELECT id, produto, valor, data2 FROM vendas ORDER BY id DESC LIMIT 10");
    $stmt->execute();
    $vendas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Análise dos Dados de Vendas</h2>";
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Produto</th><th>Valor</th><th>Data2 (Raw)</th><th>Data2 (Tipo)</th><th>strtotime()</th><th>Resultado Final</th></tr>";
    
    foreach ($vendas as $venda) {
        echo "<tr>";
        echo "<td>" . $venda['id'] . "</td>";
        echo "<td>" . htmlspecialchars($venda['produto']) . "</td>";
        echo "<td>R$ " . number_format($venda['valor'], 2, ',', '.') . "</td>";
        echo "<td>" . var_export($venda['data2'], true) . "</td>";
        echo "<td>" . gettype($venda['data2']) . "</td>";
        
        $timestamp = strtotime($venda['data2']);
        echo "<td>" . var_export($timestamp, true) . "</td>";
        
        // Aplicar a mesma lógica do modal
        if (!empty($venda['data2']) && $venda['data2'] !== '0000-00-00' && $venda['data2'] !== '1970-01-01') {
            $timestamp = strtotime($venda['data2']);
            if ($timestamp && $timestamp > 0) {
                $resultado = date('d/m/Y', $timestamp);
            } else {
                $resultado = 'Data inválida';
            }
        } else {
            $resultado = 'Sem data';
        }
        
        echo "<td style='font-weight: bold;'>" . $resultado . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Verificar estrutura da tabela
    echo "<h3>Estrutura da Tabela Vendas</h3>";
    $stmt = $pdo->prepare("DESCRIBE vendas");
    $stmt->execute();
    $estrutura = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' style='border-collapse: collapse; margin-top: 20px;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    
    foreach ($estrutura as $campo) {
        echo "<tr>";
        echo "<td>" . $campo['Field'] . "</td>";
        echo "<td>" . $campo['Type'] . "</td>";
        echo "<td>" . $campo['Null'] . "</td>";
        echo "<td>" . $campo['Key'] . "</td>";
        echo "<td>" . $campo['Default'] . "</td>";
        echo "<td>" . $campo['Extra'] . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?>