<?php
include 'dbconfig.php';

echo "<h2>Verificação Detalhada - Campo Valor</h2>";

// Verificar estrutura específica do campo valor
echo "<h3>1. Estrutura do Campo 'valor'</h3>";
$sql = "SHOW COLUMNS FROM financeiro_clientes WHERE Field = 'valor'";
$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    echo "<strong>Campo:</strong> " . $row['Field'] . "<br>";
    echo "<strong>Tipo:</strong> " . $row['Type'] . "<br>";
    echo "<strong>Null:</strong> " . $row['Null'] . "<br>";
    echo "<strong>Key:</strong> " . $row['Key'] . "<br>";
    echo "<strong>Default:</strong> " . $row['Default'] . "<br>";
    echo "<strong>Extra:</strong> " . $row['Extra'] . "<br><br>";
    
    // Analisar o tipo
    $tipo = $row['Type'];
    if (strpos($tipo, 'decimal') !== false) {
        echo "✅ Campo é DECIMAL - adequado para valores monetários<br>";
        preg_match('/decimal\((\d+),(\d+)\)/', $tipo, $matches);
        if ($matches) {
            echo "Precisão total: " . $matches[1] . " dígitos<br>";
            echo "Casas decimais: " . $matches[2] . " dígitos<br>";
        }
    } elseif (strpos($tipo, 'float') !== false || strpos($tipo, 'double') !== false) {
        echo "⚠️ Campo é FLOAT/DOUBLE - pode ter problemas de precisão<br>";
    } else {
        echo "❌ Campo não é adequado para valores monetários: " . $tipo . "<br>";
    }
} else {
    echo "❌ Campo 'valor' não encontrado!<br>";
}

echo "<br><h3>2. Teste de Precisão com Valores Específicos</h3>";

// Testar valores específicos que o usuário mencionou
$valores_teste = [
    '71.50',
    '85.75',
    '123.45',
    '999.99',
    '0.01',
    '1234.56'
];

foreach ($valores_teste as $valor) {
    echo "<strong>Testando valor: $valor</strong><br>";
    
    // Inserir valor de teste
    $sql_insert = "INSERT INTO financeiro_clientes (id_pedido, id_cliente, valor, data2) VALUES (1, 1, ?, NOW())";
    $stmt = $conn->prepare($sql_insert);
    
    if ($stmt) {
        $stmt->bind_param("d", $valor);
        
        if ($stmt->execute()) {
            $id_inserido = $conn->insert_id;
            
            // Recuperar valor
            $sql_select = "SELECT valor FROM financeiro_clientes WHERE id = ?";
            $stmt_select = $conn->prepare($sql_select);
            $stmt_select->bind_param("i", $id_inserido);
            $stmt_select->execute();
            $result_select = $stmt_select->get_result();
            $row_select = $result_select->fetch_assoc();
            
            $valor_recuperado = $row_select['valor'];
            
            echo "Valor inserido: $valor<br>";
            echo "Valor recuperado: $valor_recuperado<br>";
            
            if ($valor == $valor_recuperado) {
                echo "✅ Precisão mantida<br>";
            } else {
                echo "❌ Precisão perdida - diferença: " . ($valor - $valor_recuperado) . "<br>";
            }
            
            // Limpar teste
            $sql_delete = "DELETE FROM financeiro_clientes WHERE id = ?";
            $stmt_delete = $conn->prepare($sql_delete);
            $stmt_delete->bind_param("i", $id_inserido);
            $stmt_delete->execute();
            
        } else {
            echo "❌ Erro ao inserir: " . $stmt->error . "<br>";
        }
    }
    echo "<br>";
}

echo "<h3>3. Recomendação de Estrutura Ideal</h3>";
echo "Para valores monetários, recomenda-se:<br>";
echo "<code>ALTER TABLE financeiro_clientes MODIFY COLUMN valor DECIMAL(10,2);</code><br><br>";
echo "Onde:<br>";
echo "- 10 = total de dígitos (incluindo decimais)<br>";
echo "- 2 = casas decimais<br>";
echo "- Permite valores até 99.999.999,99<br><br>";

echo "<h3>4. Verificar Conversão JavaScript</h3>";
echo "<script>";
echo "console.log('=== TESTE DE CONVERSÃO JAVASCRIPT ===');";
echo "var valores = ['71,50', '85,75', '123,45'];";
echo "valores.forEach(function(valor) {";
echo "    var valorLimpo = valor.replace(/\\./g, '').replace(',', '.');";
echo "    var valorNumerico = parseFloat(valorLimpo);";
echo "    console.log('Original:', valor, '| Limpo:', valorLimpo, '| Numérico:', valorNumerico);";
echo "});";
echo "</script>";

echo "<p><a href='financeiro_clientes_modal.php?id_pedido=1&id_cliente=1'>🔗 Testar Modal</a></p>";
?>