<?php
include 'dbconfig.php';

echo "<h2>Verificando Triggers no Banco de Dados</h2>";

// Verificar triggers na tabela vendas
echo "<h3>Triggers na tabela 'vendas':</h3>";
$sql = "SHOW TRIGGERS LIKE 'vendas'";
$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    echo "<table border='1'>";
    echo "<tr><th>Trigger</th><th>Event</th><th>Table</th><th>Statement</th></tr>";
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Trigger']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Event']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Table']) . "</td>";
        echo "<td><pre>" . htmlspecialchars($row['Statement']) . "</pre></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Nenhum trigger encontrado na tabela vendas</p>";
}

// Verificar triggers na tabela financeiro_clientes
echo "<h3>Triggers na tabela 'financeiro_clientes':</h3>";
$sql = "SHOW TRIGGERS LIKE 'financeiro_clientes'";
$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    echo "<table border='1'>";
    echo "<tr><th>Trigger</th><th>Event</th><th>Table</th><th>Statement</th></tr>";
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Trigger']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Event']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Table']) . "</td>";
        echo "<td><pre>" . htmlspecialchars($row['Statement']) . "</pre></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Nenhum trigger encontrado na tabela financeiro_clientes</p>";
}

// Mostrar todos os triggers do banco
echo "<h3>Todos os triggers do banco:</h3>";
$sql = "SHOW TRIGGERS";
$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    echo "<table border='1'>";
    echo "<tr><th>Trigger</th><th>Event</th><th>Table</th><th>Timing</th></tr>";
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Trigger']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Event']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Table']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Timing']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ Nenhum trigger encontrado no banco</p>";
}

mysqli_close($conn);
?>
