'use strict';
document.addEventListener('DOMContentLoaded', function () {
    setTimeout(function () {
        floatchart();
    }, 500);
});

function floatchart() {
    (function () {
        var options = {
            chart: {
                type: 'area',
                height: 300,
                toolbar: {
                  show: false
                }
              },
              colors: ['#e58a00', '#4680ff'],
              dataLabels: {
                enabled: false
              },
              legend: {
                show: true,
                position: 'top'
              },
              markers: {
                size: 1,
                colors: ['#fff', '#fff', '#fff'],
                strokeColors: ['#e58a00', '#4680ff'],
                strokeWidth: 1,
                shape: 'circle',
                hover: {
                  size: 4
                }
              },
              stroke: {
                width: 1,
                curve: 'smooth'
              },
              fill: {
                type: 'gradient',
                gradient: {
                  shadeIntensity: 1,
                  type: 'vertical',
                  inverseColors: false,
                  opacityFrom: 0.5,
                  opacityTo: 0
                }
              },
              grid: {
                show: false,
              },
              series: [
                {
                  name: 'Revenue',
                  data: [200, 320, 320, 275, 275, 400, 400, 300, 440, 320, 320, 275, 275, 400, 300, 440]
                },
                {
                  name: 'Sales',
                  data: [200, 250, 240, 300, 340, 320, 320, 400, 350, 250, 240, 300, 340, 320, 400, 350]
                }
              ],
              xaxis: {
                labels: {
                  hideOverlappingLabels: true
                },
                axisBorder: {
                  show: false
                },
                axisTicks: {
                  show: false
                }
              }
        };
        var chart = new ApexCharts(document.querySelector("#revenue-analytics-chart"), options);
        chart.render();

        var membership_state_chart_option = {
            series: [76],
            chart: {
                type: 'radialBar',
                offsetY: -20,
                sparkline: {
                enabled: true
                }
            },
            colors: ['#4680ff'],
            plotOptions: {
                radialBar: {
                startAngle: -95,
                endAngle: 95,
                hollow: {
                    margin: 15,
                    size: '40%',
                },
                track: {
                    background: '#4680ff25',
                    strokeWidth: '97%',
                    margin: 10
                },
                dataLabels: {
                    name: {
                    show: false
                    },
                    value: {
                    offsetY: 0,
                    fontSize: '20px'
                    }
                }
                }
            },
            grid: {
                padding: {
                top: 10
                }
            },
            stroke: {
                lineCap: 'round'
            },
            labels: ['Average Results']
        };
        var chart = new ApexCharts(document.querySelector('#membership-state-chart'), membership_state_chart_option);
        chart.render();

        var activity_line_chart_options = {
            chart: {
              type: 'line',
              height: 150,
              toolbar: {
                show: false
              }
            },
            colors: ['#2ca87f', '#2ca87f'],
            dataLabels: {
              enabled: false
            },
            legend: {
              show: true,
              position: 'top',
            },
            markers: {
              size: 1,
              colors: ['#fff', '#fff'],
              strokeColors: ['#2ca87f', '#2ca87f'],
              strokeWidth: 1,
              shape: 'circle',
              hover: {
                size: 4
              }
            },
            fill: {
              opacity:[1,0.3]
            },
            stroke: {
              width: 3,
              curve: 'smooth',
            },
            grid: {
              show: false,
            },
            series: [
              {
                name: 'Active',
                data: [20, 90, 65, 85, 20, 80, 30]
              },
              {
                name: 'Inactive',
                data: [70, 30, 40, 15, 60, 40, 95]
              }
            ],
            xaxis: {
              labels: {
                hideOverlappingLabels: true
              },
              axisBorder: {
                show: false
              },
              axisTicks: {
                show: false
              }
            }
        }
        var chart = new ApexCharts(document.querySelector("#activity-line-chart"), activity_line_chart_options);
        chart.render();
    })();
}