/*
Name: 			Law Firm
Written by: 	Okler Themes - (http://www.okler.net)
Theme Version:	8.3.0
*/

(function( $ ) {

	'use strict';

	// Slider
	$('#revolutionSlider').revolution({
		
					sliderType: 'standard',
					sliderLayout: 'auto',
					responsiveLevels: [575],
					gridheight: [605,760,480,350],
					gridwidth:1920,
					delay: 9000,
					navigation: {
						keyboardNavigation:"off",
						keyboard_direction: "horizontal",
						mouseScrollNavigation:"off",
						onHoverStop:"off",
						touch:{
							touchenabled:"on",
							swipe_threshold: 75,
							swipe_min_touches: 1,
							swipe_direction: "horizontal",
							drag_block_vertical: false
						}
						,
						arrows: {
							style:"zeus",
							enable:true,
							hide_onmobile:true,
							hide_under:600,
							hide_onleave:true,
							hide_delay:200,
							hide_delay_mobile:1200,
							tmp:'<div class="tp-title-wrap">  	<div class="tp-arr-imgholder"></div> </div>',
							left: {
								h_align:"left",
								v_align:"center",
								h_offset:30,
								v_offset:0
							},
							right: {
								h_align:"right",
								v_align:"center",
								h_offset:30,
								v_offset:0
							}
						}
						,
						/* bullets: {
				style:"custom-tp-bullets",
		        enable: true,
		        container:"slider",
		        rtl: false,
		        hide_onmobile: false,
		        hide_onleave: true,
		        hide_delay: 200,
		        hide_delay_mobile: 1200,
		        hide_under: 0,
		        hide_over: 9999,
		        direction:"horizontal",
		        space: 20,       
		        h_align: "center",
		        v_align: "bottom",
		        h_offset: 0,
		        v_offset: 50
			}  */
					},
					viewPort: {
						enable:true,
						outof:"pause",
						visible_area:"80%"
					},
					lazyType:"none",
					parallax: {
						type:"mouse",
						origo:"slidercenter",
						speed:2000,
						levels:[2,3,4,5,6,7,12,16,10,50],
					},
					fullScreenOffsetContainer:"header",
					shadow:0,
					spinner:"off",
					stopLoop:"off",
					stopAfterLoops:-1,
					stopAtSlide:-1,
					shuffle:"off",
					autoHeight:"off",
					hideThumbsOnMobile:"off",
					hideSliderAtLimit:0,
					hideCaptionAtLimit:0,
					hideAllCaptionAtLilmit:0,
					debugMode:false,
					fallbacks: {
						simplifyAll:"off",
						nextSlideOnWindowFocus:"off",
						disableFocusListener:false,
					}
				});

	// Combination Filters
	if($('#combinationFilters').get(0)) {

		$(window).on('load', function() {

			var $grid = $('.team-list').isotope({
				itemSelector: '.isotope-item'
			});

			var filters = {};

			$('.filters').on('click', 'a', function(e) {
				
				e.preventDefault();
				
				var $this = $(this);

				var $buttonGroup = $this.parents('.team-filter-group');
				var filterGroup = $buttonGroup.attr('data-filter-group');
				
				filters[filterGroup] = $this.parent().attr('data-option-value');
				
				var filterValue = concatValues(filters);
				
				$grid.isotope({
					filter: filterValue
				});
			});

			$('.team-filter-group').each(function(i, buttonGroup) {
				var $buttonGroup = $(buttonGroup);
				$buttonGroup.on('click', 'a', function() {
					$buttonGroup.find('.active').removeClass('active');
					$(this).addClass('active');
				});
			});

			var concatValues = function(obj) {
				var value = '';
				for (var prop in obj) {
					value += obj[prop];
				}
				return value;
			}

			$(window).on('resize', function() {
				setTimeout(function() {
					$grid.isotope('layout');
				}, 300);
			});

		});

		

	}

}).apply( this, [ jQuery ]);